// Nerve 64kb intro source (c) '99 Proxium
// you may modify for personal needs or experiments
// you may use the algorithms in non commercial productions if you credit us

//Multitexture polygon filler by Mr.Dsteuz/Proxium
//Last Date: 17 June 1999

typedef struct
{
int x,y,u,v,i,j;
} multitexture_vtx;

multitexture_vtx mpc[3];
unsigned char *texture_img1;

int starti,endi,startj,endj,cstepi,cstepj;
int ilx,jlx,irx,jrx;

void multitexture_hline(int x1,int x2,int u1,int u2,int v1,int v2,int i1,int i2,int j1,int j2,int y)
{
if(y>=cliptop)
{
x1>>=16,x2>>=16,temp=x2-x1;
if(temp!=0)
{
cstepu=(u2-u1)/temp,cstepv=(v2-v1)/temp;
cstepi=(i2-i1)/temp,cstepj=(j2-j1)/temp;
}
if(x1<clipleft)
{
u1+=(clipleft-x1)*cstepu,v1+=(clipleft-x1)*cstepv;
i1+=(clipleft-x1)*cstepi,j1+=(clipleft-x1)*cstepj;
x1=clipleft;
}
if(x2>clipright) x2=clipright;
if((xst=x2-x1)>0)
{
if(transparency==0)
{
_asm {  mov eax,y
        shl eax,6
        mov edi,eax
        shl eax,2
        add edi,eax
        add edi,x1
        shl edi,2
        add edi,offset frame
l1:     mov ebx,0
        mov cx,word ptr u1+1
        mov dx,word ptr v1+1
        add cx,word ptr cstepu+1
        add dx,word ptr cstepv+1
        mov word ptr u1+1,cx
        mov word ptr v1+1,dx
        mov bl,ch
        mov esi,texture_img
        mov bh,dh
        mov cx,word ptr i1+1
        mov eax,[esi+ebx*4]
        mov dx,word ptr j1+1
        and eax,0xfefefefe
        add cx,word ptr cstepi+1
        add dx,word ptr cstepj+1
        mov word ptr i1+1,cx
        mov word ptr j1+1,dx
        mov bl,ch
        mov esi,texture_img1
        mov bh,dh
        add edi,4
        mov ecx,[esi+ebx*4]
        and ecx,0xfefefefe
        add eax,ecx
        shr eax,1
        dec xst
        mov [edi-4],eax
        jnz l1
}
}
else
{
_asm {  mov eax,y
        shl eax,6
        mov edi,eax
        shl eax,2
        add edi,eax
        add edi,x1
        shl edi,2
        add edi,offset frame
l1:     mov ebx,0
        mov cx,word ptr u1+1
        mov dx,word ptr v1+1
        add cx,word ptr cstepu+1
        add dx,word ptr cstepv+1
        mov word ptr u1+1,cx
        mov word ptr v1+1,dx
        mov bl,ch
        mov esi,texture_img
        mov bh,dh
        mov cx,word ptr i1+1
        mov eax,[esi+ebx*4]
        mov dx,word ptr j1+1
        add cx,word ptr cstepi+1
        add dx,word ptr cstepj+1
        mov word ptr i1+1,cx
        mov word ptr j1+1,dx
        mov bl,ch
        mov esi,texture_img1
        mov bh,dh
        mov ecx,[esi+ebx*4]
        add al,cl
        jnc l2
        mov al,255
l2:     mov [edi],al
        add ah,ch
        jnc l3
        mov ah,255
l3:     mov [edi+1],ah
        ror eax,8
        ror ecx,8
        add ah,ch
        jnc l4
        mov ah,255
l4:     mov [edi+2],ah
        add edi,4
        dec xst
        jnz l1
}
}
}
}
}

void multitexture_poly(unsigned char *texture1,unsigned char *texture2,int trns)
{
texture_img=texture1,texture_img1=texture2,transparency=trns;
if(mpc[0].y>mpc[1].y)
{
temp=mpc[1].x,mpc[1].x=mpc[0].x,mpc[0].x=temp;
temp=mpc[1].y,mpc[1].y=mpc[0].y,mpc[0].y=temp;
temp=mpc[1].u,mpc[1].u=mpc[0].u,mpc[0].u=temp;
temp=mpc[1].v,mpc[1].v=mpc[0].v,mpc[0].v=temp;
temp=mpc[1].i,mpc[1].i=mpc[0].i,mpc[0].i=temp;
temp=mpc[1].j,mpc[1].j=mpc[0].j,mpc[0].j=temp;
}
if(mpc[1].y>mpc[2].y)
{
temp=mpc[2].x,mpc[2].x=mpc[1].x,mpc[1].x=temp;
temp=mpc[2].y,mpc[2].y=mpc[1].y,mpc[1].y=temp;
temp=mpc[2].u,mpc[2].u=mpc[1].u,mpc[1].u=temp;
temp=mpc[2].v,mpc[2].v=mpc[1].v,mpc[1].v=temp;
temp=mpc[2].i,mpc[2].i=mpc[1].i,mpc[1].i=temp;
temp=mpc[2].j,mpc[2].j=mpc[1].j,mpc[1].j=temp;
}
if(mpc[0].y>mpc[1].y)
{
temp=mpc[1].x,mpc[1].x=mpc[0].x,mpc[0].x=temp;
temp=mpc[1].y,mpc[1].y=mpc[0].y,mpc[0].y=temp;
temp=mpc[1].u,mpc[1].u=mpc[0].u,mpc[0].u=temp;
temp=mpc[1].v,mpc[1].v=mpc[0].v,mpc[0].v=temp;
temp=mpc[1].i,mpc[1].i=mpc[0].i,mpc[0].i=temp;
temp=mpc[1].j,mpc[1].j=mpc[0].j,mpc[0].j=temp;
}
if((mpc[2].y-mpc[0].y)!=0)
{
startx=mpc[0].x<<16,endx=startx;
startu=mpc[0].u<<16,endu=startu,startv=mpc[0].v<<16,endv=startv;
starti=mpc[0].i<<16,endi=starti,startj=mpc[0].j<<16,endj=startj;
temp=mpc[2].y-mpc[0].y;
lx=((mpc[2].x-mpc[0].x)<<16)/temp;
ulx=((mpc[2].u-mpc[0].u)<<16)/temp;
vlx=((mpc[2].v-mpc[0].v)<<16)/temp;
ilx=((mpc[2].i-mpc[0].i)<<16)/temp;
jlx=((mpc[2].j-mpc[0].j)<<16)/temp;
if((mpc[1].y-mpc[0].y)!=0)
{
temp=mpc[1].y-mpc[0].y;
rx=((mpc[1].x-mpc[0].x)<<16)/temp;
urx=((mpc[1].u-mpc[0].u)<<16)/temp;
vrx=((mpc[1].v-mpc[0].v)<<16)/temp;
irx=((mpc[1].i-mpc[0].i)<<16)/temp;
jrx=((mpc[1].j-mpc[0].j)<<16)/temp;
while((mpc[1].y>mpc[0].y)&&(mpc[0].y<clipbottom))
{
if(startx<endx) multitexture_hline(startx,endx,endu,startu,endv,startv,endi,starti,endj,startj,mpc[0].y);
else multitexture_hline(endx,startx,startu,endu,startv,endv,starti,endi,startj,endj,mpc[0].y);
startx+=rx,endx+=lx;
startu+=ulx,endu+=urx;
startv+=vlx,endv+=vrx;
starti+=ilx,endi+=irx;
startj+=jlx,endj+=jrx;
mpc[0].y++;
}
}
if((mpc[2].y-mpc[1].y)!=0)
{
startx=mpc[1].x<<16;
endu=mpc[1].u<<16,endv=mpc[1].v<<16;
endi=mpc[1].i<<16,endj=mpc[1].j<<16;
temp=mpc[2].y-mpc[1].y;
rx=((mpc[2].x-mpc[1].x)<<16)/temp;
urx=((mpc[2].u-mpc[1].u)<<16)/temp;
vrx=((mpc[2].v-mpc[1].v)<<16)/temp;
irx=((mpc[2].i-mpc[1].i)<<16)/temp;
jrx=((mpc[2].j-mpc[1].j)<<16)/temp;
while((mpc[2].y>mpc[1].y)&&(mpc[1].y<clipbottom))
{
if(startx<endx) multitexture_hline(startx,endx,endu,startu,endv,startv,endi,starti,endj,startj,mpc[1].y);
else multitexture_hline(endx,startx,startu,endu,startv,endv,starti,endi,startj,endj,mpc[1].y);
startx+=rx,endx+=lx;
startu+=ulx,endu+=urx;
startv+=vlx,endv+=vrx;
starti+=ilx,endi+=irx;
startj+=jlx,endj+=jrx;
mpc[1].y++;
}
}
}
}