// Nerve 64kb intro source (c) '99 Proxium
// you may modify for personal needs or experiments
// you may use the algorithms in non commercial productions if you credit us

/*      3d procedures

        radixsort(int *source,int *temp, int n) - Radix
        tables()                                - EnvMap
*/

// Radix --------------------------------------------------------

        short count[256];
        short index[256];

void radix (int byte, int N,int *source,int *dest)
{
        memset(count,0,sizeof(count));

        for ( int i=0; i<N; i++ )
{       int b=source[i*2+1];
        int c=byte*8;
        int d=b>>c&0xff;
        count[d]++;
}
        index[0]=0;

        for ( i=1; i<256; i++ ) index[i]=index[i-1]+count[i-1];
        for ( i=0; i<N; i++ )
{       int b=source[i*2+1];
        int c=byte*8;
        int e=b>>c&0xff;
        int d=index[e]++;
        int k=i*2;
        int k1=d*2;
        dest[k1]=source[k];
        dest[k1+1]=source[k+1];
}}

void radixsort (int *source,int *temp, int N)
{
        radix (0, N, source, temp);
        radix (1, N, temp, source);
        radix (2, N, source, temp);
        radix (3, N, temp, source);
}

// EnvMap -------------------------------------------------------

int nn[5000*3]; //normals
int rn[5000*3]; //normals

struct vector{                 //Vector stucture
              int x;
              int y;
              int z;
             };
vector cut_2_vector(int x,int y,int z,int x1,int y1,int z1);
vector vec_mul(vector a, vector b);
vector vec_add(vector a, vector b);
float  vec_cos(vector a, vector b);
float  vec_len(vector a);
void tables();

vector cut_2_vec(int x, int y, int z, int x1, int y1, int z1)
{
 vector a;
 a.x=x1-x;
 a.y=y1-y;
 a.z=z1-z;
 return a;
}

vector vec_mul(vector a, vector b)
{
 vector c;
 c.x=a.y*b.z-b.y*a.z;
 c.y=-(a.x*b.z-b.x*a.z);
 c.z=a.x*b.y-b.x*a.y;
 return c;
}

vector vec_add(vector a, vector b)
{
 vector d;
 d.x=(a.x+b.x)/2;
 d.y=(a.y+b.y)/2;
 d.z=(a.z+b.z)/2;

 float n=160/(sqrt(d.x*d.x+d.y*d.y+d.z*d.z));
 d.x=n*d.x;
 d.y=n*d.y;
 d.z=n*d.z;
 return d;
}

float vec_cos(vector a, vector b)
{
 float c,n1,n2;
 n1=sqrt((float)a.x*a.x + (float)a.y*a.y + (float)a.z*a.z );
 n2=sqrt((float)b.x*b.x + (float)b.y*b.y + (float)b.z*b.z );
 if ((n1==0)||(n2==0)) c=1;
 else c=(a.x*b.x + a.y*b.y + a.z*b.z )/(n1*n2);
 return c;
}

void tables(int *pols,int psm,int *vers,int vsm)
{
 for (int i=0; i<vsm*3; i++)
 {
  nn[i]=0;
 }

 for (i=0; i<psm; i++)
 {
  int a=i*3,a1=pols[a]*3,a2=pols[a+1]*3,a3=pols[a+2]*3;
  vector ii,jj,ij,d;

  ii=cut_2_vec(vers[a1],vers[1+a1],vers[2+a1],vers[a2],vers[1+a2],vers[2+a2]);
  jj=cut_2_vec(vers[a2],vers[1+a2],vers[2+a2],vers[a3],vers[1+a3],vers[2+a3]);
  ij=vec_mul(ii,jj);

  d.x=nn[a1];
  d.y=nn[a1+1];
  d.z=nn[a1+2];
  d=vec_add(d,ij);
  nn[a1]=d.x;
  nn[a1+1]=d.y;
  nn[a1+2]=d.z;

  d.x=nn[a2];
  d.y=nn[a2+1];
  d.z=nn[a2+2];
  d=vec_add(d,ij);
  nn[a2]=d.x;
  nn[a2+1]=d.y;
  nn[a2+2]=d.z;

  d.x=nn[a3];
  d.y=nn[a3+1];
  d.z=nn[a3+2];
  d=vec_add(d,ij);
  nn[a3]=d.x;
  nn[a3+1]=d.y;
  nn[a3+2]=d.z;
 }
}

// 3d Rotator -----------------------------------------------------

void rotate(int *source,int *dest,float alpX,float alpY,float alpZ,int len,float mul1,float mul2)
{
        int x1,x2,y1,y2,z1,z2;
        for(int i=0;i<len*3;i+=3)
{       x1=source[i]*mul1;
        y1=source[i+1]*mul1;
        z1=source[i+2]*mul1;

        z2=(z1*cos(alpY*pi/128)-x1*sin(alpY*pi/128));
        x2=(z1*sin(alpY*pi/128)+x1*cos(alpY*pi/128));
        y2=y1;
        y1=(y2*cos(alpX*pi/128)-z2*sin(alpX*pi/128));
        z1=(y2*sin(alpX*pi/128)+z2*cos(alpX*pi/128));
        x1=x2;
        x2=(x1*cos(alpZ*pi/128)-y1*sin(alpZ*pi/128));
        y2=(x1*sin(alpZ*pi/128)+y1*cos(alpZ*pi/128));
        z2=z1;

        x2+=movX;
        y2+=movY;
        z2+=movZ;

        dest[i]=(x2*800/(800-z2*3*mul2));
        dest[i+1]=(y2*800/(800-z2*3*mul2));
        dest[i+2]=0x8000+z2;//*mul2;
}}
