// Nerve 64kb intro source (c) '99 Proxium
// you may modify for personal needs or experiments
// you may use the algorithms in non commercial productions if you credit us

#define xk 16
#define yk 16

#define  kpsum xk*yk*2
#define  kvsum (xk+1)*yk

int      kpolys[kpsum*3];
int      kverts[kvsum*3];

void init_ktab2()
{
        float a1,a2,a3;
        for(int a=0;a<(xk+1);a++)
{       for(int b=0;b<yk;b++)
{       int r=64*sin(a*pi/xk);
        a1=r*cos(b*pi/(yk/2));
        a2=64*cos(a*pi/xk);
        a3=r*sin(b*pi/(yk/2));

#define maxxx 54//53.3333333333333335

        float maxx1=1.3+.7*sin(alpzz*pi/64);
        float maxx2=1.3+.7*sin((alpzz+21)*pi/48);
        float maxx3=1.3+.7*sin((alpzz+43)*pi/96);

        if(a1<-maxxx||a1>maxxx) a1*=maxx1;
        if(a2<-maxxx||a2>maxxx) a2*=maxx2;
        if(a3<-maxxx||a3>maxxx) a3*=maxx3;

        kverts[(b+a*yk)*3]=a1;
        kverts[(b+a*yk)*3+1]=a2;
        kverts[(b+a*yk)*3+2]=a3;
}
}}

void init_ktab()
{
        int a1,a2,a3;
        for(int a=0;a<xk;a++)                       // Calculate shfere
        for(int b=0;b<yk;b++)
{       kpolys[(b+a*yk)*6]=b+a*yk;
        kpolys[(b+a*yk)*6+5]=b+a*yk;
        kpolys[(b+a*yk)*6+1]=b+a*yk+yk;

        a1=b+1;
        a3=a*yk+(yk+1);
        if(b==(yk-1)) a1-=yk,a3-=yk;

        kpolys[(b+a*yk)*6+4]=a1+a*yk;
        kpolys[(b+a*yk)*6+2]=b+a3;
        kpolys[(b+a*yk)*6+3]=b+a3;
}}

void main_krest()
{
        rotate(kverts,vertr,alpX,alpY,alpZ,kvsum,1,1);
        rotate(nn,rn,alpX,alpY,alpZ,kvsum,1,1);

        for(int i=0;i<kpsum;i++)
{       a1=kpolys[i*3]*3,a2=kpolys[i*3+1]*3,a3=kpolys[i*3+2]*3;
        rdx1[i*2]=i;
        rdx1[i*2+1]=400+(vertr[a1+2]+vertr[a2+2]+vertr[a3+2])/3;
}
        radixsort(rdx1,rdx2,kpsum);

        for(i=0;i<kpsum;i++)
{       int a=rdx2[i*2]*3;
        a1=kpolys[a]*3,a2=kpolys[a+1]*3,a3=kpolys[a+2]*3;

        mpc[0].x=160+vertr[a1];
        mpc[0].y=100+vertr[a1+1];
        mpc[1].x=160+vertr[a2];
        mpc[1].y=100+vertr[a2+1];
        mpc[2].x=160+vertr[a3];
        mpc[2].y=100+vertr[a3+1];

        mpc[0].i=128+rn[a1];
        mpc[0].j=128+rn[a1+1];
        mpc[1].i=128+rn[a2];
        mpc[1].j=128+rn[a2+1];
        mpc[2].i=128+rn[a3];
        mpc[2].j=128+rn[a3+1];

        mpc[0].u=128+kverts[a1]*2;
        mpc[0].v=128+kverts[a1+1]*2;
        mpc[1].u=128+kverts[a2]*2;
        mpc[1].v=128+kverts[a2+1]*2;
        mpc[2].u=128+kverts[a3]*2;
        mpc[2].v=128+kverts[a3+1]*2;

        if(((mpc[2].x-mpc[0].x)*(mpc[1].y-mpc[0].y)-(mpc[1].x-mpc[0].x)*(mpc[2].y-mpc[0].y))>=0)
{       multitexture_poly(krtxt2,krtxt1,1);
}
}}

void init_krest()
{
        tcreate(krtxt1t,krtxt2);
        tcreate(krtxt2t,krtxt3);

_asm{   mov esi,offset lnsimg2
        mov edi,offset krtxt1
        mov ch,128
m1:     mov dh,2
m2:     push esi
        mov cl,128
m3:     mov eax,[esi]
        add al,al //0x38
        jnc m6
        mov al,255
m6:     ror eax,8
        add al,al //0x38
        jnc m4
        mov al,255
m4:     add ah,ah //0x38
        jnc m5
        mov ah,255
m5:     rol eax,8
        mov [edi],eax
        mov [edi+4],eax
        add esi,4
        add edi,8
        dec cl
        jnz m3
        pop esi
        dec dh
        jnz m2
        add esi,512
        dec ch
        jnz m1
}
        for(int i=0;i<10;i++) blur256(krtxt1);
        init_ktab();
}

void krest()
{
        int poz;
        while(xmpGetPos()<0x1a00);
        pal=1,colup=255,way=-5;
        float timerbeg=xmpGetTimer();
        for(;;)
{
        float tmm=xmpGetTimer()-timerbeg;
        tmm=tmm/1193046*45;
        tmm+=200;

        poz=xmpGetPos();
        if(poz>0x1b7e) break;

        sphere(krtxt3);

        alpX=30*sin(alpz2*pi/32);
        alpY=tmm;
        alpZ=tmm*0.6;

        alpzz=tmm*.8;
        alpz2=tmm*.5;

        init_ktab2();
        tables(kpolys,kpsum,kverts,kvsum);

        main_krest();
        if(colup!=0) color_up(colup,frame,0);
        flip(frame,0);
}
}