// PNG decoding example for SEGA Saturn
// Mic, 2009

#include <stdio.h>
#include <stdlib.h>
#include "vdp.h"
#include "dpngsat.h"


extern char image, image_end;

char scanlineBuffer[320*3];


int main()
{
	int i;
	vu16 *vdp2VRAM;

	MPOFN = 0;
	SCYDN0 = 0;
	SCYIN0 = 0;
	SCXDN0 = 0;
	SCXIN0 = 0;
	CHCTLA = 0x32;		// 15-bit mode for NBG0
	BGON = 0x101;
	TVMD = 0x8010;		// Screen on, 320x240 pixels

	// Clear NBG0
    wait_vblank_out();
    wait_vblank_in();
	vdp2VRAM = (vu16*)VDP2_VRAM;

	for (i = 0; i < 512*256; i++)
	{
		*vdp2VRAM++ = 0;
	}

    for(;;)
    {
        wait_vblank_out();
        wait_vblank_in();

		read_png(&image,				// Pointer to the PNG data
		         (&image_end)-(&image),	// Size of PNG data
		         (vu16*)(VDP2_VRAM+80),	// Destination pointer, offset by 40 pixels since the image only is 240 pixels wide
		         (vu16*)scanlineBuffer,	// Scanline buffer used for holding the the 24-bit RGB triplets for each pixel
		         512*2);				// Width of NBG0 * sizeof(one pixel)

     }

	return 0;
}


