; VGM player for the NeoGeo Pocket
; Z80 VGM playback driver (for NGP(C) songs)
;
; /Mic, 2012


.MEMORYMAP
	DEFAULTSLOT 0
	SLOTSIZE $1000
	SLOT 0 $0000
.ENDME

.ROMBANKSIZE $1000
.ROMBANKS 1
.BANK 0 SLOT 0
.ORGA $00


; Sound registers
;
.define REG_CH4 $4000
.define REG_CH123 $4001


.define VGM_BUFFER_READ_POS $8000


; VGM commands recognized by the driver
;
.define CMD_GG_STEREO		$4F
.define CMD_PSG			$50
.define CMD_FM			$51
.define CMD_WAIT		$61
.define CMD_WAIT_FRAME_NTSC	$62
.define CMD_WAIT_FRAME_PAL	$63
.define CMD_END			$66



di
im 	1
jp 	vgm_play
; The above 3 instructions take up the first 6 bytes in the table (which are unused anyway)


.ORGA $80
VGM_RESTART: .db 0


vgm_play:
	ld	hl,VGM_DATA_BUFFER-4
	ld	sp,hl

        ld	hl,0
        ld	a,0
        ld	(SAMPLE_DRIFT),hl
        ld	(CH1_PER),hl
        ld	(CH2_PER),hl
        ld	(CH3_PER),hl
        ld	(CUR_CHN),a
        ld	(NOISE_CFG),a
        
	ld	bc,VGM_DATA_BUFFER
	ld	iy,vgm_jump_table

vgm_play_loop:
	ld	a,c			; 4
	ld	(VGM_BUFFER_READ_POS),a	; 13
	ld	a,(bc)			; 7. Read one byte from the VGM data buffer
	inc	c			; 4
	ld	ixh,a			; 8. Save the VGM command in IXH
    	add     a,$D0 			; 7. subtract 0x30
    	rlca            		; 4. multiply by 2
    	ld      iyl,a   		; 8
    	ld      l,(iy+0) 		; 19. Load HL with command handler address
    	ld      h,(iy+1) 		; 19
	jp      (hl)    		; 4. Jump to the handler (tot 97 cycles)
	

vgm_psg_write:
	ld 	a,(bc)			; 7
	inc	c			; 4
	ld	(REG_CH123),a		; 13
	ld	a,(SAMPLE_DRIFT)	; 13
	add	a,3			; 7
	ld	(SAMPLE_DRIFT),a	; 13
	ld	ix,(0)			; 20. delay
	ld	hl,0			; 10. delay
	ld	a,(CUR_CHN)		; 13. delay
	jp	vgm_play_loop		; 10 (110, 207)

vgm_psg2_write:
	ld 	a,(bc)			; 7
	inc	c			; 4
	ld	(REG_CH4),a		; 13
	ld	a,(SAMPLE_DRIFT)	; 13
	add	a,3			; 7
	ld	(SAMPLE_DRIFT),a	; 13
	ld	ix,(0)			; 20. delay
	ld	hl,0			; 10. delay
	ld	a,(CUR_CHN)		; 13. delay
	jp	vgm_play_loop		; 10 (110, 207)
	
	
vgm_end:
	ld	a,1
	ld	(VGM_RESTART),a
-:
	ld	a,(VGM_RESTART)
	and	a
	jr	nz,-
	jp	vgm_play_loop



vgm_short_wait:
	ld	a,ixh	; 8
	and	$0F	    ; 7
	jp	z,vgm_play_loop	; 10
	
	; 69 cycles/iteration
-:
	ld	ix,(0)	; 20
	ld	ix,(0)	; 20
	inc	ixh	; 8
	and	$0F	; 7
	dec	a	; 4
	jp	nz,-	; 10
	jp	vgm_play_loop ; 10


vgm_wait:
	ld	a,(bc)		; 7
	inc	c		; 4
	ld	e,a		; 4
	ld	a,(bc)		; 7
	inc	c		; 4
	ld	d,a		; 4
vgm_wait2:
	ld	hl,(SAMPLE_DRIFT) ; 16
	ex	de,hl		  ; 4
	scf			  ; 4
	sbc	hl,de		  ; 15	
	dec 	hl		  ; 6 
	dec	hl		  ; 6. wait - SAMPLE_DRIFT - 3
	ex	de,hl		  ; 4
	
	; 69 cycles/iteration
-:
	ld	ix,(0)		; 20
	jp	+		; 10
+:	ld	a,ixh		; 8
	dec	de		; 6
	and	$0F	    	; 7
	ld	a,e		; 4
	or	d		; 4
	jp	nz,-		; 10
	
	ld	hl,0		; 10
	ld	(SAMPLE_DRIFT),hl ; 16 
	jp	vgm_play_loop 	; 10
	
	
vgm_wait_pal:
	ld	de,882		; 10
	jp	vgm_wait2	; 10
	
vgm_wait_ntsc:
	ld	de,735		; 10
	jp	vgm_wait2	; 10


vgm_fm_write:	; Ignored
	inc	c
	inc	c
	jp	vgm_play_loop
	
	
vgm_gg_stereo:	; Ignored
	inc	c
	jp	vgm_play_loop


CH1_PER: .dw 0
CH2_PER: .dw 0
CH3_PER: .dw 0
CH4_PER: .dw 0
TEMP:	.dw 0
CUR_CHN: .dw 0
SAMPLE_DRIFT: .dw 0
NOISE_CFG: .db 0
CH3_PER2: .dw 0


.ORGA $300
; Circular buffer of 256 bytes containing VGM data
; The TLCS900H reads the VGM data from ROM and writes it
; to the corresponding shared RAM area on its side, and the
; Z80 driver then consumes the data.
;
VGM_DATA_BUFFER:


.ORGA $400

vgm_jump_table:
.dw vgm_psg2_write,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,vgm_gg_stereo
.dw 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,vgm_gg_stereo
.dw vgm_psg_write,vgm_fm_write,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
.dw 0,vgm_wait,vgm_wait_ntsc,vgm_wait_pal, 0,0,vgm_end,0, 0,0,0,0, 0,0,0,0
.dw vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait
.dw vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait,vgm_short_wait

