! 256-color XOR plasma effect for SEGA 32X
! Assembly version
! Mic, 2008

	.text
	.global	_start

_start:
	! Slave SH2 entry point
	bra 	_start
	nop

	! Main SH2 entry point
	
	mov.l	MARS_SYS_INTMSK,r1
	mov.w	BIT15,r12
_wait_for_VDP_access:
	mov.w	@r1,r0
	tst	r12,r0
	bt	_wait_for_VDP_access

	! Set VDP mode 1
	mov.l	MARS_VDP_DISPMODE,r14
	mov	#1,r0
	mov.w	r0,@r14
	
	! Init FBCTL
	add	#0xA,r14	
	mov	#0,r15
	mov.w	r15,@r14

	! Set up the palette
	mov	#64,r4
	mov	r4,r1	
	add	r1,r1	! r1 = 128
	mov	r1,r2	 
	add	r2,r2	! r2 = 256
	mov	r2,r3
	add	r1,r3	! r3 = 384
	mov	#31,r7
	mov.l	MARS_CRAM,r0
_setup_palette:
	mov	r4,r5
	add	#-1,r5
	shlr	r5
	mov	r5,r6
	xor	r7,r5

	mov	r5,r8
	shll8	r8
	shll2	r8
	mov	r5,r9
	shlr	r9
	or	r9,r8
	or	r12,r8
	mov.w	r8,@r0
	
	mov 	r7,r8
	shll2	r8
	shll2	r8
	add	r8,r8
	or	r5,r8
	shll2	r8
	shll2	r8
	add	r8,r8
	mov	r5,r9
	shlr	r9
	add	#16,r9
	or	r9,r8
	or	r12,r8
	mov.w	r8,@(r0,r1)
	
	mov	r6,r9
	shlr	r9
	add	#16,r9
	mov 	r6,r8
	shll2	r8
	shll2	r8
	add	r8,r8
	or	r9,r8
	shll2	r8
	shll2	r8
	add	r8,r8
	or	r7,r8
	or	r12,r8
	mov.w	r8,@(r0,r2)

	mov	r6,r8
	shlr	r8
	shll2	r8
	shll2	r8
	add	r8,r8
	or	r6,r8
	or	r12,r8
	mov.w	r8,@(r0,r3)

	dt	r4
	bf/s	_setup_palette
	add	#2,r0
	

_main_loop:

! Flip the framebuffer selection bit, then wait for the flip to take effect
	mov.w 	@r14,r2
	mov	r15,r0
	xor	#1,r0
	mov.w	r0,@r14
	mov	r0,r15
_wait_FS:
	mov.w	@r14,r0
	xor	r2,r0
	tst	#1,r0
	bt	_wait_FS

! Initialize the line table in the first 512 bytes of the current framebuffer
	mov	#64,r0
	shll2	r0
	mov	#160,r4
	extu.b	r4,r4
	mov	r0,r2
	mov.l	MARS_FRAMEBUFFER,r5	
_init_lt:
	mov.w	r0,@r5
	add	r4,r0
	dt	r2
	bf/s	_init_lt
	add	#2,r5
	
	mov.l	sintb,r0
	
	mov	#224,r1
	extu.b	r1,r1
	mov	#0,r3
_yloop:
	mov	#80,r2
	shll2	r2
	mov	#0,r4
_xloop:
	mov	r3,r6
	shlr	r6
	add	r4,r6
	add	r11,r6
	extu.b	r6,r6
	add	r6,r6
	mov.w	@(r0,r6),r7
	shar	r7
	shar	r7
	add	r3,r7

	mov	r3,r6
	add	r11,r6
	extu.b	r6,r6
	add	r6,r6
	mov.w	@(r0,r6),r8
	shar	r8
	shar	r8
	add	r4,r8
	xor	r7,r8
	rotcl 	r8
	mov	#31,r7
	and	r7,r8
	
	mov	r12,r6
	add	r3,r6
	add	r4,r6
	mov	r6,r9	
	extu.b	r6,r6
	add	r6,r6
	mov.w	@(r0,r6),r7
	add	r7,r8

	mov	r13,r6
	add	r4,r6
	extu.b	r6,r6
	add	r6,r6
	mov.w	@(r0,r6),r7
	add	r7,r8
	
	mov	r13,r6
	add	r9,r6
	extu.b	r6,r6
	add	r6,r6
	mov.w	@(r0,r6),r7
	add	r7,r8
	shlr2	r8
	
	mov.b	r8,@r5
	add	#1,r5
	dt	r2
	bf/s	_xloop
	add	#1,r4
	dt	r1
	bf/s	_yloop	
	add	#1,r3

	add	#-2,r11
	add	#2,r12
	add	#-2,r13
	extu.b	r12,r12
	bra	_main_loop
	extu.b	r13,r13
	

BIT15:
	.word 0x8000

	.align 2	

MARS_SYS_INTMSK:
	.long 0x20004000
MARS_VDP_DISPMODE:
	.long 0x20004100
MARS_CRAM:
	.long 0x20004200
MARS_FRAMEBUFFER:
	.long 0x24000000
sintb:
	.long _sintb	
	
_sintb:
	.word 0,7,15,23,31,39,46,54,61,69,76,84,91,98,105,112,118,125,131,137,143
	.word 149,155,160,165,170,175,180,184,188,192,196,199,202,205,208,211,213
	.word 215,217,218,220,221,221,222,222,223,222,222,222,221,220,219,217,216
	.word 214,212,210,208,206,203,200,198,195,192,188,185,182,178,175,171,167
	.word 163,160,156,152,148,144,140,136,132,128,124,120,116,112,108,104,100
	.word 96,93,89,85,82,78,75,71,68,65,62,59,56,53,50,47,44,42,39,37,34,32,30
	.word 28,26,24,22,20,18,16,14,12,11,9,7,6,4,3,1,0,-2,-4,-5,-7,-8,-10,-12
	.word -13,-15,-17,-19,-21,-23,-25,-27,-29,-31,-33,-35,-38,-40,-43,-45,-48
	.word -51,-54,-56,-59,-63,-66,-69,-72,-76,-79,-83,-86,-90,-93,-97,-101,-105
	.word -109,-113,-117,-121,-125,-129,-133,-137,-141,-145,-149,-153,-157,-160
	.word -164,-168,-172,-175,-179,-183,-186,-189,-192,-196,-198,-201,-204,-207
	.word -209,-211,-213,-215,-217,-218,-220,-221,-222,-223,-223,-223,-224,-223
	.word -223,-222,-222,-221,-219,-218,-216,-214,-212,-209,-207,-204,-200,-197
	.word -193,-189,-185,-181,-176,-171,-166,-161,-156,-150,-144,-138,-132,-126
	.word -119,-113,-106,-99,-92,-85,-78,-70,-63,-55,-47,-40,-32,-24,-16,-9


	

	