
// epimgconv: Enterprise 128 image converter utility
// Copyright (C) 2008-2016 Istvan Varga <istvanv@users.sourceforge.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// The Enterprise 128 program files generated by this utility are not covered
// by the GNU General Public License, and can be used, modified, and
// distributed without any restrictions.

#include "epimgconv.hpp"
#include "img_cfg.hpp"
#include "imageconv.hpp"
#include "pixel2.hpp"
#include "pixel4.hpp"
#include "pixel16_1.hpp"
#include "pixel16_2.hpp"
#include "pixel256.hpp"
#include "attr16.hpp"
#include "tvc_2.hpp"
#include "tvc_4.hpp"
#include "tvc_16.hpp"

#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Shared_Image.H>

static const int  ditherTable_Bayer[4096] = {
     0, 2048,  512, 2560,  128, 2176,  640, 2688,   32, 2080,  544, 2592,
   160, 2208,  672, 2720,    8, 2056,  520, 2568,  136, 2184,  648, 2696,
    40, 2088,  552, 2600,  168, 2216,  680, 2728,    2, 2050,  514, 2562,
   130, 2178,  642, 2690,   34, 2082,  546, 2594,  162, 2210,  674, 2722,
    10, 2058,  522, 2570,  138, 2186,  650, 2698,   42, 2090,  554, 2602,
   170, 2218,  682, 2730, 3072, 1024, 3584, 1536, 3200, 1152, 3712, 1664,
  3104, 1056, 3616, 1568, 3232, 1184, 3744, 1696, 3080, 1032, 3592, 1544,
  3208, 1160, 3720, 1672, 3112, 1064, 3624, 1576, 3240, 1192, 3752, 1704,
  3074, 1026, 3586, 1538, 3202, 1154, 3714, 1666, 3106, 1058, 3618, 1570,
  3234, 1186, 3746, 1698, 3082, 1034, 3594, 1546, 3210, 1162, 3722, 1674,
  3114, 1066, 3626, 1578, 3242, 1194, 3754, 1706,  768, 2816,  256, 2304,
   896, 2944,  384, 2432,  800, 2848,  288, 2336,  928, 2976,  416, 2464,
   776, 2824,  264, 2312,  904, 2952,  392, 2440,  808, 2856,  296, 2344,
   936, 2984,  424, 2472,  770, 2818,  258, 2306,  898, 2946,  386, 2434,
   802, 2850,  290, 2338,  930, 2978,  418, 2466,  778, 2826,  266, 2314,
   906, 2954,  394, 2442,  810, 2858,  298, 2346,  938, 2986,  426, 2474,
  3840, 1792, 3328, 1280, 3968, 1920, 3456, 1408, 3872, 1824, 3360, 1312,
  4000, 1952, 3488, 1440, 3848, 1800, 3336, 1288, 3976, 1928, 3464, 1416,
  3880, 1832, 3368, 1320, 4008, 1960, 3496, 1448, 3842, 1794, 3330, 1282,
  3970, 1922, 3458, 1410, 3874, 1826, 3362, 1314, 4002, 1954, 3490, 1442,
  3850, 1802, 3338, 1290, 3978, 1930, 3466, 1418, 3882, 1834, 3370, 1322,
  4010, 1962, 3498, 1450,  192, 2240,  704, 2752,   64, 2112,  576, 2624,
   224, 2272,  736, 2784,   96, 2144,  608, 2656,  200, 2248,  712, 2760,
    72, 2120,  584, 2632,  232, 2280,  744, 2792,  104, 2152,  616, 2664,
   194, 2242,  706, 2754,   66, 2114,  578, 2626,  226, 2274,  738, 2786,
    98, 2146,  610, 2658,  202, 2250,  714, 2762,   74, 2122,  586, 2634,
   234, 2282,  746, 2794,  106, 2154,  618, 2666, 3264, 1216, 3776, 1728,
  3136, 1088, 3648, 1600, 3296, 1248, 3808, 1760, 3168, 1120, 3680, 1632,
  3272, 1224, 3784, 1736, 3144, 1096, 3656, 1608, 3304, 1256, 3816, 1768,
  3176, 1128, 3688, 1640, 3266, 1218, 3778, 1730, 3138, 1090, 3650, 1602,
  3298, 1250, 3810, 1762, 3170, 1122, 3682, 1634, 3274, 1226, 3786, 1738,
  3146, 1098, 3658, 1610, 3306, 1258, 3818, 1770, 3178, 1130, 3690, 1642,
   960, 3008,  448, 2496,  832, 2880,  320, 2368,  992, 3040,  480, 2528,
   864, 2912,  352, 2400,  968, 3016,  456, 2504,  840, 2888,  328, 2376,
  1000, 3048,  488, 2536,  872, 2920,  360, 2408,  962, 3010,  450, 2498,
   834, 2882,  322, 2370,  994, 3042,  482, 2530,  866, 2914,  354, 2402,
   970, 3018,  458, 2506,  842, 2890,  330, 2378, 1002, 3050,  490, 2538,
   874, 2922,  362, 2410, 4032, 1984, 3520, 1472, 3904, 1856, 3392, 1344,
  4064, 2016, 3552, 1504, 3936, 1888, 3424, 1376, 4040, 1992, 3528, 1480,
  3912, 1864, 3400, 1352, 4072, 2024, 3560, 1512, 3944, 1896, 3432, 1384,
  4034, 1986, 3522, 1474, 3906, 1858, 3394, 1346, 4066, 2018, 3554, 1506,
  3938, 1890, 3426, 1378, 4042, 1994, 3530, 1482, 3914, 1866, 3402, 1354,
  4074, 2026, 3562, 1514, 3946, 1898, 3434, 1386,   48, 2096,  560, 2608,
   176, 2224,  688, 2736,   16, 2064,  528, 2576,  144, 2192,  656, 2704,
    56, 2104,  568, 2616,  184, 2232,  696, 2744,   24, 2072,  536, 2584,
   152, 2200,  664, 2712,   50, 2098,  562, 2610,  178, 2226,  690, 2738,
    18, 2066,  530, 2578,  146, 2194,  658, 2706,   58, 2106,  570, 2618,
   186, 2234,  698, 2746,   26, 2074,  538, 2586,  154, 2202,  666, 2714,
  3120, 1072, 3632, 1584, 3248, 1200, 3760, 1712, 3088, 1040, 3600, 1552,
  3216, 1168, 3728, 1680, 3128, 1080, 3640, 1592, 3256, 1208, 3768, 1720,
  3096, 1048, 3608, 1560, 3224, 1176, 3736, 1688, 3122, 1074, 3634, 1586,
  3250, 1202, 3762, 1714, 3090, 1042, 3602, 1554, 3218, 1170, 3730, 1682,
  3130, 1082, 3642, 1594, 3258, 1210, 3770, 1722, 3098, 1050, 3610, 1562,
  3226, 1178, 3738, 1690,  816, 2864,  304, 2352,  944, 2992,  432, 2480,
   784, 2832,  272, 2320,  912, 2960,  400, 2448,  824, 2872,  312, 2360,
   952, 3000,  440, 2488,  792, 2840,  280, 2328,  920, 2968,  408, 2456,
   818, 2866,  306, 2354,  946, 2994,  434, 2482,  786, 2834,  274, 2322,
   914, 2962,  402, 2450,  826, 2874,  314, 2362,  954, 3002,  442, 2490,
   794, 2842,  282, 2330,  922, 2970,  410, 2458, 3888, 1840, 3376, 1328,
  4016, 1968, 3504, 1456, 3856, 1808, 3344, 1296, 3984, 1936, 3472, 1424,
  3896, 1848, 3384, 1336, 4024, 1976, 3512, 1464, 3864, 1816, 3352, 1304,
  3992, 1944, 3480, 1432, 3890, 1842, 3378, 1330, 4018, 1970, 3506, 1458,
  3858, 1810, 3346, 1298, 3986, 1938, 3474, 1426, 3898, 1850, 3386, 1338,
  4026, 1978, 3514, 1466, 3866, 1818, 3354, 1306, 3994, 1946, 3482, 1434,
   240, 2288,  752, 2800,  112, 2160,  624, 2672,  208, 2256,  720, 2768,
    80, 2128,  592, 2640,  248, 2296,  760, 2808,  120, 2168,  632, 2680,
   216, 2264,  728, 2776,   88, 2136,  600, 2648,  242, 2290,  754, 2802,
   114, 2162,  626, 2674,  210, 2258,  722, 2770,   82, 2130,  594, 2642,
   250, 2298,  762, 2810,  122, 2170,  634, 2682,  218, 2266,  730, 2778,
    90, 2138,  602, 2650, 3312, 1264, 3824, 1776, 3184, 1136, 3696, 1648,
  3280, 1232, 3792, 1744, 3152, 1104, 3664, 1616, 3320, 1272, 3832, 1784,
  3192, 1144, 3704, 1656, 3288, 1240, 3800, 1752, 3160, 1112, 3672, 1624,
  3314, 1266, 3826, 1778, 3186, 1138, 3698, 1650, 3282, 1234, 3794, 1746,
  3154, 1106, 3666, 1618, 3322, 1274, 3834, 1786, 3194, 1146, 3706, 1658,
  3290, 1242, 3802, 1754, 3162, 1114, 3674, 1626, 1008, 3056,  496, 2544,
   880, 2928,  368, 2416,  976, 3024,  464, 2512,  848, 2896,  336, 2384,
  1016, 3064,  504, 2552,  888, 2936,  376, 2424,  984, 3032,  472, 2520,
   856, 2904,  344, 2392, 1010, 3058,  498, 2546,  882, 2930,  370, 2418,
   978, 3026,  466, 2514,  850, 2898,  338, 2386, 1018, 3066,  506, 2554,
   890, 2938,  378, 2426,  986, 3034,  474, 2522,  858, 2906,  346, 2394,
  4080, 2032, 3568, 1520, 3952, 1904, 3440, 1392, 4048, 2000, 3536, 1488,
  3920, 1872, 3408, 1360, 4088, 2040, 3576, 1528, 3960, 1912, 3448, 1400,
  4056, 2008, 3544, 1496, 3928, 1880, 3416, 1368, 4082, 2034, 3570, 1522,
  3954, 1906, 3442, 1394, 4050, 2002, 3538, 1490, 3922, 1874, 3410, 1362,
  4090, 2042, 3578, 1530, 3962, 1914, 3450, 1402, 4058, 2010, 3546, 1498,
  3930, 1882, 3418, 1370,   12, 2060,  524, 2572,  140, 2188,  652, 2700,
    44, 2092,  556, 2604,  172, 2220,  684, 2732,    4, 2052,  516, 2564,
   132, 2180,  644, 2692,   36, 2084,  548, 2596,  164, 2212,  676, 2724,
    14, 2062,  526, 2574,  142, 2190,  654, 2702,   46, 2094,  558, 2606,
   174, 2222,  686, 2734,    6, 2054,  518, 2566,  134, 2182,  646, 2694,
    38, 2086,  550, 2598,  166, 2214,  678, 2726, 3084, 1036, 3596, 1548,
  3212, 1164, 3724, 1676, 3116, 1068, 3628, 1580, 3244, 1196, 3756, 1708,
  3076, 1028, 3588, 1540, 3204, 1156, 3716, 1668, 3108, 1060, 3620, 1572,
  3236, 1188, 3748, 1700, 3086, 1038, 3598, 1550, 3214, 1166, 3726, 1678,
  3118, 1070, 3630, 1582, 3246, 1198, 3758, 1710, 3078, 1030, 3590, 1542,
  3206, 1158, 3718, 1670, 3110, 1062, 3622, 1574, 3238, 1190, 3750, 1702,
   780, 2828,  268, 2316,  908, 2956,  396, 2444,  812, 2860,  300, 2348,
   940, 2988,  428, 2476,  772, 2820,  260, 2308,  900, 2948,  388, 2436,
   804, 2852,  292, 2340,  932, 2980,  420, 2468,  782, 2830,  270, 2318,
   910, 2958,  398, 2446,  814, 2862,  302, 2350,  942, 2990,  430, 2478,
   774, 2822,  262, 2310,  902, 2950,  390, 2438,  806, 2854,  294, 2342,
   934, 2982,  422, 2470, 3852, 1804, 3340, 1292, 3980, 1932, 3468, 1420,
  3884, 1836, 3372, 1324, 4012, 1964, 3500, 1452, 3844, 1796, 3332, 1284,
  3972, 1924, 3460, 1412, 3876, 1828, 3364, 1316, 4004, 1956, 3492, 1444,
  3854, 1806, 3342, 1294, 3982, 1934, 3470, 1422, 3886, 1838, 3374, 1326,
  4014, 1966, 3502, 1454, 3846, 1798, 3334, 1286, 3974, 1926, 3462, 1414,
  3878, 1830, 3366, 1318, 4006, 1958, 3494, 1446,  204, 2252,  716, 2764,
    76, 2124,  588, 2636,  236, 2284,  748, 2796,  108, 2156,  620, 2668,
   196, 2244,  708, 2756,   68, 2116,  580, 2628,  228, 2276,  740, 2788,
   100, 2148,  612, 2660,  206, 2254,  718, 2766,   78, 2126,  590, 2638,
   238, 2286,  750, 2798,  110, 2158,  622, 2670,  198, 2246,  710, 2758,
    70, 2118,  582, 2630,  230, 2278,  742, 2790,  102, 2150,  614, 2662,
  3276, 1228, 3788, 1740, 3148, 1100, 3660, 1612, 3308, 1260, 3820, 1772,
  3180, 1132, 3692, 1644, 3268, 1220, 3780, 1732, 3140, 1092, 3652, 1604,
  3300, 1252, 3812, 1764, 3172, 1124, 3684, 1636, 3278, 1230, 3790, 1742,
  3150, 1102, 3662, 1614, 3310, 1262, 3822, 1774, 3182, 1134, 3694, 1646,
  3270, 1222, 3782, 1734, 3142, 1094, 3654, 1606, 3302, 1254, 3814, 1766,
  3174, 1126, 3686, 1638,  972, 3020,  460, 2508,  844, 2892,  332, 2380,
  1004, 3052,  492, 2540,  876, 2924,  364, 2412,  964, 3012,  452, 2500,
   836, 2884,  324, 2372,  996, 3044,  484, 2532,  868, 2916,  356, 2404,
   974, 3022,  462, 2510,  846, 2894,  334, 2382, 1006, 3054,  494, 2542,
   878, 2926,  366, 2414,  966, 3014,  454, 2502,  838, 2886,  326, 2374,
   998, 3046,  486, 2534,  870, 2918,  358, 2406, 4044, 1996, 3532, 1484,
  3916, 1868, 3404, 1356, 4076, 2028, 3564, 1516, 3948, 1900, 3436, 1388,
  4036, 1988, 3524, 1476, 3908, 1860, 3396, 1348, 4068, 2020, 3556, 1508,
  3940, 1892, 3428, 1380, 4046, 1998, 3534, 1486, 3918, 1870, 3406, 1358,
  4078, 2030, 3566, 1518, 3950, 1902, 3438, 1390, 4038, 1990, 3526, 1478,
  3910, 1862, 3398, 1350, 4070, 2022, 3558, 1510, 3942, 1894, 3430, 1382,
    60, 2108,  572, 2620,  188, 2236,  700, 2748,   28, 2076,  540, 2588,
   156, 2204,  668, 2716,   52, 2100,  564, 2612,  180, 2228,  692, 2740,
    20, 2068,  532, 2580,  148, 2196,  660, 2708,   62, 2110,  574, 2622,
   190, 2238,  702, 2750,   30, 2078,  542, 2590,  158, 2206,  670, 2718,
    54, 2102,  566, 2614,  182, 2230,  694, 2742,   22, 2070,  534, 2582,
   150, 2198,  662, 2710, 3132, 1084, 3644, 1596, 3260, 1212, 3772, 1724,
  3100, 1052, 3612, 1564, 3228, 1180, 3740, 1692, 3124, 1076, 3636, 1588,
  3252, 1204, 3764, 1716, 3092, 1044, 3604, 1556, 3220, 1172, 3732, 1684,
  3134, 1086, 3646, 1598, 3262, 1214, 3774, 1726, 3102, 1054, 3614, 1566,
  3230, 1182, 3742, 1694, 3126, 1078, 3638, 1590, 3254, 1206, 3766, 1718,
  3094, 1046, 3606, 1558, 3222, 1174, 3734, 1686,  828, 2876,  316, 2364,
   956, 3004,  444, 2492,  796, 2844,  284, 2332,  924, 2972,  412, 2460,
   820, 2868,  308, 2356,  948, 2996,  436, 2484,  788, 2836,  276, 2324,
   916, 2964,  404, 2452,  830, 2878,  318, 2366,  958, 3006,  446, 2494,
   798, 2846,  286, 2334,  926, 2974,  414, 2462,  822, 2870,  310, 2358,
   950, 2998,  438, 2486,  790, 2838,  278, 2326,  918, 2966,  406, 2454,
  3900, 1852, 3388, 1340, 4028, 1980, 3516, 1468, 3868, 1820, 3356, 1308,
  3996, 1948, 3484, 1436, 3892, 1844, 3380, 1332, 4020, 1972, 3508, 1460,
  3860, 1812, 3348, 1300, 3988, 1940, 3476, 1428, 3902, 1854, 3390, 1342,
  4030, 1982, 3518, 1470, 3870, 1822, 3358, 1310, 3998, 1950, 3486, 1438,
  3894, 1846, 3382, 1334, 4022, 1974, 3510, 1462, 3862, 1814, 3350, 1302,
  3990, 1942, 3478, 1430,  252, 2300,  764, 2812,  124, 2172,  636, 2684,
   220, 2268,  732, 2780,   92, 2140,  604, 2652,  244, 2292,  756, 2804,
   116, 2164,  628, 2676,  212, 2260,  724, 2772,   84, 2132,  596, 2644,
   254, 2302,  766, 2814,  126, 2174,  638, 2686,  222, 2270,  734, 2782,
    94, 2142,  606, 2654,  246, 2294,  758, 2806,  118, 2166,  630, 2678,
   214, 2262,  726, 2774,   86, 2134,  598, 2646, 3324, 1276, 3836, 1788,
  3196, 1148, 3708, 1660, 3292, 1244, 3804, 1756, 3164, 1116, 3676, 1628,
  3316, 1268, 3828, 1780, 3188, 1140, 3700, 1652, 3284, 1236, 3796, 1748,
  3156, 1108, 3668, 1620, 3326, 1278, 3838, 1790, 3198, 1150, 3710, 1662,
  3294, 1246, 3806, 1758, 3166, 1118, 3678, 1630, 3318, 1270, 3830, 1782,
  3190, 1142, 3702, 1654, 3286, 1238, 3798, 1750, 3158, 1110, 3670, 1622,
  1020, 3068,  508, 2556,  892, 2940,  380, 2428,  988, 3036,  476, 2524,
   860, 2908,  348, 2396, 1012, 3060,  500, 2548,  884, 2932,  372, 2420,
   980, 3028,  468, 2516,  852, 2900,  340, 2388, 1022, 3070,  510, 2558,
   894, 2942,  382, 2430,  990, 3038,  478, 2526,  862, 2910,  350, 2398,
  1014, 3062,  502, 2550,  886, 2934,  374, 2422,  982, 3030,  470, 2518,
   854, 2902,  342, 2390, 4092, 2044, 3580, 1532, 3964, 1916, 3452, 1404,
  4060, 2012, 3548, 1500, 3932, 1884, 3420, 1372, 4084, 2036, 3572, 1524,
  3956, 1908, 3444, 1396, 4052, 2004, 3540, 1492, 3924, 1876, 3412, 1364,
  4094, 2046, 3582, 1534, 3966, 1918, 3454, 1406, 4062, 2014, 3550, 1502,
  3934, 1886, 3422, 1374, 4086, 2038, 3574, 1526, 3958, 1910, 3446, 1398,
  4054, 2006, 3542, 1494, 3926, 1878, 3414, 1366,    3, 2051,  515, 2563,
   131, 2179,  643, 2691,   35, 2083,  547, 2595,  163, 2211,  675, 2723,
    11, 2059,  523, 2571,  139, 2187,  651, 2699,   43, 2091,  555, 2603,
   171, 2219,  683, 2731,    1, 2049,  513, 2561,  129, 2177,  641, 2689,
    33, 2081,  545, 2593,  161, 2209,  673, 2721,    9, 2057,  521, 2569,
   137, 2185,  649, 2697,   41, 2089,  553, 2601,  169, 2217,  681, 2729,
  3075, 1027, 3587, 1539, 3203, 1155, 3715, 1667, 3107, 1059, 3619, 1571,
  3235, 1187, 3747, 1699, 3083, 1035, 3595, 1547, 3211, 1163, 3723, 1675,
  3115, 1067, 3627, 1579, 3243, 1195, 3755, 1707, 3073, 1025, 3585, 1537,
  3201, 1153, 3713, 1665, 3105, 1057, 3617, 1569, 3233, 1185, 3745, 1697,
  3081, 1033, 3593, 1545, 3209, 1161, 3721, 1673, 3113, 1065, 3625, 1577,
  3241, 1193, 3753, 1705,  771, 2819,  259, 2307,  899, 2947,  387, 2435,
   803, 2851,  291, 2339,  931, 2979,  419, 2467,  779, 2827,  267, 2315,
   907, 2955,  395, 2443,  811, 2859,  299, 2347,  939, 2987,  427, 2475,
   769, 2817,  257, 2305,  897, 2945,  385, 2433,  801, 2849,  289, 2337,
   929, 2977,  417, 2465,  777, 2825,  265, 2313,  905, 2953,  393, 2441,
   809, 2857,  297, 2345,  937, 2985,  425, 2473, 3843, 1795, 3331, 1283,
  3971, 1923, 3459, 1411, 3875, 1827, 3363, 1315, 4003, 1955, 3491, 1443,
  3851, 1803, 3339, 1291, 3979, 1931, 3467, 1419, 3883, 1835, 3371, 1323,
  4011, 1963, 3499, 1451, 3841, 1793, 3329, 1281, 3969, 1921, 3457, 1409,
  3873, 1825, 3361, 1313, 4001, 1953, 3489, 1441, 3849, 1801, 3337, 1289,
  3977, 1929, 3465, 1417, 3881, 1833, 3369, 1321, 4009, 1961, 3497, 1449,
   195, 2243,  707, 2755,   67, 2115,  579, 2627,  227, 2275,  739, 2787,
    99, 2147,  611, 2659,  203, 2251,  715, 2763,   75, 2123,  587, 2635,
   235, 2283,  747, 2795,  107, 2155,  619, 2667,  193, 2241,  705, 2753,
    65, 2113,  577, 2625,  225, 2273,  737, 2785,   97, 2145,  609, 2657,
   201, 2249,  713, 2761,   73, 2121,  585, 2633,  233, 2281,  745, 2793,
   105, 2153,  617, 2665, 3267, 1219, 3779, 1731, 3139, 1091, 3651, 1603,
  3299, 1251, 3811, 1763, 3171, 1123, 3683, 1635, 3275, 1227, 3787, 1739,
  3147, 1099, 3659, 1611, 3307, 1259, 3819, 1771, 3179, 1131, 3691, 1643,
  3265, 1217, 3777, 1729, 3137, 1089, 3649, 1601, 3297, 1249, 3809, 1761,
  3169, 1121, 3681, 1633, 3273, 1225, 3785, 1737, 3145, 1097, 3657, 1609,
  3305, 1257, 3817, 1769, 3177, 1129, 3689, 1641,  963, 3011,  451, 2499,
   835, 2883,  323, 2371,  995, 3043,  483, 2531,  867, 2915,  355, 2403,
   971, 3019,  459, 2507,  843, 2891,  331, 2379, 1003, 3051,  491, 2539,
   875, 2923,  363, 2411,  961, 3009,  449, 2497,  833, 2881,  321, 2369,
   993, 3041,  481, 2529,  865, 2913,  353, 2401,  969, 3017,  457, 2505,
   841, 2889,  329, 2377, 1001, 3049,  489, 2537,  873, 2921,  361, 2409,
  4035, 1987, 3523, 1475, 3907, 1859, 3395, 1347, 4067, 2019, 3555, 1507,
  3939, 1891, 3427, 1379, 4043, 1995, 3531, 1483, 3915, 1867, 3403, 1355,
  4075, 2027, 3563, 1515, 3947, 1899, 3435, 1387, 4033, 1985, 3521, 1473,
  3905, 1857, 3393, 1345, 4065, 2017, 3553, 1505, 3937, 1889, 3425, 1377,
  4041, 1993, 3529, 1481, 3913, 1865, 3401, 1353, 4073, 2025, 3561, 1513,
  3945, 1897, 3433, 1385,   51, 2099,  563, 2611,  179, 2227,  691, 2739,
    19, 2067,  531, 2579,  147, 2195,  659, 2707,   59, 2107,  571, 2619,
   187, 2235,  699, 2747,   27, 2075,  539, 2587,  155, 2203,  667, 2715,
    49, 2097,  561, 2609,  177, 2225,  689, 2737,   17, 2065,  529, 2577,
   145, 2193,  657, 2705,   57, 2105,  569, 2617,  185, 2233,  697, 2745,
    25, 2073,  537, 2585,  153, 2201,  665, 2713, 3123, 1075, 3635, 1587,
  3251, 1203, 3763, 1715, 3091, 1043, 3603, 1555, 3219, 1171, 3731, 1683,
  3131, 1083, 3643, 1595, 3259, 1211, 3771, 1723, 3099, 1051, 3611, 1563,
  3227, 1179, 3739, 1691, 3121, 1073, 3633, 1585, 3249, 1201, 3761, 1713,
  3089, 1041, 3601, 1553, 3217, 1169, 3729, 1681, 3129, 1081, 3641, 1593,
  3257, 1209, 3769, 1721, 3097, 1049, 3609, 1561, 3225, 1177, 3737, 1689,
   819, 2867,  307, 2355,  947, 2995,  435, 2483,  787, 2835,  275, 2323,
   915, 2963,  403, 2451,  827, 2875,  315, 2363,  955, 3003,  443, 2491,
   795, 2843,  283, 2331,  923, 2971,  411, 2459,  817, 2865,  305, 2353,
   945, 2993,  433, 2481,  785, 2833,  273, 2321,  913, 2961,  401, 2449,
   825, 2873,  313, 2361,  953, 3001,  441, 2489,  793, 2841,  281, 2329,
   921, 2969,  409, 2457, 3891, 1843, 3379, 1331, 4019, 1971, 3507, 1459,
  3859, 1811, 3347, 1299, 3987, 1939, 3475, 1427, 3899, 1851, 3387, 1339,
  4027, 1979, 3515, 1467, 3867, 1819, 3355, 1307, 3995, 1947, 3483, 1435,
  3889, 1841, 3377, 1329, 4017, 1969, 3505, 1457, 3857, 1809, 3345, 1297,
  3985, 1937, 3473, 1425, 3897, 1849, 3385, 1337, 4025, 1977, 3513, 1465,
  3865, 1817, 3353, 1305, 3993, 1945, 3481, 1433,  243, 2291,  755, 2803,
   115, 2163,  627, 2675,  211, 2259,  723, 2771,   83, 2131,  595, 2643,
   251, 2299,  763, 2811,  123, 2171,  635, 2683,  219, 2267,  731, 2779,
    91, 2139,  603, 2651,  241, 2289,  753, 2801,  113, 2161,  625, 2673,
   209, 2257,  721, 2769,   81, 2129,  593, 2641,  249, 2297,  761, 2809,
   121, 2169,  633, 2681,  217, 2265,  729, 2777,   89, 2137,  601, 2649,
  3315, 1267, 3827, 1779, 3187, 1139, 3699, 1651, 3283, 1235, 3795, 1747,
  3155, 1107, 3667, 1619, 3323, 1275, 3835, 1787, 3195, 1147, 3707, 1659,
  3291, 1243, 3803, 1755, 3163, 1115, 3675, 1627, 3313, 1265, 3825, 1777,
  3185, 1137, 3697, 1649, 3281, 1233, 3793, 1745, 3153, 1105, 3665, 1617,
  3321, 1273, 3833, 1785, 3193, 1145, 3705, 1657, 3289, 1241, 3801, 1753,
  3161, 1113, 3673, 1625, 1011, 3059,  499, 2547,  883, 2931,  371, 2419,
   979, 3027,  467, 2515,  851, 2899,  339, 2387, 1019, 3067,  507, 2555,
   891, 2939,  379, 2427,  987, 3035,  475, 2523,  859, 2907,  347, 2395,
  1009, 3057,  497, 2545,  881, 2929,  369, 2417,  977, 3025,  465, 2513,
   849, 2897,  337, 2385, 1017, 3065,  505, 2553,  889, 2937,  377, 2425,
   985, 3033,  473, 2521,  857, 2905,  345, 2393, 4083, 2035, 3571, 1523,
  3955, 1907, 3443, 1395, 4051, 2003, 3539, 1491, 3923, 1875, 3411, 1363,
  4091, 2043, 3579, 1531, 3963, 1915, 3451, 1403, 4059, 2011, 3547, 1499,
  3931, 1883, 3419, 1371, 4081, 2033, 3569, 1521, 3953, 1905, 3441, 1393,
  4049, 2001, 3537, 1489, 3921, 1873, 3409, 1361, 4089, 2041, 3577, 1529,
  3961, 1913, 3449, 1401, 4057, 2009, 3545, 1497, 3929, 1881, 3417, 1369,
    15, 2063,  527, 2575,  143, 2191,  655, 2703,   47, 2095,  559, 2607,
   175, 2223,  687, 2735,    7, 2055,  519, 2567,  135, 2183,  647, 2695,
    39, 2087,  551, 2599,  167, 2215,  679, 2727,   13, 2061,  525, 2573,
   141, 2189,  653, 2701,   45, 2093,  557, 2605,  173, 2221,  685, 2733,
     5, 2053,  517, 2565,  133, 2181,  645, 2693,   37, 2085,  549, 2597,
   165, 2213,  677, 2725, 3087, 1039, 3599, 1551, 3215, 1167, 3727, 1679,
  3119, 1071, 3631, 1583, 3247, 1199, 3759, 1711, 3079, 1031, 3591, 1543,
  3207, 1159, 3719, 1671, 3111, 1063, 3623, 1575, 3239, 1191, 3751, 1703,
  3085, 1037, 3597, 1549, 3213, 1165, 3725, 1677, 3117, 1069, 3629, 1581,
  3245, 1197, 3757, 1709, 3077, 1029, 3589, 1541, 3205, 1157, 3717, 1669,
  3109, 1061, 3621, 1573, 3237, 1189, 3749, 1701,  783, 2831,  271, 2319,
   911, 2959,  399, 2447,  815, 2863,  303, 2351,  943, 2991,  431, 2479,
   775, 2823,  263, 2311,  903, 2951,  391, 2439,  807, 2855,  295, 2343,
   935, 2983,  423, 2471,  781, 2829,  269, 2317,  909, 2957,  397, 2445,
   813, 2861,  301, 2349,  941, 2989,  429, 2477,  773, 2821,  261, 2309,
   901, 2949,  389, 2437,  805, 2853,  293, 2341,  933, 2981,  421, 2469,
  3855, 1807, 3343, 1295, 3983, 1935, 3471, 1423, 3887, 1839, 3375, 1327,
  4015, 1967, 3503, 1455, 3847, 1799, 3335, 1287, 3975, 1927, 3463, 1415,
  3879, 1831, 3367, 1319, 4007, 1959, 3495, 1447, 3853, 1805, 3341, 1293,
  3981, 1933, 3469, 1421, 3885, 1837, 3373, 1325, 4013, 1965, 3501, 1453,
  3845, 1797, 3333, 1285, 3973, 1925, 3461, 1413, 3877, 1829, 3365, 1317,
  4005, 1957, 3493, 1445,  207, 2255,  719, 2767,   79, 2127,  591, 2639,
   239, 2287,  751, 2799,  111, 2159,  623, 2671,  199, 2247,  711, 2759,
    71, 2119,  583, 2631,  231, 2279,  743, 2791,  103, 2151,  615, 2663,
   205, 2253,  717, 2765,   77, 2125,  589, 2637,  237, 2285,  749, 2797,
   109, 2157,  621, 2669,  197, 2245,  709, 2757,   69, 2117,  581, 2629,
   229, 2277,  741, 2789,  101, 2149,  613, 2661, 3279, 1231, 3791, 1743,
  3151, 1103, 3663, 1615, 3311, 1263, 3823, 1775, 3183, 1135, 3695, 1647,
  3271, 1223, 3783, 1735, 3143, 1095, 3655, 1607, 3303, 1255, 3815, 1767,
  3175, 1127, 3687, 1639, 3277, 1229, 3789, 1741, 3149, 1101, 3661, 1613,
  3309, 1261, 3821, 1773, 3181, 1133, 3693, 1645, 3269, 1221, 3781, 1733,
  3141, 1093, 3653, 1605, 3301, 1253, 3813, 1765, 3173, 1125, 3685, 1637,
   975, 3023,  463, 2511,  847, 2895,  335, 2383, 1007, 3055,  495, 2543,
   879, 2927,  367, 2415,  967, 3015,  455, 2503,  839, 2887,  327, 2375,
   999, 3047,  487, 2535,  871, 2919,  359, 2407,  973, 3021,  461, 2509,
   845, 2893,  333, 2381, 1005, 3053,  493, 2541,  877, 2925,  365, 2413,
   965, 3013,  453, 2501,  837, 2885,  325, 2373,  997, 3045,  485, 2533,
   869, 2917,  357, 2405, 4047, 1999, 3535, 1487, 3919, 1871, 3407, 1359,
  4079, 2031, 3567, 1519, 3951, 1903, 3439, 1391, 4039, 1991, 3527, 1479,
  3911, 1863, 3399, 1351, 4071, 2023, 3559, 1511, 3943, 1895, 3431, 1383,
  4045, 1997, 3533, 1485, 3917, 1869, 3405, 1357, 4077, 2029, 3565, 1517,
  3949, 1901, 3437, 1389, 4037, 1989, 3525, 1477, 3909, 1861, 3397, 1349,
  4069, 2021, 3557, 1509, 3941, 1893, 3429, 1381,   63, 2111,  575, 2623,
   191, 2239,  703, 2751,   31, 2079,  543, 2591,  159, 2207,  671, 2719,
    55, 2103,  567, 2615,  183, 2231,  695, 2743,   23, 2071,  535, 2583,
   151, 2199,  663, 2711,   61, 2109,  573, 2621,  189, 2237,  701, 2749,
    29, 2077,  541, 2589,  157, 2205,  669, 2717,   53, 2101,  565, 2613,
   181, 2229,  693, 2741,   21, 2069,  533, 2581,  149, 2197,  661, 2709,
  3135, 1087, 3647, 1599, 3263, 1215, 3775, 1727, 3103, 1055, 3615, 1567,
  3231, 1183, 3743, 1695, 3127, 1079, 3639, 1591, 3255, 1207, 3767, 1719,
  3095, 1047, 3607, 1559, 3223, 1175, 3735, 1687, 3133, 1085, 3645, 1597,
  3261, 1213, 3773, 1725, 3101, 1053, 3613, 1565, 3229, 1181, 3741, 1693,
  3125, 1077, 3637, 1589, 3253, 1205, 3765, 1717, 3093, 1045, 3605, 1557,
  3221, 1173, 3733, 1685,  831, 2879,  319, 2367,  959, 3007,  447, 2495,
   799, 2847,  287, 2335,  927, 2975,  415, 2463,  823, 2871,  311, 2359,
   951, 2999,  439, 2487,  791, 2839,  279, 2327,  919, 2967,  407, 2455,
   829, 2877,  317, 2365,  957, 3005,  445, 2493,  797, 2845,  285, 2333,
   925, 2973,  413, 2461,  821, 2869,  309, 2357,  949, 2997,  437, 2485,
   789, 2837,  277, 2325,  917, 2965,  405, 2453, 3903, 1855, 3391, 1343,
  4031, 1983, 3519, 1471, 3871, 1823, 3359, 1311, 3999, 1951, 3487, 1439,
  3895, 1847, 3383, 1335, 4023, 1975, 3511, 1463, 3863, 1815, 3351, 1303,
  3991, 1943, 3479, 1431, 3901, 1853, 3389, 1341, 4029, 1981, 3517, 1469,
  3869, 1821, 3357, 1309, 3997, 1949, 3485, 1437, 3893, 1845, 3381, 1333,
  4021, 1973, 3509, 1461, 3861, 1813, 3349, 1301, 3989, 1941, 3477, 1429,
   255, 2303,  767, 2815,  127, 2175,  639, 2687,  223, 2271,  735, 2783,
    95, 2143,  607, 2655,  247, 2295,  759, 2807,  119, 2167,  631, 2679,
   215, 2263,  727, 2775,   87, 2135,  599, 2647,  253, 2301,  765, 2813,
   125, 2173,  637, 2685,  221, 2269,  733, 2781,   93, 2141,  605, 2653,
   245, 2293,  757, 2805,  117, 2165,  629, 2677,  213, 2261,  725, 2773,
    85, 2133,  597, 2645, 3327, 1279, 3839, 1791, 3199, 1151, 3711, 1663,
  3295, 1247, 3807, 1759, 3167, 1119, 3679, 1631, 3319, 1271, 3831, 1783,
  3191, 1143, 3703, 1655, 3287, 1239, 3799, 1751, 3159, 1111, 3671, 1623,
  3325, 1277, 3837, 1789, 3197, 1149, 3709, 1661, 3293, 1245, 3805, 1757,
  3165, 1117, 3677, 1629, 3317, 1269, 3829, 1781, 3189, 1141, 3701, 1653,
  3285, 1237, 3797, 1749, 3157, 1109, 3669, 1621, 1023, 3071,  511, 2559,
   895, 2943,  383, 2431,  991, 3039,  479, 2527,  863, 2911,  351, 2399,
  1015, 3063,  503, 2551,  887, 2935,  375, 2423,  983, 3031,  471, 2519,
   855, 2903,  343, 2391, 1021, 3069,  509, 2557,  893, 2941,  381, 2429,
   989, 3037,  477, 2525,  861, 2909,  349, 2397, 1013, 3061,  501, 2549,
   885, 2933,  373, 2421,  981, 3029,  469, 2517,  853, 2901,  341, 2389,
  4095, 2047, 3583, 1535, 3967, 1919, 3455, 1407, 4063, 2015, 3551, 1503,
  3935, 1887, 3423, 1375, 4087, 2039, 3575, 1527, 3959, 1911, 3447, 1399,
  4055, 2007, 3543, 1495, 3927, 1879, 3415, 1367, 4093, 2045, 3581, 1533,
  3965, 1917, 3453, 1405, 4061, 2013, 3549, 1501, 3933, 1885, 3421, 1373,
  4085, 2037, 3573, 1525, 3957, 1909, 3445, 1397, 4053, 2005, 3541, 1493,
  3925, 1877, 3413, 1365
};

static const int  ditherTable_rand[4096] = {
  3958, 1538,    1, 3691, 1863, 2352,  626, 3333,  305, 2638,  743, 2803,
   468, 1740, 3146, 1273, 2764, 1058, 2968, 1941,  897, 2101, 3649,  730,
  2183, 3746, 1193, 2735,  990, 2911, 1854, 2351,  695, 3807,  948, 2321,
  3620, 1652,    3, 3523, 1287, 2452, 1530, 2935, 1233,   49, 1767, 4046,
  1447, 3331, 1156, 1987, 3770, 1534, 3272,  273, 2308, 3675, 1580,   42,
  2785, 1022, 3575, 1991,  527, 2237, 3346, 1439,  357, 3867, 1683, 2167,
  3950, 1161, 3608, 1398, 2359, 4039,   86, 3521, 1424, 3739,  703, 2562,
  3814, 1436,  202, 3381, 1637,  478, 3235, 2018, 3528,  451, 3880, 1280,
  2784, 1456, 2984,  229, 1378, 3198, 2206,  673, 2031, 3638,  742, 1843,
  3837, 1981, 3244,  356, 2438,  659, 3913,  471, 2458,  632, 2165, 4086,
  1413,  485, 2138, 3883,  828, 2559,  206, 2982, 1933, 2831,  866, 2422,
  3111, 1114, 2874,  947, 1925, 2521,  173, 3090,  619, 2005, 3004,  796,
  2297,  298, 3201, 1566,  443, 2244, 3029, 1153, 2453, 4054, 1392,  116,
  1718, 2596,  799, 3354,   67, 3454, 1074, 4024, 2489,  817, 3851, 1731,
  2800,  159, 3174, 2360,  420, 2680,  812, 2971, 1693, 2706, 1266, 3115,
  1062, 3520, 1702,  889, 2954, 1828, 2732, 1174, 2893, 1448, 3372, 1152,
  3728,  283, 4007, 1753,  589, 3463,  103, 3657,  552, 3279, 2119, 1513,
  3704, 1038, 2414, 1634, 3960, 1986, 1084, 3581, 1804, 3912,  625, 2772,
   339, 2117, 3051, 1928, 3156, 1342, 2973, 1179, 2433, 1768, 2277,  567,
  1873, 2731,  378, 3371, 1028, 4069, 2100,  885, 3490, 1496, 3754,  995,
  3457,  105, 3627, 1883, 2870,  209, 2581, 3407,  115, 3816,  647, 3447,
   381, 4036,  596, 2148, 1085, 2546, 1254, 2958, 1905, 2283, 1559, 2574,
  2046, 1320, 3796,  422, 1957, 3375,  224, 2748,  532, 3105, 2467,  134,
  2839,  867, 3283, 1948, 3693, 1263,  691, 3615,  557, 3972,  282, 1984,
  3571,  400, 3714, 1591, 3320, 1088, 2956, 1505, 2540,  537, 1613, 2882,
  1298, 2608,  223, 2333, 1407, 2833, 1609,  399, 2184, 3949, 1217, 1972,
  2334, 1384, 3125, 2060, 1662, 2354, 1795, 3251, 2722,  669, 3296,  195,
  3595,  769, 3906,  327, 3217,  849, 2448, 1721, 2819,  717, 3154, 1458,
  3628,  965, 1855, 3362, 1229, 2644, 1499,   50, 1669, 2919, 2226, 1552,
  2480, 1042, 2174, 3223, 1001, 2809,  844, 3088,  124, 3918, 2185,  261,
  3744, 2012, 3536,   85, 3944,  702, 3415, 1133, 4006,  748, 2499, 3794,
  1460,  666, 3231,  458, 3710,  795, 2471,  157, 3639,  735, 3028,   77,
  1506, 3541, 1672, 2455, 1416, 2708, 1127, 2943, 1650, 4061,   19, 3419,
  1188, 3848, 1815,  832, 2249, 2948,  408, 2200, 4032,  521, 3549, 2048,
  3946,  492, 3428,  179, 3735, 1752, 2709,  711, 4041, 1842, 2343, 1430,
  2565, 1950,  968, 3123,  761, 1364, 2240, 3079, 1103, 2468, 1657, 2653,
   438, 3147, 2074,  878, 3318, 2390, 1107, 2927, 1734, 2689, 1524, 3219,
  1072, 2633, 1371, 3852, 2324,  367, 2863,  714, 3810,  448, 3388, 2155,
   991, 2245, 2899,  802, 2651,  344, 2506, 3983,   62, 2040, 3802, 1132,
  1967, 2494,  920, 2873, 1323, 2572, 1147, 2828,  822, 3258,   27, 2992,
  1531,  215, 3765,  653, 3468,  483, 3576, 1579, 2282, 3352,  389, 1760,
  2781,  302, 3274,  856, 3602, 1745,  180, 2898, 1849,   59, 3614, 2103,
   292, 3997,  555, 1886, 3920,  332, 3323,  803, 1166, 4074, 1054, 3084,
  1339, 2607, 1870,  146, 3555,  575, 1369, 3679, 1887, 3472, 1050, 2107,
  3214, 1374,  687, 3013,  166, 3185, 1884,  278, 3393,  667, 3857, 1796,
  2368, 1450, 3826,  907, 2087, 3193, 1128, 3036, 2110, 1336, 2623,   37,
  4015, 1215, 2144, 3708,  781, 3849, 1316, 2865, 1183, 2303, 3471,  986,
  4059, 1570, 2529,  765, 3182, 1428, 2202, 2852, 1247, 2492, 1629, 2808,
  3210, 1920, 2384,   47, 3451,  893, 3974, 1476, 2782, 1835, 3119, 2204,
   183, 1525, 2988,  515, 1663, 3573, 2235, 1574, 3749,  976, 3499, 2331,
  1097, 2941, 2156,  371, 3585,  617, 2214, 2650, 3507,  545, 1917, 2416,
   307, 3952, 2022, 3003, 1929,  565, 2686, 1415, 3131, 1834, 2254,   18,
  3925,  574, 1945, 2634,  372, 3064, 1343, 3762, 2029,  909, 3567,   24,
  3434,  705, 3698,  177, 1746,  498, 3664, 1585, 2090, 2666,  316, 2488,
   746, 3766,  395, 1222, 4020, 2554,  914, 3726, 2445,  263, 3096,  577,
  1845, 2758,  428, 2008, 4005,  104, 1598, 3071, 1366, 3179, 1720,  345,
  1307, 2511, 3868,  952, 3330, 1641,  620, 1150, 3662, 1682, 3299,  151,
  2348,  508, 3542, 1791, 2402, 1545, 3724, 1210, 3397, 1913,  588, 2594,
   216, 3092, 1707, 2418, 1124, 2932, 1435, 2655, 3348, 2171, 1271, 3238,
   613, 3709, 1632, 3264, 2038, 1404, 2699, 3342, 1737,  453, 3307, 2025,
  1317, 2810, 1121, 4079, 2380, 1218, 3612, 1352, 2659, 1827, 3676,  879,
  2745,  204, 4090, 1976, 3656, 1603,   74, 2891, 1197, 2719, 1862, 3153,
   335, 2485,  956, 3891, 1244, 2979, 1002, 3212,  756, 3042,  255, 2712,
   845, 2322, 3480, 1039, 3842, 2220,  479, 4048, 1996,  409, 3806,  655,
  1000, 3875,  266, 2756, 2000, 1177, 2340,  538, 3935,   70, 2239,  622,
  2128, 3075, 1583,   98, 3903,  854, 3385, 1715,    4, 2885,  871, 3126,
   723, 2439,  449, 3230, 1205, 2536, 1018, 2701,  509, 2963, 2208,  789,
  3596,  185, 3776, 2247, 1495, 3437, 2077,  608, 2582, 1587, 4082,  362,
  2753, 1068, 3305, 1666, 3979,  130, 1489, 2907, 1639,  786, 2816,  971,
  3158, 2295, 1297, 2576, 3070, 1773, 2437, 1390, 4026,  168, 3503, 1304,
  2567, 1784, 3604, 1438, 3825, 1014, 2396, 3433, 1201, 2694,  383, 2168,
  3268, 1486, 3886,  222, 1989, 3812, 1510, 2142, 3928,  583, 3475, 1437,
  3361,  928, 3999, 1777, 2125, 2843, 1325,  579, 4050,   95, 2775, 1770,
  3689,  196, 1896, 2545, 1426, 3822, 1880,  543, 2510, 1858, 3683,  432,
  2096, 3291, 1260, 3631,  240, 1832, 3406,   99, 2193,  814, 3593,  563,
  2104, 3143, 1705, 2983,  794, 3197,  902, 2892,  218, 2736,  732, 2079,
  3141,  679, 1952, 3788,  757, 2600, 1079, 2294, 3344,  827, 3000,   43,
  1660, 2934, 1946,  137, 2016, 2614,  290, 3170,  641, 1539, 3367, 2172,
  1112, 2945, 1351, 3189,  911, 2190, 3392,  833, 2876,   82, 2285, 3560,
   935, 3234, 1145, 2461, 3961,   69, 1968, 2369, 1541, 2999,  922, 3993,
   376, 2834, 1487, 2937,  962, 2473,  425, 2053, 3752,  336, 2373, 1881,
  3485, 1289, 3995,  314, 1678, 3634, 2475, 1245, 2788,  300, 3449, 1747,
   475, 2767, 1267, 3432, 2353,  978, 3603, 1742, 3805, 1073, 3532, 1230,
  2399, 3910,  375, 3052, 1960,  661, 3589,  348, 1983, 3018,  455, 3787,
  1333, 3262, 1235, 2051, 2805,  275, 3005,  629, 1443, 2620, 3465,  610,
  3900,  505, 2739, 1955, 3730, 1094, 3358,   12, 3859, 1445, 3546, 1139,
  2292, 1554, 4087,  501, 1615, 2859,  969, 2211, 2924, 1423,  142, 3324,
   994, 3083, 1344, 4049, 2508, 1029, 3738, 2067,  648, 2820,  326, 2673,
   727, 2502, 1470, 3024,   10, 1736, 2692,  943, 3420, 2520, 1011, 2376,
  3984, 1165, 2631, 1622, 2417,  733, 4029,  473, 1595, 3873, 2231, 1822,
  3584,  862, 1651, 2696, 1203, 3202, 2127, 1349,  741, 2628, 1676, 2363,
  1236, 2676,  763, 3181,  119, 3061, 1077, 2544, 3295,   33, 1963, 3537,
   550, 3866, 2124, 1793, 3953,  643, 2273,  113, 1888, 3134,  355, 1617,
  3280, 1237, 4021, 1564, 3236,  424, 2737,  840, 3684, 2269, 1269, 3845,
   211, 1689, 3751, 1528,   45, 3338,  650, 3610,  232, 2986, 1035, 2561,
  3424, 1367,  698, 3137,  186, 2175, 3254,  299, 3672, 1739,  148, 2974,
  3488,  289, 4056,  640, 3440,  259, 3784, 1890, 2580,  671, 3527, 2003,
   932, 3809, 2407, 1329, 2754, 1108, 3048,  415, 2424, 1653, 2977, 1285,
  3646,  775, 2412, 3861,  169, 3058, 2217,  959, 2130, 3942, 1162, 3310,
  1820,  470, 3228,  778, 2307, 3089,  541, 2747, 2154, 1748, 2912,  977,
  2599, 1482, 3216, 2112,    6, 2014, 3655, 1181, 1937, 4091, 1102, 2583,
   954, 2345, 3838, 1061, 1548, 2495, 1189, 2850, 1910, 2961, 1624,  910,
  3908, 1763, 2266,  272, 3103, 1713,  592, 3176,  205, 2534,  859, 3721,
  1393, 3558,  535, 3304, 1500, 2687, 1973, 1144, 2637, 1850,  560, 3395,
    78, 1895, 2867,  257, 2431, 4076, 1420, 2762, 1801, 1056, 3504, 1240,
  3828,  421, 1908, 3933, 1220, 3509,  392, 1684, 3317, 2487,  496, 2949,
  2442,  414, 3050, 1467, 3531,  683, 1846, 2768, 3297,  800, 3640, 2166,
   513, 1318, 3386, 2413,  406, 3032,  852, 3971, 1115, 2313, 3654, 1206,
  4066, 1535, 3246, 1902,   55, 2570, 1812, 2329,  230, 3986,  486, 3456,
   886, 3669, 1521, 2289, 3769,  998, 2229, 3621, 1573,  675, 2960,  109,
  3195, 2054,  297, 2835,  873, 3113, 2296,  132, 2703,  806, 2350, 3855,
  1310,  829, 3943, 2092, 1007, 3737,  749, 2792,   39, 3161, 2275,  442,
  1401, 3077,   91, 1726, 3965, 2595,  158, 2064, 3600, 1291, 2647, 1508,
  2904,  379, 1839, 2822,  785, 2668,  493, 2299, 3497,  917, 3922,  987,
  3200, 2120, 1417, 2259, 2916,  386, 2812,  819, 2044, 3044,  627, 1321,
  3124, 2094, 1200, 3727,  930, 4003, 2356, 1396, 3645, 1712,  768, 3302,
  1409, 3732, 1809,  249, 2588, 3038, 1607,  117, 3401, 1709, 2309, 1231,
  4013, 1782,  992, 3929, 2609,  937, 2383, 3265,  868, 1571, 3706, 1432,
   715, 3256,   64, 3715,  772, 3508, 2250,  127, 3462, 1355, 3831, 1159,
  2072, 2908,  318, 2741, 1706,  614, 3578,   21, 1761, 4063, 1387, 3327,
   276, 1640, 3895, 2004,  163, 3565, 2454,  403, 2654, 1619,  586, 3359,
   174, 2641, 4067, 1024, 3009,  459, 2143, 3130, 1503,  571, 3513, 1899,
  2539,  320, 3332, 2062,  581, 2182, 2910,  207, 1515, 3742, 2033,  350,
  2880, 2134,  568, 2224, 2842, 1597, 2484, 1379, 2723, 1751, 1069, 3152,
  1628, 2472,  254, 2998,  600, 1776, 3423, 1135, 3797, 2242, 1584, 2151,
  3106,  744, 2542, 1046, 3718, 2466,  494, 3378, 2598, 1701,  808, 3452,
  1283, 3247, 1868, 2481, 1262, 2105,  512, 2010, 2434, 1582, 3580,  981,
  4040, 2264,  918, 2881, 1096, 3081,  890, 3777, 1498, 3500, 1276, 3410,
  2980,  481, 1802, 3373, 1157, 3844, 1788, 3482,  303, 4051,  611, 3366,
   236, 3894, 2435,  460, 4010,  820, 3347, 1449, 3686, 2382,  697, 2629,
   154, 3259,  804, 3840, 1093, 2726,  147, 3150, 2089, 1130, 2952, 1464,
   602, 3951, 2284, 1031, 2905,   28, 3881,  692, 3544, 2743, 1361, 3800,
    61, 3370,  670, 2797,  164, 1769, 3696,  401, 3911, 1556, 2425,  143,
  2829,  388, 2517,  693, 1322, 2323, 4071,  810, 2725,   26, 2987,  973,
  2617, 1225, 2939, 1006, 2335, 2013,  939, 2920, 1264, 2590, 1020, 2796,
    93, 1311, 4028, 1555, 3022, 1256, 2603,  341, 3436, 1949, 3931, 1675,
   594, 3484,   52, 2339, 3072, 1406,  243, 3792, 1744, 2327, 1433, 3055,
  1924,  270, 3209, 1655, 2900, 1083, 2618, 1301, 3276, 2411, 1224, 2773,
  1856,  558, 3188, 2030, 1692, 3618, 1122, 3890, 2681, 1661,  245, 3155,
  1474, 2525, 1251, 3233,  529, 3644, 2176, 1656, 3775,  681, 3592, 1698,
  3418,  325, 3733, 2203, 1837, 3066, 2042,  510, 1980, 3747, 1009, 2966,
  1772,  548, 1368, 2857, 2215, 1560, 4043, 1934,  894, 3335, 2027, 2720,
   634, 3594,  436, 2194,  857, 3687, 2126,  553, 2037, 3957,  315, 3635,
  1985,  758, 3110,   31, 2330, 3564, 1027, 3973,  946, 2216, 2887,   66,
   926, 3091, 2068, 1034, 3583,  726, 3981, 1618, 2457, 1951,  112, 3020,
   419, 2691, 1943,    8, 1997, 2861, 1543,  729, 3884,  393, 3563, 1733,
  3355,  265, 2428, 1332, 3288, 2021, 3624,  306, 3411,  721, 2523,  412,
  3705, 2389,  782, 1511, 3173, 1168, 2690, 4025, 1472, 2555, 1118, 3097,
  1324, 2385, 1754, 2281,  429, 3834, 1520, 3376, 1170, 2108, 2711,  256,
  3016,  616, 1940, 3322, 3700,  518, 3461, 2394,  373, 2671, 1859,  189,
  3524,  905, 3941, 1480, 3445, 1101, 3315, 1375, 3959,  582, 2139, 2953,
  1363, 2679, 1192, 2878,  936, 2713,  777, 3870,   83, 2551,  966, 2661,
  1175, 2897, 1252, 3187, 1816,  128, 2159, 3982,  288, 2503, 1900,  106,
  3289,  605, 3904,  193, 3522,  779, 3245, 1138, 2837, 1345, 2682,  836,
  4078,  466, 1833, 3425, 1418, 3795, 1265, 2161, 1757, 2806, 1185, 1930,
  3758, 1081, 3394, 2241, 1408, 2118, 2717,  790, 1798, 2611,  720, 3033,
  2260, 1239, 3389,  175, 3248,  665, 2504,   36, 4073, 1281, 3183, 1481,
  2778,  737, 3964, 1966, 3556,  182, 3778, 2207,  944, 2791, 3384, 1089,
  2099, 3511,  957, 2807, 2066, 1604, 2243, 2853, 1003, 2721,   89, 4016,
   642, 3493,  203, 1970, 2447, 1631, 2926,  895, 2558,  423, 2779,  219,
  2314,  674, 3936,  129, 2145, 2933,  464, 2825,  637, 3175,  285, 2055,
  3830,  199, 3650, 1874,  349, 3607, 1589, 2370, 1891, 3782,  997, 3464,
  1806, 2320,  358, 3677, 1075, 3095, 1664,  476, 1494, 2624, 1841,  506,
  3916, 1995,  445, 1783, 3011,  533, 1836, 3740,  385, 3470,  699, 1778,
  3819, 1454, 2519, 1253, 2989, 1679, 2228, 3312,  660, 3651,  108, 3863,
  1992, 3479, 1134, 4037, 1593, 3203, 1346, 3045, 1562,  874, 3659, 1818,
  4033, 1167, 3548, 2501,  888, 2888, 2233, 1043, 2082, 2547,  847, 4000,
   446, 1459, 3112, 2163,  531, 3014, 1694, 2091, 2397,  228, 3321, 2050,
  2994,  984, 3117, 1590, 2477, 1063, 3665, 2584,  913, 3858, 2361, 1216,
  2658, 1397, 2970, 2132,  364, 3345,  870, 3678, 1876,  503, 3761,  996,
  2766, 1395, 3171, 1567,  573, 1775, 3122,  831, 3574,  281, 2749,  591,
  3823, 2469, 1446,   48, 2093, 3062,  504, 1575, 3292, 1425,  472, 4083,
  2705,   68, 2975, 1129, 2838, 2221,  214, 1608, 3340, 1155, 3534,  657,
  4012, 1922,  843, 3643,    0, 4094,  682, 3519,  235, 3241, 1914,   58,
  3133, 1969,  208, 3271,  753, 4085,   14, 3626, 1292, 2201, 2917,  252,
  2693, 2121, 1504, 3074,  353, 2493,  858, 2677, 2047, 2896,    2, 2419,
  1982, 2272, 1685, 3416, 2002,  331, 2665, 3339,  759, 2379, 1853, 3898,
    97, 2036, 3213, 1670,  773, 3745, 1958, 3369,  631, 3663, 1857, 3927,
   908, 2793,  120, 2646, 1295, 2845, 2238, 1441, 2760, 1341, 2432, 1158,
  2847, 2232,  877, 4034, 2187, 1149, 3599, 1565, 2470, 1111, 2755, 1944,
  3194,  598, 1646, 3442, 1048, 3879,   54, 2180, 3947, 1160, 3529,  312,
  4004, 1040, 3736, 1388,  490, 3874,  798, 2341, 1148, 3118, 1723, 1012,
  3779, 1268, 2965, 1066, 2444, 3719,  982, 2357, 3128, 1468,  404, 1704,
  2577, 1212, 2728,  377, 2528, 1400, 3820, 1021, 3422,  322, 3756,  542,
  1861, 3404,  346, 3843, 1717,  559, 3426, 1546,  461, 2946,  680, 2786,
   337, 3148, 1703,  522, 1478, 3989, 2429,  813, 2860, 1383, 3286, 1803,
   621, 2826, 1953, 3211, 1296, 2465,  770, 3379, 2621, 1327, 3240,   88,
  4092,  823, 3570, 2325,  212, 2688,  384, 3408, 1533,  572, 3053,  251,
  1299, 3450, 2017, 3878,  136, 3505,  872, 3253,  713, 3087, 1898, 2342,
   752, 3139, 1577, 2147, 2922, 1082, 2669, 1275, 3285, 2063, 1019, 3049,
  2514, 1331, 3773, 1243, 3439,  916, 3872, 2257, 3025,  138, 1964, 3720,
   413, 2593,  728, 2403, 3622, 1462,  153, 1674, 2730,  360, 2947, 1209,
   194, 2848, 1519, 2597, 1278, 2814,  441, 1926, 3226, 1805, 4008,  921,
  2771, 2192, 1814, 3938, 2535,  525, 2818,  904, 3142, 1527, 2362, 1939,
  3992, 1248,  269, 3611, 1755, 2518,  919, 3905,  197, 3540,  644, 3023,
   114, 2605, 3699,  280, 1797, 3164,   92, 2291, 1771, 2564,  241, 2015,
   980, 3550, 1213, 2146, 3225, 1142, 4062, 1610,  457, 3351, 2019, 3817,
   963, 3690, 1732, 3270, 3991,  975, 3711,  710, 3466, 2170, 1551, 3865,
  1360,  585, 2150, 3001,  156, 3671,  649, 1391, 2086, 3586, 1116, 2640,
  1872,  561, 3701,   17, 1620, 2871, 2197, 1370, 3229,   73, 2976, 1228,
  2318, 1645, 2496, 1901, 3955,  787, 1680, 2271, 3888,  898, 1988, 3978,
   580, 3517, 1348, 3753, 2500,  708, 3300,  309, 1792, 2672,  123, 3107,
  2300, 1255, 2929,  718, 3140, 2153,  662, 2223, 1885, 2516,  416, 2993,
  1741,  149, 3076,  690, 2566, 3380, 1030, 1626, 3309, 1196, 2286, 3243,
    41, 1642, 2944,  301, 4060, 2278, 1335, 2589, 3455,  465, 3786,  595,
  2080, 4057,  689, 2034, 3629,  851, 3798,  439, 1522, 2405, 3492, 1358,
   526, 3356, 2615, 1059, 2886, 1576, 3094,  491, 1724, 2841, 1421, 2377,
  3781,  880, 3568, 2069, 1008, 3902,  271, 2552, 1867,   72, 3590, 1091,
   277, 3533, 1977, 1053, 3914, 2478, 1104, 3601, 2059,   16, 3815, 2507,
   454, 1979, 4042,  958, 2177, 3847,  755, 3282, 1727,  815, 3067, 1041,
  2001, 2440, 1536, 3030,  989, 2388, 1728, 3206,  380, 3057, 1412, 2213,
  3390, 1190,  178, 2991, 2451, 1601,  369, 3647, 2084,  152, 2355, 1906,
  3383,   38, 4031,  656, 1517, 3006, 1697,  516, 2877,  791, 2710, 1313,
  4047, 1469, 2645, 2073, 2374,  912, 2906, 2188,  556, 1892, 3166,  363,
  1452, 2955, 1764,  837, 3530, 2685,  291, 1897, 2901, 1164, 2602, 1259,
  2408, 3551,  242, 3896,  652, 3316,  145, 1848, 3667,  295, 3510,  891,
  2776, 1875,   44, 3177,  694, 2635, 4052, 2075,  993, 3104, 1866, 2312,
   736, 3319, 1036, 3915, 1163, 2626, 1326, 3167, 2276,  221, 2533, 3481,
  1365, 3668, 1060, 3414,  444, 3010,  842, 3306, 1658, 3954,   34, 3365,
  1605, 3666, 1202, 2387, 3977,  615, 2317, 3093, 1497,  734, 2218, 3613,
   514, 3438,  165, 3755,  484, 1912, 2854, 1414, 2761, 1186, 3975, 2302,
  1146, 2714, 1512, 2532, 1125, 3996, 2129, 1621, 3682, 1974, 1386,  628,
  3760,   23, 3429,  950, 4072, 1484, 2769,  328, 2978,  760, 3609,  452,
  1831, 3846, 1105, 1990, 2347,   20, 3196, 1824, 2400, 1623, 3850,  536,
  2950, 1261, 2575, 1381, 2660,  248, 2862,  855, 2106, 3222, 1309,  237,
  3764, 1826, 3186, 1057, 2765, 1544, 3163, 2205, 1485, 3101,  931, 2622,
   351, 3151, 2097,  517, 3391,  719, 3864,  160, 3431,  624, 2964,  482,
  2337,  246, 3257, 2541, 1471, 2652, 1238, 2734,  267, 2553,  839, 3702,
  1810, 2391, 1667, 2123, 3069,  635, 3363,  391, 3985, 1756, 2246,  587,
  3100,  172, 2261, 1921,  321, 3703,  751, 3483,  960, 4053, 1695, 3557,
   135, 1871, 3889, 2450,  896, 2849,   84, 3966, 2133,  861, 2011,  604,
  4019,   71, 3496, 1677, 3811,  901, 1738, 2884, 1457, 2426, 1319, 2913,
  1765, 2674, 1434, 3832,  945, 3543, 1825,  396, 3477,  704, 3813, 1735,
  3242, 1207, 3082, 2189,  607, 3446,  191, 3967,  983, 2801, 1490, 2667,
  1226, 3034,  940, 3790, 1171, 3617, 1372, 3398, 2757, 1099, 2423,  394,
  3015, 1904,  520, 2537, 1523, 2802,  546, 1714, 3448, 1340, 2579, 1860,
   410, 3692, 2718, 1394, 2486, 1800, 2262,  672, 2349, 1931, 3713,   32,
  3566,  427, 3277,  762, 2328,  284, 3157, 1249, 2750, 1338, 3002, 2280,
  1126, 2909, 2164,  502, 1919, 3862,   76, 1616, 3199, 1405, 2697, 1246,
  2456,   87, 3252,  686, 3545,  239, 2513, 1588, 2830,  724, 2625,  988,
  1492, 3266, 1766, 3803, 1303, 2290, 3337, 1037, 3047,  933, 3630, 2274,
   323, 3135,  663, 3514, 1636, 2301,  225, 3329,  792, 3636, 1119, 3255,
   210, 2928,  805, 2550, 1356, 2657, 1659, 4035, 1204, 3716,  824, 2464,
    81, 3921,  544, 1710, 4002,  140, 1557, 3674, 2436, 1087, 2815, 2045,
   407, 3763,  776, 3512, 1563, 3725, 1154, 2006, 2270, 1716, 3923,  343,
  1947, 3474,  102, 4070, 2306,  188, 2684,  633, 2890,   75, 2007, 3723,
   370, 3278, 1994, 1182, 4081, 1483, 2787, 1208, 3059,  949, 3924, 1708,
  2951,  333, 2795, 1568, 4088, 1385, 3467, 1052, 3939,  578, 3040,  122,
  2727, 1502, 3413, 1649, 3215, 1098, 2057, 3136,  925, 2522, 3334, 1362,
   340, 3554,  860, 4023, 2326, 1290, 2586,  294, 2942,  807, 2642, 4089,
   477, 3129,  876, 2332, 3172, 1279, 2548,  797, 1687, 3885, 1403, 3405,
  1187, 3932,  767, 2253, 1780, 2364,   46, 2925,  747, 2462,  181, 3799,
   495, 2613, 2023, 1045, 2212, 3835,  985, 2571,  750, 2449,  368, 3120,
  2227, 1549, 2160, 3350, 1004, 2560,  324, 2832,  590, 3661, 2420,  304,
  3495, 1794,  570, 2780, 2135, 1758, 3178,  551, 1889, 3041,  955, 3377,
  1786, 2316,  161, 1529, 2872, 1308, 3632, 1879,  528, 3757, 1051, 3353,
  2636,  688, 2393,  310, 2733, 1665, 3205, 1350, 3998, 1110, 3430, 1612,
  3707, 1140, 3360, 2157, 1553, 3237,    5, 3572,  549, 1877, 3298,  107,
  3400, 1473, 2744, 1903,  233, 3789,  864, 1894, 3588,  706, 3970, 1065,
  2298, 1936, 1293, 2855, 1169, 2263, 3899,  883, 3054,  167, 2476, 1547,
  3502,    7, 3893, 2173, 1070, 3801, 1923, 3343,  929, 2578,   53, 2799,
  1540, 2136, 2914,  431, 1315, 3458, 1594, 3652,  811, 2490,  231, 2783,
   469, 2648,  696, 2557,  347, 2678, 1749,  597, 4011, 1330, 2088, 2526,
  1586, 2700, 1306, 2866, 1214, 3887,  882, 3616, 1284, 2102, 2981,  405,
  2024, 3108, 1722, 2078, 3073,  200, 4080,  668, 3625,   51, 1978, 3263,
  1455, 3956,  964, 2869, 1198, 2729, 1730,  426, 3273,  645, 2763,  354,
  3836, 1851, 3435,  835, 4018,  213, 1774, 3688, 2997,    9, 2823,  999,
  2959, 1272, 3780, 1080, 3501, 1444, 3841, 1234, 3227,  924, 3037, 1918,
  2371,  387, 3459,  701, 3697,  286, 3980,  623, 2288,  456, 3017, 1596,
  3224,  638, 2255, 3731, 1195, 2401,   11, 3771,  801, 3325, 1422, 2568,
  1592, 2936,  788, 2372,  447, 2052, 3311,  365, 3680,  618, 2116, 2969,
  1440, 2527, 1354, 3149, 1648,  599, 2234, 3056, 1199, 3249, 2344,  906,
  2065, 1431, 2219, 4030,  411, 3284, 1882, 2415,  639, 3085,  162, 2258,
  1869, 3948,  100, 3642,  841, 2740, 1429, 2903, 1143, 3127, 2140, 1668,
  3180, 1808, 2378,   60, 1852, 4064, 1493,  176, 3204,  974, 2879, 1465,
  2491, 1032, 2789,  467, 3294, 1221, 3793, 1644, 3539, 1136, 2279, 1819,
  2409, 1581, 4038, 1017, 3591,  110, 3994,  745, 2109, 3670, 1453,  402,
  2656, 1909,  566, 3963,  334, 3582,  654, 1787, 2675, 1516,  111, 3368,
  2020, 1569, 2746, 3597,  530, 1654, 2836, 1402, 3326, 1071, 3772,  144,
  2404, 1962,  875, 3516,  198, 3808,  809, 3547, 2505,  497, 2804, 2210,
  1686, 3907,  678, 3469,  374, 3579, 1998, 3827,  903, 2446,  227, 2664,
   712, 2915,   96, 3854,  738, 3162,  217, 2704,  816, 2923, 1173, 2365,
  3012,  184, 2028, 3876, 1086, 3525, 1630, 2474, 3314, 1550, 2162, 3232,
  1025, 3860, 2111,  869, 4058,  437, 2076, 1334, 2191, 3486, 1123, 2497,
   313, 2962, 2181, 1700, 3877,  430, 2824, 1270, 2592, 1172, 2875, 2049,
  1131, 3063, 1337, 3658,  434, 1865, 2604, 1376, 2738, 1633,  118, 1811,
  3027, 1507, 3441, 1382, 4055, 1300, 3364, 1055, 2612, 1274, 3460, 2196,
  1627, 2056, 3538,  487, 1419, 3287, 2509,  664, 2742,  121, 3116,  853,
  1838,  534, 3768,  171, 2563,  569, 3109, 2336, 1191, 2587, 3741,  818,
  2940,  244, 2695,  722, 4068, 1935,  564, 3165,  826, 3374, 1625, 4045,
   709, 3443, 1781,  274, 3869,  754, 3387,  953, 2085, 3007,  220, 3239,
   612, 4027, 2178, 3220,  329, 2616,  646, 2846,  382, 2338, 1911, 3121,
   308, 2827, 1779,  539, 3750,  317, 2591, 1864, 3945,  884, 1699, 3412,
  1257, 3734, 1141, 2883, 3909, 2531, 1211, 2985, 1411, 3637, 1696,  279,
  3553, 1643,   25, 3303, 1817, 3917, 1016, 3275, 2265,  961, 3660, 1514,
  2058, 2512,   35, 2195, 2972,  474, 2305, 3308, 1442, 2610,   94, 2392,
  4001, 1277, 3562, 1113, 1975, 2556, 1314,  834, 3934, 1013, 3606, 2115,
  1789, 3729,  562, 1671, 3641, 1109, 3919, 2252, 1399, 3328,  850, 3086,
    29, 2811, 2149,  293, 2443, 1750, 2319,  260,  951, 1938, 3515,  740,
  2774,  941, 2039, 3008, 1100, 3138, 1907, 2358,  609, 1466, 2895, 1847,
    65, 2113, 2569,  262, 3046, 1294, 3623, 1033, 1711, 3722, 1509,  887,
  2759, 1064, 3218, 1927,  519, 2707,  821, 2293, 3402,  418, 3695, 2367,
  1427, 2894, 1681,   30, 2995, 1178, 2770, 2141,  700, 2498,   63, 3043,
   915, 2009, 2463, 1475, 3783, 1047, 3569, 1526, 4077,  507, 3444, 1999,
  3261,   56, 2225, 3192,  366, 2381, 3987,  783, 2752,  500, 3882,  972,
  3518, 2098,  417, 3791, 1602, 3427, 1241, 3990,  739, 3290,  524, 2032,
  2777,  139, 2459, 4017,  342, 3633, 2169, 1180, 3336, 1614, 3743,   57,
  1532, 2967, 1785,  170, 3498,  499, 2199, 3871,  848, 3396,  187, 3824,
  1461, 3281, 2035, 1542, 4065,  201, 3494,  584, 1813, 2715,  716, 2990,
  1357, 2858, 1067, 2606, 1463, 4044, 1611,  881, 3681, 1844,   90, 3221,
  1288, 2482, 1501, 2630,  190, 3160, 2410, 1302, 2670,  488, 2921, 1010,
  2798, 1380, 2427, 3937,  967, 3267, 1762,  684, 2889, 1830,  601, 3839,
   247, 2632, 1219, 2479, 3897,  731, 2267, 3145, 1120, 1961, 3260, 1250,
  2483, 1572, 2601,  970, 2902,  435, 3598,  677, 2222, 2844, 1117, 3184,
  2395,  338, 3341, 2122,   80, 2248, 3821,  390, 2918,  593, 2071, 3080,
  1223, 2868, 1451, 2179, 3804,  268, 3403, 1232, 4022, 1691,  766, 3577,
   934, 3853, 1729, 2315,  155, 3759, 1790,  319, 3019, 1353, 3535, 2070,
  1092, 3114, 1561, 2236, 3035,  892, 3269,  554, 1821, 2864, 1410,  630,
  4093, 2573,  764, 2751,  397, 4009,  603, 3526, 1743, 2375, 1078, 3098,
  1688,  523, 3717, 2083, 1194, 3969, 1638, 1005, 3648, 1829,  774, 2186,
   979, 3619, 2662,  226, 3926,  707, 3453,  462, 1759, 2683,  825, 2856,
   540, 2043, 2996,  125, 3190, 1893,  361, 3491, 1993, 1076, 3132, 2268,
   784, 2639,  258, 2366, 3767,   22, 3473,  463, 1956, 3940, 1488, 2137,
  3487,  264, 3653, 2421, 1725,  101, 3712, 1479, 3039, 1095, 3159, 2158,
   126, 3976, 1965,  287, 3856, 2627, 1840,  131, 3021,  780, 2538, 2938,
   547, 3144, 1558, 3489, 2460, 1823, 1049, 1959, 2311, 1578, 2515, 1916,
  3250, 1137, 3748, 1373, 2304, 3673, 1026, 2649, 1176, 2346, 3065,  830,
  2543, 3559,  636, 1673, 3409, 1258, 3968,  942, 1942, 2698, 1305, 2840,
   771, 2441,  133, 2930, 1044, 2724, 1606,  440, 3313, 2131,  900, 3421,
   234, 2406, 1932, 1328, 2794, 1227, 3191, 2524, 1347,  838, 3357, 1491,
  2256, 3605,  238, 1954, 4014, 1282, 2619,  141, 3382,  433, 3829, 2702,
   511, 3561,  150, 4095,  676, 2430,   40, 2957, 1807,  330, 3349, 1537,
  3930,  651, 1647, 4084, 1477,  398, 2398, 3892,   79, 2817, 1518, 3207,
   658, 2198, 4075, 1023, 3587, 1690, 3417, 1242, 3988,  793, 2061, 3818,
  1151, 2821, 1799, 2310, 1389, 3785,  489, 3476,  865, 3694,  725, 1635,
  3552, 2209,  450, 3901,  938, 1878, 3208,  899, 2386,  352, 3774, 2114,
  1312, 2931, 2095,  927, 3169, 1184, 2790, 1359, 3031, 1599, 3478, 1090,
  3833, 2251,  863, 2585,  253, 3399, 2152,   13, 3301, 2716, 1106, 1915,
  3078,  846, 2530,  311, 3685, 1600,  192, 3168, 2081,  359, 2663, 1971,
   480, 3099, 2549,  923, 3060,  296, 3962,  576, 3293, 2041, 2851, 1015,
  2643,  250, 2287, 3026,   15, 2813, 1286, 2026, 3068,  606, 2230, 3506,
  1377, 3102, 1719,  685
};

namespace Ep128ImgConv {

  void defaultProgressMessageCb(void *userData, const char *msg)
  {
    (void) userData;
    if (msg != (char *) 0 && msg[0] != '\0')
      std::fprintf(stderr, "%s\n", msg);
  }

  bool defaultProgressPercentageCb(void *userData, int n)
  {
    (void) userData;
    if (n != 100)
      std::fprintf(stderr, "\r  %3d%%    ", n);
    else
      std::fprintf(stderr, "\r  %3d%%    \n", n);
    return true;
  }

  // --------------------------------------------------------------------------

  ImageData::ImageData(int width_, int height_, int videoMode_,
                       int biasResolution_, int paletteResolution_,
                       int interlaceMode_, int compressionType_)
    : buf((unsigned char *) 0),
      fileHeader((unsigned char *) 0),
      videoMode0((unsigned char **) 0),
      fixBias0((unsigned char **) 0),
      palette0((unsigned char **) 0),
      attribute0((unsigned char **) 0),
      videoData0((unsigned char **) 0),
      videoMode1((unsigned char **) 0),
      fixBias1((unsigned char **) 0),
      palette1((unsigned char **) 0),
      attribute1((unsigned char **) 0),
      videoData1((unsigned char **) 0),
      dataSize(0),
      width(width_),
      height(height_),
      videoMode(videoMode_),
      biasResolution(biasResolution_),
      paletteResolution(paletteResolution_),
      interlaceMode(interlaceMode_),
      compressionType(compressionType_)
  {
    try {
      if (width < 1 || width > 255 || height < 1 || height > 6144)
        throw Ep128Emu::Exception("ImageData: invalid image size");
      videoMode = videoMode & 0x6E;
      switch (videoMode & 0x0E) {
      case 0x00:
      case 0x06:
      case 0x08:
      case 0x0A:
      case 0x0C:
        throw Ep128Emu::Exception("ImageData: invalid video mode");
      case 0x04:
        // attribute mode: always 2 colors
        videoMode = videoMode & 0x0E;
        break;
      }
      if (biasResolution < 0 || biasResolution > 255)
        throw Ep128Emu::Exception("ImageData: invalid FIXBIAS resolution");
      if (paletteResolution < 0 || paletteResolution > 255)
        throw Ep128Emu::Exception("ImageData: invalid palette resolution");
      interlaceMode = interlaceMode & 0x9E;
      if (compressionType != 0)
        throw Ep128Emu::Exception("ImageData: invalid compression type");
      int     biasCnt = 0;
      if ((videoMode & 0x60) == 0x40 || (videoMode & 0x0E) == 0x04) {
        // FIXBIAS is used in 16 color modes only
        if (biasResolution > 0)
          biasCnt = (height + biasResolution - 1) / biasResolution;
        else
          biasCnt = 1;
      }
      else {
        biasResolution = 0;
        interlaceMode = interlaceMode & 0x9D;
      }
      int     paletteCnt = 0;
      if ((videoMode & 0x60) != 0x60) {
        if (paletteResolution > 0)
          paletteCnt = (height + paletteResolution - 1) / paletteResolution;
        else
          paletteCnt = 1;
      }
      else {
        // no palette in 256 color modes
        paletteResolution = 0;
        interlaceMode = interlaceMode & 0x9B;
      }
      if ((videoMode & 0x0E) != 0x04)
        interlaceMode = interlaceMode & 0x97;   // no attributes
      int     paletteColors = 1 << (((videoMode & 0x60) >> 5) + 1);
      if ((videoMode & 0x60) == 0x60)           // 256 colors: no palette
        paletteColors = 0;
      else if ((videoMode & 0x0E) == 0x04)      // attribute mode
        paletteColors = 8;
      size_t  headerSize = 16;
      size_t  videoMode0Size = 1;
      size_t  bias0Size = size_t(biasCnt);
      size_t  palette0Size = size_t(paletteCnt) * size_t(paletteColors);
      size_t  attr0Size = 0;
      if ((videoMode & 0x0E) == 0x04)
        attr0Size = size_t(width) * size_t(height);
      size_t  videoData0Size = size_t(width) * size_t(height);
      if ((videoMode & 0x0E) == 0x02)
        videoData0Size = videoData0Size << 1;   // PIXEL mode
      size_t  videoMode1Size =
          ((interlaceMode & 0x01) != 0 ? videoMode0Size : 0);
      size_t  bias1Size = ((interlaceMode & 0x02) != 0 ? bias0Size : 0);
      size_t  palette1Size = ((interlaceMode & 0x04) != 0 ? palette0Size : 0);
      size_t  attr1Size = ((interlaceMode & 0x08) != 0 ? attr0Size : 0);
      size_t  videoData1Size =
          ((interlaceMode & 0x10) != 0 ? videoData0Size : 0);
      if ((interlaceMode & 0x1F) == 0)
        interlaceMode = 0x00;
      size_t  nBytes = headerSize
                       + videoMode0Size + bias0Size + palette0Size + attr0Size
                       + videoData0Size
                       + videoMode1Size + bias1Size + palette1Size + attr1Size
                       + videoData1Size;
      buf = new unsigned char[nBytes];
      for (size_t i = 0; i < nBytes; i++)
        buf[i] = 0x00;
      dataSize = nBytes;
      buf[0] = 0x00;
      buf[1] = 0x49;
      buf[2] = 0x00;
      buf[3] = (unsigned char) biasResolution;
      buf[4] = (unsigned char) paletteResolution;
      buf[5] = (unsigned char) interlaceMode;
      buf[6] = (unsigned char) (height & 0xFF);
      buf[7] = (unsigned char) ((height >> 8) & 0xFF);
      buf[8] = (unsigned char) width;
      buf[9] = 0x00;                            // border color
      buf[10] = 0x00;                           // compression type
      buf[16] = (unsigned char) (videoMode | 0x10);
      size_t  ptrCnt = 2;       // videoMode + videoData
      if ((videoMode & 0x60) == 0x40 || (videoMode & 0x0E) == 0x04)
        ptrCnt++;               // bias
      if ((videoMode & 0x60) != 0x60)
        ptrCnt++;               // palette
      if ((videoMode & 0x0E) == 0x04)
        ptrCnt++;               // attributes
      for (int i = 0; i < 5; i++) {
        if ((interlaceMode & (1 << i)) != 0)
          ptrCnt++;
      }
      ptrCnt = ptrCnt * size_t(height);
      videoMode0 = new unsigned char*[ptrCnt];
      unsigned char *bufp = buf;
      unsigned char **bufpp = videoMode0;
      fileHeader = bufp;
      bufp = bufp + 16;
      if (videoMode0Size > 0) {
        videoMode0 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = 0;
          videoMode0[i] = &(bufp[n]);
        }
        bufp = bufp + videoMode0Size;
        bufpp = bufpp + long(height);
      }
      if (bias0Size > 0) {
        fixBias0 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = 0;
          if (biasResolution > 0)
            n = i / biasResolution;
          fixBias0[i] = &(bufp[n]);
        }
        bufp = bufp + bias0Size;
        bufpp = bufpp + long(height);
      }
      if (palette0Size > 0) {
        palette0 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = 0;
          if (paletteResolution > 0)
            n = i / paletteResolution;
          palette0[i] = &(bufp[long(n) * paletteColors]);
        }
        bufp = bufp + palette0Size;
        bufpp = bufpp + long(height);
      }
      if (attr0Size > 0) {
        attribute0 = bufpp;
        for (int i = 0; i < height; i++)
          attribute0[i] = &(bufp[long(i) * width]);
        bufp = bufp + attr0Size;
        bufpp = bufpp + long(height);
      }
      if (videoData0Size > 0) {
        videoData0 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = ((videoMode & 0x0E) == 0x02 ? (width << 1) : width);
          videoData0[i] = &(bufp[long(n) * i]);
        }
        bufp = bufp + videoData0Size;
        bufpp = bufpp + long(height);
      }
      if (videoMode1Size > 0) {
        videoMode1 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = 0;
          videoMode1[i] = &(bufp[n]);
        }
        bufp = bufp + videoMode1Size;
        bufpp = bufpp + long(height);
      }
      if (bias1Size > 0) {
        fixBias1 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = 0;
          if (biasResolution > 0)
            n = i / biasResolution;
          fixBias1[i] = &(bufp[n]);
        }
        bufp = bufp + bias1Size;
        bufpp = bufpp + long(height);
      }
      if (palette1Size > 0) {
        palette1 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = 0;
          if (paletteResolution > 0)
            n = i / paletteResolution;
          palette1[i] = &(bufp[long(n) * paletteColors]);
        }
        bufp = bufp + palette1Size;
        bufpp = bufpp + long(height);
      }
      if (attr1Size > 0) {
        attribute1 = bufpp;
        for (int i = 0; i < height; i++)
          attribute1[i] = &(bufp[long(i) * width]);
        bufp = bufp + attr1Size;
        bufpp = bufpp + long(height);
      }
      if (videoData1Size > 0) {
        videoData1 = bufpp;
        for (int i = 0; i < height; i++) {
          int     n = ((videoMode & 0x0E) == 0x02 ? (width << 1) : width);
          videoData1[i] = &(bufp[long(n) * i]);
        }
        bufp = bufp + videoData1Size;
        bufpp = bufpp + long(height);
      }
    }
    catch (...) {
      if (videoMode0)
        delete[] videoMode0;
      if (buf)
        delete[] buf;
      throw;
    }
  }

  ImageData::~ImageData()
  {
    delete[] videoMode0;
    delete[] buf;
  }

  void ImageData::setBorderColor(int c)
  {
    buf[9] = (unsigned char) (c & 0xFF);
  }

  void ImageData::setFixBias(long yc, int c)
  {
    bool    oddField = false;
    if (interlaceMode != 0) {
      oddField = bool(yc & 1L);
      yc = yc >> 1;
    }
    if (yc < 0L || yc >= long(height))
      return;
    if (oddField) {
      if (fixBias1) {
        fixBias1[yc][0] = (unsigned char) (c & 0x1F);
        return;
      }
    }
    if (fixBias0)
      fixBias0[yc][0] = (unsigned char) (c & 0x1F);
  }

  void ImageData::setPaletteColor(long yc, int n, int c)
  {
    bool    oddField = false;
    if (interlaceMode != 0) {
      oddField = bool(yc & 1L);
      yc = yc >> 1;
    }
    if (yc < 0L || yc >= long(height))
      return;
    int     paletteColors = 1 << (((videoMode & 0x60) >> 5) + 1);
    if ((videoMode & 0x60) == 0x60)             // 256 colors: no palette
      paletteColors = 0;
    else if ((videoMode & 0x0E) == 0x04)        // attribute mode
      paletteColors = 8;
    if (n < 0 || n >= paletteColors)
      return;
    c = c & 0xFF;
    if (oddField) {
      if (palette1) {
        palette1[yc][n] = (unsigned char) c;
        return;
      }
    }
    if (palette0)
      palette0[yc][n] = (unsigned char) c;
  }

  void ImageData::setAttributes(long xc, long yc, int c0, int c1)
  {
    bool    oddField = false;
    if (interlaceMode != 0) {
      oddField = bool(yc & 1L);
      yc = yc >> 1;
    }
    if (yc < 0L || yc >= long(height) || xc < 0L || xc >= (long(width) << 3))
      return;
    xc = xc >> 3;
    int     c = ((c0 & 0x0F) << 4) | (c1 & 0x0F);
    if (oddField) {
      if (attribute1) {
        attribute1[yc][xc] = (unsigned char) c;
        return;
      }
    }
    if (attribute0)
      attribute0[yc][xc] = (unsigned char) c;
  }

  void ImageData::setPixel(long xc, long yc, int c)
  {
    bool    oddField = false;
    if (interlaceMode != 0) {
      oddField = bool(yc & 1L);
      yc = yc >> 1;
    }
    long    w = long(width) << 3;
    long    xi = xc;
    int     bitNum = int(xc & 7L) ^ 7;
    switch (videoMode & 0x0E) {
    case 0x02:
      w = w << 1;                       // PIXEL mode
    case 0x0E:                          // LPIXEL mode
      switch ((videoMode & 0x60)) {
      case 0x00:                        // 2 colors
        break;
      case 0x20:                        // 4 colors
        w = w >> 1;
        xi = xi << 1;
        bitNum = bitNum & 3;
        break;
      case 0x40:                        // 16 colors
        w = w >> 2;
        xi = xi << 2;
        bitNum = bitNum & 1;
        break;
      case 0x60:                        // 256 colors
        w = w >> 3;
        xi = xi << 3;
        bitNum = 0;
        break;
      }
    default:                            // ATTRIBUTE mode
      xi = xi >> 3;
    }
    if (yc < 0L || yc >= long(height) || xc < 0L || xc >= w)
      return;
    int     bitMask = 1;
    if (!((videoMode & 0x60) == 0x00 || (videoMode & 0x0E) == 0x04)) {
      switch (videoMode & 0x60) {
      case 0x20:                        // 4 colors
        bitMask = 0x11;
        c = ((c & 2) >> 1) | ((c & 1) << 4);
        break;
      case 0x40:                        // 16 colors
        bitMask = 0x55;
        c = ((c & 8) >> 3) | ((c & 4) << 2) | ((c & 2) << 1) | ((c & 1) << 6);
        break;
      case 0x60:                        // 256 colors
        bitMask = 0xFF;
        c = c & 0xFF;
        break;
      }
    }
    else {
      c = c & 0x01;                     // 2 colors or attribute mode
    }
    bitMask = bitMask << bitNum;
    c = c << bitNum;
    if (oddField) {
      if (videoData1) {
        videoData1[yc][xi] &= (unsigned char) (bitMask ^ 0xFF);
        videoData1[yc][xi] |= (unsigned char) c;
        return;
      }
    }
    if (videoData0) {
      videoData0[yc][xi] &= (unsigned char) (bitMask ^ 0xFF);
      videoData0[yc][xi] |= (unsigned char) c;
    }
  }

  // --------------------------------------------------------------------------

  void YUVImage::allocateBuffers(float**& bufY_, float**& bufU_, float**& bufV_,
                                 int w, int h)
  {
    freeBuffers(bufY_, bufU_, bufV_, w, h);
    if (w < 1 || w > 8192 || h < 1 || h > 6144)
      throw Ep128Emu::Exception("YUVImage: invalid image size");
    try {
      bufY_ = new float*[h];
      for (int yc = 0; yc < h; yc++)
        bufY_[yc] = (float *) 0;
      bufU_ = new float*[h];
      for (int yc = 0; yc < h; yc++)
        bufU_[yc] = (float *) 0;
      bufV_ = new float*[h];
      for (int yc = 0; yc < h; yc++)
        bufV_[yc] = (float *) 0;
      for (int yc = 0; yc < h; yc++)
        bufY_[yc] = new float[w];
      for (int yc = 0; yc < h; yc++)
        bufU_[yc] = new float[w];
      for (int yc = 0; yc < h; yc++)
        bufV_[yc] = new float[w];
    }
    catch (...) {
      freeBuffers(bufY_, bufU_, bufV_, w, h);
      throw;
    }
  }

  void YUVImage::freeBuffers(float**& bufY_, float**& bufU_, float**& bufV_,
                             int w, int h)
  {
    (void) w;
    if (bufY_) {
      for (int yc = 0; yc < h; yc++) {
        if (bufY_[yc]) {
          delete[] bufY_[yc];
          bufY_[yc] = (float *) 0;
        }
      }
      delete[] bufY_;
      bufY_ = (float **) 0;
    }
    if (bufU_) {
      for (int yc = 0; yc < h; yc++) {
        if (bufU_[yc]) {
          delete[] bufU_[yc];
          bufU_[yc] = (float *) 0;
        }
      }
      delete[] bufU_;
      bufU_ = (float **) 0;
    }
    if (bufV_) {
      for (int yc = 0; yc < h; yc++) {
        if (bufV_[yc]) {
          delete[] bufV_[yc];
          bufV_[yc] = (float *) 0;
        }
      }
      delete[] bufV_;
      bufV_ = (float **) 0;
    }
  }

  YUVImage::YUVImage(int w, int h)
    : bufY((float **) 0),
      bufU((float **) 0),
      bufV((float **) 0),
      width(w),
      height(h),
      borderColorY(0.0f),
      borderColorU(0.0f),
      borderColorV(0.0f)
  {
    allocateBuffers(bufY, bufU, bufV, width, height);
    this->clear();
  }

  YUVImage::YUVImage(const YUVImage& r)
    : bufY((float **) 0),
      bufU((float **) 0),
      bufV((float **) 0),
      width(r.width),
      height(r.height),
      borderColorY(r.borderColorY),
      borderColorU(r.borderColorU),
      borderColorV(r.borderColorV)
  {
    allocateBuffers(bufY, bufU, bufV, width, height);
    for (int yc = 0; yc < height; yc++) {
      for (int xc = 0; xc < width; xc++) {
        bufY[yc][xc] = r.bufY[yc][xc];
        bufU[yc][xc] = r.bufU[yc][xc];
        bufV[yc][xc] = r.bufV[yc][xc];
      }
    }
  }

  YUVImage::~YUVImage()
  {
    freeBuffers(bufY, bufU, bufV, width, height);
  }

  YUVImage& YUVImage::operator=(const YUVImage& r)
  {
    if (r.width != width || r.height != height) {
      float   **tmpBufY = (float **) 0;
      float   **tmpBufU = (float **) 0;
      float   **tmpBufV = (float **) 0;
      allocateBuffers(tmpBufY, tmpBufU, tmpBufV, r.width, r.height);
      freeBuffers(bufY, bufU, bufV, width, height);
      bufY = tmpBufY;
      bufU = tmpBufU;
      bufV = tmpBufV;
      width = r.width;
      height = r.height;
    }
    borderColorY = r.borderColorY;
    borderColorU = r.borderColorU;
    borderColorV = r.borderColorV;
    for (int yc = 0; yc < height; yc++) {
      for (int xc = 0; xc < width; xc++) {
        bufY[yc][xc] = r.bufY[yc][xc];
        bufU[yc][xc] = r.bufU[yc][xc];
        bufV[yc][xc] = r.bufV[yc][xc];
      }
    }
    return (*this);
  }

  void YUVImage::clear(float y_, float u_, float v_)
  {
    limitYUVColor(y_, u_, v_);
    for (int yc = 0; yc < height; yc++) {
      for (int xc = 0; xc < width; xc++) {
        bufY[yc][xc] = y_;
        bufU[yc][xc] = u_;
        bufV[yc][xc] = v_;
      }
    }
  }

  void YUVImage::resize(int w, int h)
  {
    if (w != width || h != height) {
      float   **tmpBufY = (float **) 0;
      float   **tmpBufU = (float **) 0;
      float   **tmpBufV = (float **) 0;
      allocateBuffers(tmpBufY, tmpBufU, tmpBufV, w, h);
      for (int yc = 0; yc < h; yc++) {
        for (int xc = 0; xc < w; xc++) {
          if (xc < width && yc < height) {
            tmpBufY[yc][xc] = bufY[yc][xc];
            tmpBufU[yc][xc] = bufU[yc][xc];
            tmpBufV[yc][xc] = bufV[yc][xc];
          }
          else {
            tmpBufY[yc][xc] = borderColorY;
            tmpBufU[yc][xc] = borderColorU;
            tmpBufV[yc][xc] = borderColorV;
          }
        }
      }
      freeBuffers(bufY, bufU, bufV, width, height);
      bufY = tmpBufY;
      bufU = tmpBufU;
      bufV = tmpBufV;
      width = w;
      height = h;
    }
  }

  void YUVImage::setBorderColor(float y_, float u_, float v_)
  {
    limitYUVColor(y_, u_, v_);
    borderColorY = y_;
    borderColorU = u_;
    borderColorV = v_;
  }

  void YUVImage::getPixel(int xc, int yc, float& y_, float& u_, float& v_) const
  {
    if (xc < 0 || xc >= width || yc < 0 || yc >= height) {
      y_ = borderColorY;
      u_ = borderColorU;
      v_ = borderColorV;
      return;
    }
    y_ = bufY[yc][xc];
    u_ = bufU[yc][xc];
    v_ = bufV[yc][xc];
  }

  void YUVImage::setPixel(int xc, int yc, float y_, float u_, float v_)
  {
    if (xc < 0 || xc >= width || yc < 0 || yc >= height)
      return;
    limitYUVColor(y_, u_, v_);
    bufY[yc][xc] = y_;
    bufU[yc][xc] = u_;
    bufV[yc][xc] = v_;
  }

  // --------------------------------------------------------------------------

  void IndexedImage::allocateBuffers(unsigned char**& buf_, int w, int h)
  {
    freeBuffers(buf_, w, h);
    try {
      if (w < 1 || w > 8192 || h < 1 || h > 6144)
        throw Ep128Emu::Exception("IndexedImage: invalid image size");
      buf_ = new unsigned char*[h];
      for (int yc = 0; yc < h; yc++)
        buf_[yc] = (unsigned char *) 0;
      for (int yc = 0; yc < h; yc++)
        buf_[yc] = new unsigned char[w];
    }
    catch (...) {
      freeBuffers(buf_, w, h);
      throw;
    }
  }

  void IndexedImage::freeBuffers(unsigned char**& buf_, int w, int h)
  {
    (void) w;
    if (buf_) {
      for (int yc = 0; yc < h; yc++) {
        if (buf_[yc]) {
          delete[] buf_[yc];
          buf_[yc] = (unsigned char *) 0;
        }
      }
      delete[] buf_;
      buf_ = (unsigned char **) 0;
    }
  }

  IndexedImage::IndexedImage(int w, int h)
    : buf((unsigned char **) 0),
      width(w),
      height(h),
      borderColor(0x00)
  {
    allocateBuffers(buf, width, height);
    this->clear();
  }

  IndexedImage::IndexedImage(const IndexedImage& r)
    : buf((unsigned char **) 0),
      width(r.width),
      height(r.height),
      borderColor(r.borderColor)
  {
    allocateBuffers(buf, width, height);
    for (int yc = 0; yc < height; yc++) {
      for (int xc = 0; xc < width; xc++)
        buf[yc][xc] = r.buf[yc][xc];
    }
  }

  IndexedImage::~IndexedImage()
  {
    freeBuffers(buf, width, height);
  }

  IndexedImage& IndexedImage::operator=(const IndexedImage& r)
  {
    if (r.width != width || r.height != height) {
      unsigned char **tmpBuf = (unsigned char **) 0;
      allocateBuffers(tmpBuf, r.width, r.height);
      freeBuffers(buf, width, height);
      buf = tmpBuf;
      width = r.width;
      height = r.height;
    }
    borderColor = r.borderColor;
    for (int yc = 0; yc < height; yc++) {
      for (int xc = 0; xc < width; xc++)
        buf[yc][xc] = r.buf[yc][xc];
    }
    return (*this);
  }

  void IndexedImage::clear(int c)
  {
    c = c & 0xFF;
    for (int yc = 0; yc < height; yc++) {
      for (int xc = 0; xc < width; xc++)
        buf[yc][xc] = (unsigned char) c;
    }
  }

  void IndexedImage::resize(int w, int h)
  {
    if (w != width || h != height) {
      unsigned char **tmpBuf = (unsigned char **) 0;
      allocateBuffers(tmpBuf, w, h);
      for (int yc = 0; yc < h; yc++) {
        for (int xc = 0; xc < w; xc++) {
          if (xc < width && yc < height)
            tmpBuf[yc][xc] = buf[yc][xc];
          else
            tmpBuf[yc][xc] = borderColor;
        }
      }
      freeBuffers(buf, width, height);
      buf = tmpBuf;
      width = w;
      height = h;
    }
  }

  void IndexedImage::setBorderColor(int c)
  {
    c = c & 0xFF;
    borderColor = (unsigned char) c;
  }

  unsigned char IndexedImage::getPixel(int xc, int yc) const
  {
    if (xc < 0 || xc >= width || yc < 0 || yc >= height)
      return borderColor;
    return buf[yc][xc];
  }

  void IndexedImage::setPixel(int xc, int yc, int c)
  {
    if (xc < 0 || xc >= width || yc < 0 || yc >= height)
      return;
    c = c & 0xFF;
    buf[yc][xc] = (unsigned char) c;
  }

  // --------------------------------------------------------------------------

  ImageConverter::ImageConverter()
    : progressMessageCallback(&defaultProgressMessageCb),
      progressMessageUserData((void *) 0),
      progressPercentageCallback(&defaultProgressPercentageCb),
      progressPercentageUserData((void *) 0),
      prvProgressPercentage(-1)
  {
  }

  ImageConverter::~ImageConverter()
  {
  }

  bool ImageConverter::processImage(ImageData& imgData, const char *infileName,
                                    YUVImageConverter& imgConv,
                                    const ImageConvConfig& config)
  {
    (void) imgData;
    (void) infileName;
    (void) imgConv;
    (void) config;
    return false;
  }

  void ImageConverter::setProgressMessageCallback(
      void (*func)(void *userData, const char *msg), void *userData_)
  {
    if (func) {
      progressMessageCallback = func;
      progressMessageUserData = userData_;
    }
    else {
      progressMessageCallback = &defaultProgressMessageCb;
      progressMessageUserData = (void *) 0;
    }
  }

  void ImageConverter::setProgressPercentageCallback(
      bool (*func)(void *userData, int n), void *userData_)
  {
    if (func) {
      progressPercentageCallback = func;
      progressPercentageUserData = userData_;
    }
    else {
      progressPercentageCallback = &defaultProgressPercentageCb;
      progressPercentageUserData = (void *) 0;
    }
  }

  void ImageConverter::progressMessage(const char *msg)
  {
    if (msg == (char *) 0)
      msg = "";
    progressMessageCallback(progressMessageUserData, msg);
  }

  bool ImageConverter::setProgressPercentage(int n)
  {
    limitValue(n, 0, 100);
    if (n != prvProgressPercentage) {
      prvProgressPercentage = n;
      return progressPercentageCallback(progressPercentageUserData, n);
    }
    return true;
  }

  // --------------------------------------------------------------------------

  void convertEPColorToYUV(int c, float& y, float& u, float& v,
                           double monitorGamma_)
  {
    int     ri = 0;
    int     gi = 0;
    int     bi = 0;
    convertEPColorToRGB(c, ri, gi, bi);
    float   r = float(ri) / 7.0;
    float   g = float(gi) / 7.0;
    float   b = float(bi) / 3.0;
    if (monitorGamma_ < 0.99999 || monitorGamma_ > 1.00001) {
      r = float(std::pow(double(r), monitorGamma_));
      g = float(std::pow(double(g), monitorGamma_));
      b = float(std::pow(double(b), monitorGamma_));
    }
    rgbToYUV(y, u, v, r, g, b);
  }

  void convertTVCColorToYUV(int c, float& y, float& u, float& v,
                            double monitorGamma_)
  {
    c = (c | (c >> 1)) & 0x55;
    float   i = (!(c & 0x40) ? float(4.0 / 7.0) : 1.0f);
    float   r = (!(c & 0x04) ? 0.0f : i);
    float   g = (!(c & 0x10) ? 0.0f : i);
    float   b = (!(c & 0x01) ? 0.0f : i);
    if (monitorGamma_ < 0.99999 || monitorGamma_ > 1.00001) {
      r = float(std::pow(double(r), monitorGamma_));
      g = float(std::pow(double(g), monitorGamma_));
      b = float(std::pow(double(b), monitorGamma_));
    }
    rgbToYUV(y, u, v, r, g, b);
  }

  void limitYUVColorToRGB(float& y, float& u, float& v)
  {
    double  r = 0.0;
    double  g = 0.0;
    double  b = 0.0;
    yuvToRGB(r, g, b, double(y), double(u), double(v));
    limitRGBColor(r, g, b);
    double  tmpY = (r * 0.299) + (g * 0.587) + (b * 0.114);
    yuvToRGB(r, g, b, tmpY, double(u), double(v));
    double  minVal = (r < g ? r : g);
    minVal = (minVal < b ? minVal : b);
    double  maxVal = (r > g ? r : g);
    maxVal = (maxVal > b ? maxVal : b);
    double  tmp1 = 1.0;
    if (minVal < -0.0001)
      tmp1 = tmpY / (tmpY - minVal);
    double  tmp2 = 1.0;
    if (maxVal > 1.0001)
      tmp2 = (1.0 - tmpY) / (maxVal - tmpY);
    tmp1 = (tmp1 < tmp2 ? tmp1 : tmp2);
    y = float(tmpY);
    u = float(double(u) * tmp1);
    v = float(double(v) * tmp1);
  }

  int getRandomNumber(int& seedValue)
  {
    int64_t   tmp = int32_t(seedValue) * int64_t(742938285);
    uint32_t  tmp2 = uint32_t(tmp & int64_t(0x7FFFFFFF)) + uint32_t(tmp >> 31);
    if (tmp2 >= 0x80000000U)
      tmp2 = tmp2 - 0x7FFFFFFFU;
    seedValue = int(tmp2);
    return seedValue;
  }

  void setRandomSeed(int& seedValue, uint32_t n)
  {
    while (n >= 0x7FFFFFFFU)
      n = n - 0x7FFFFFFEU;
    if (n == 0U)
      n = 0x7FFFFFFEU;
    seedValue = int(n);
    (void) getRandomNumber(seedValue);
  }

  void ditherLine(IndexedImage& ditheredImage, const YUVImage& inputImage,
                  YUVImage& ditherErrorImage,
                  long yc, int ditherType, double ditherDiffusion,
                  double colorErrorScale,
                  const unsigned char *linePalette, size_t linePaletteSize,
                  const float *epPaletteY, const float *epPaletteU,
                  const float *epPaletteV)
  {
    if (ditherType >= 4) {
      ditherLine_ordered(ditheredImage, inputImage, yc, ditherType,
                         linePalette, linePaletteSize, epPaletteY);
      return;
    }
    int     w = ditheredImage.getWidth();
    if (w < inputImage.getWidth())
      w = inputImage.getWidth();
    if (w < ditherErrorImage.getWidth())
      w = ditherErrorImage.getWidth();
    int     h = ditheredImage.getHeight();
    if (h < inputImage.getHeight())
      h = inputImage.getHeight();
    if (h < ditherErrorImage.getHeight())
      h = ditherErrorImage.getHeight();
    if (yc < 0L || yc >= long(h))
      return;
    for (int xc = 0; xc < w; xc++) {
      if ((yc & 1L) != 0L)
        xc = (w - 1) - xc;
      float   y0 = inputImage.y(xc, yc);
      float   u0 = inputImage.u(xc, yc);
      float   v0 = inputImage.v(xc, yc);
      float   y = y0 + ditherErrorImage.y(xc, yc);
      float   u = u0 + ditherErrorImage.u(xc, yc);
      float   v = v0 + ditherErrorImage.v(xc, yc);
      limitYUVColor(y, u, v);
      double  bestError = 1000000000.0;
      int     bestColor = 0;
      for (size_t i = 0; i < linePaletteSize; i++) {
        // find nearest color
        int     c = linePalette[i];
        double  err =
            calculateYUVErrorSqr(epPaletteY[c], epPaletteU[c], epPaletteV[c],
                                 y, u, v, colorErrorScale);
        if (err < bestError) {
          bestColor = int(i);
          bestError = err;
        }
      }
      ditheredImage[yc][xc] = (unsigned char) (bestColor & 0xFF);
      limitYUVColorToRGB(y, u, v);
      float   yErr = (y0 + ((y - y0) * float(ditherDiffusion)))
                     - epPaletteY[linePalette[bestColor]];
      float   uErr = (u0 + ((u - u0) * float(ditherDiffusion)))
                     - epPaletteU[linePalette[bestColor]];
      float   vErr = (v0 + ((v - v0) * float(ditherDiffusion)))
                     - epPaletteV[linePalette[bestColor]];
      switch (ditherType) {
      case 1:                                   // Floyd-Steinberg
        for (int j = 0; j < 2; j++) {
          long    yc_ = yc + j;
          if (yc_ >= long(h))
            break;
          for (int i = (j > 0 ? -1 : 1); i < 2; i++) {
            long    xc_ = xc + ((yc & 1L) == 0L ? i : (-i));
            if (xc_ < 0L || xc_ >= long(w))
              continue;
            float   errMult =
                float(j > 0 ? (i < 0 ? 3 : (i > 0 ? 1 : 5)) : 7) / 16.0f;
            ditherErrorImage.y(xc_, yc_) += (yErr * errMult);
            ditherErrorImage.u(xc_, yc_) += (uErr * errMult);
            ditherErrorImage.v(xc_, yc_) += (vErr * errMult);
          }
        }
        break;
      case 2:                                   // Stucki
        for (int j = 0; j < 3; j++) {
          long    yc_ = yc + j;
          if (yc_ >= long(h))
            break;
          for (int i = (j > 0 ? -2 : 1); i < 3; i++) {
            long    xc_ = xc + ((yc & 1L) == 0L ? i : (-i));
            if (xc_ < 0L || xc_ >= long(w))
              continue;
            float   errMult = float(16 >> (j + (i >= 0 ? i : (-i)))) / 42.0f;
            ditherErrorImage.y(xc_, yc_) += (yErr * errMult);
            ditherErrorImage.u(xc_, yc_) += (uErr * errMult);
            ditherErrorImage.v(xc_, yc_) += (vErr * errMult);
          }
        }
        break;
      case 3:                                   // Jarvis
        for (int j = 0; j < 3; j++) {
          long    yc_ = yc + j;
          if (yc_ >= long(h))
            break;
          for (int i = (j > 0 ? -2 : 1); i < 3; i++) {
            long    xc_ = xc + ((yc & 1L) == 0L ? i : (-i));
            if (xc_ < 0L || xc_ >= long(w))
              continue;
            float   errMult = (4.5f - float(j + (i >= 0 ? i : (-i)))) / 24.0f;
            ditherErrorImage.y(xc_, yc_) += (yErr * errMult);
            ditherErrorImage.u(xc_, yc_) += (uErr * errMult);
            ditherErrorImage.v(xc_, yc_) += (vErr * errMult);
          }
        }
        break;
      default:                                  // no dithering
        break;
      }
      if ((yc & 1L) != 0L)
        xc = (w - 1) - xc;
    }
  }

  void ditherLine_ordered(IndexedImage& ditheredImage,
                          const YUVImage& inputImage, long yc, int ditherType,
                          const unsigned char *linePalette,
                          size_t linePaletteSize, const float *epPaletteY)
  {
    int     w = ditheredImage.getWidth();
    if (w < inputImage.getWidth())
      w = inputImage.getWidth();
    int     h = ditheredImage.getHeight();
    if (h < inputImage.getHeight())
      h = inputImage.getHeight();
    if (yc < 0L || yc >= long(h))
      return;
    const int *ditherTable = &(ditherTable_Bayer[0]);
    if (ditherType == 5)
      ditherTable = &(ditherTable_rand[0]);
    if (linePaletteSize == 256) {
      // RGB dither
      for (int xc = 0; xc < w; xc++) {
        float   y = inputImage.y(xc, yc);
        float   u = inputImage.u(xc, yc);
        float   v = inputImage.v(xc, yc);
        float   r = 0.0f;
        float   g = 0.0f;
        float   b = 0.0f;
        yuvToRGB(r, g, b, y, u, v);
        r = r * 7.0f;
        g = g * 7.0f;
        b = b * 3.0f;
        int     ri = 0;
        int     gi = 0;
        int     bi = 0;
        float   th = (float(ditherTable[((yc & 63L) << 6) + (xc & 63)]) + 0.5f)
                     / 4096.0f;
        if (r >= 7.0f)
          ri = 7;
        else if (r > 0.0f)
          ri = int(r) + int((r - float(int(r))) >= th);
        if (g >= 7.0f)
          gi = 7;
        else if (g > 0.0f)
          gi = int(g) + int((g - float(int(g))) >= th);
        if (b >= 3.0f)
          bi = 3;
        else if (b > 0.0f)
          bi = int(b) + int((b - float(int(b))) >= th);
        int     c = 0;
        convertRGBToEPColor(c, ri, gi, bi);
        ditheredImage.setPixel(xc, yc, c);
      }
    }
    else if (linePaletteSize > 0) {
      // luminance-only dither using the specified palette
      for (int xc = 0; xc < w; xc++) {
        float   y = inputImage.y(xc, yc);
        y = (y > 0.0f ? (y < 1.0f ? y : 1.0f) : 0.0f);
        float   y0 = -1.0f;
        float   y1 = 2.0f;
        int     c0 = -1;
        int     c1 = -1;
        for (size_t i = 0; i < linePaletteSize; i++) {
          if (i == 9)
            i = 15;
          float   y_ = epPaletteY[linePalette[i]];
          if (y_ > y0 && y_ <= y) {
            y0 = y_;
            c0 = i;
          }
          if (y_ < y1 && y_ >= y) {
            y1 = y_;
            c1 = i;
          }
        }
        if (c0 < 0 || c1 < 0 || (y1 - y0) < 0.0001f) {
          ditheredImage.setPixel(xc, yc, (c0 < 0 ? c1 : c0));
        }
        else {
          float   th =
              (float(ditherTable[((yc & 63L) << 6) + (xc & 63)]) + 0.5f)
              / 4096.0f;
          ditheredImage.setPixel(xc, yc,
                                 (((y - y0) / (y1 - y0)) >= th ? c1 : c0));
        }
      }
    }
  }

  void ditherLine_ordered_TVC16(IndexedImage& ditheredImage,
                                const YUVImage& inputImage, long yc,
                                int ditherType)
  {
    int     w = ditheredImage.getWidth();
    if (w < inputImage.getWidth())
      w = inputImage.getWidth();
    int     h = ditheredImage.getHeight();
    if (h < inputImage.getHeight())
      h = inputImage.getHeight();
    if (yc < 0L || yc >= long(h))
      return;
    const int *ditherTable = &(ditherTable_Bayer[0]);
    if (ditherType == 5)
      ditherTable = &(ditherTable_rand[0]);
    // IRGB dither
    for (int xc = 0; xc < w; xc++) {
      float   y = inputImage.y(xc, yc);
      float   u = inputImage.u(xc, yc);
      float   v = inputImage.v(xc, yc);
      float   r = 0.0f;
      float   g = 0.0f;
      float   b = 0.0f;
      yuvToRGB(r, g, b, y, u, v);
      float   i = (r > g ? r : g);
      i = (b > i ? b : i);
      float   th = (float(ditherTable[((yc & 63L) << 6) + (xc & 63)]) + 0.5f)
                   / 4096.0f;
      int     c = 0;
      if (i >= float(4.0 / 7.0)) {
        c = 8;
      }
      else {
        r = r * float(7.0 / 4.0);
        g = g * float(7.0 / 4.0);
        b = b * float(7.0 / 4.0);
      }
      if (r >= th)
        c = c | 2;
      if (g >= th)
        c = c | 4;
      if (b >= th)
        c = c | 1;
      c = (c != 8 ? c : 0);
      ditheredImage.setPixel(xc, yc, c);
    }
  }

  // --------------------------------------------------------------------------

  ImageData *convertImage(
      const char *inputFileName, const ImageConvConfig& config_,
      void (*progressMessageCallback)(void *userData, const char *msg),
      bool (*progressPercentageCallback)(void *userData, int n),
      void *progressCallbackUserData)
  {
    if (!inputFileName || inputFileName[0] == '\0')
      throw Ep128Emu::Exception("invalid input file name");
    ImageConvConfig config;
    // FIXME: ugly hack to use a local copy of the configuration; this code
    // assumes that 'outputFormat' is the first configuration variable and
    // 'configChangeFlag' is after the last one
    std::memcpy(&(config.outputFormat), &(config_.outputFormat),
                size_t((unsigned char *) &(config_.configChangeFlag)
                       - (unsigned char *) &(config_.outputFormat)));
    config.configChangeFlag = false;
    if (config.width < 1 || config.height < 1) {
      if (config.width < 1 && config.height < 1)
        throw Ep128Emu::Exception("invalid output image size");
      // width or height is unspecified, calculate from the other value
      // and image aspect ratio
      Fl_Shared_Image *f = Fl_Shared_Image::get(inputFileName);
      if (!f)
        throw Ep128Emu::Exception("error opening image file");
      int     w = f->w();
      int     h = f->h();
      f->release();
      f = (Fl_Shared_Image *) 0;
      if (w < 1 || w > 16384 || h < 1 || h > 16384)
        throw Ep128Emu::Exception("invalid input image size");
      double  aspectRatio = double(w) / double(h);
      w = config.width;
      h = config.height;
      if (w < 1) {
        w = int(double(h) * aspectRatio * 0.125 + 0.9);
        if (config.width < 0 && (-w) < config.width) {
          w = -(config.width);
          h = int(double(w) / (aspectRatio * 0.125) + 0.9);
        }
      }
      else {
        h = int(double(w) / (aspectRatio * 0.125) + 0.9);
        if (config.height < 0 && (-h) < config.height) {
          h = -(config.height);
          w = int(double(h) * aspectRatio * 0.125 + 0.9);
        }
      }
      limitValue(w, 1, 255);
      limitValue(h, 1, 16384);
      config.width = w;
      config.height = h;
      std::printf("Output image size: %d, %d\n", w, h);
    }
    int     outputFormat = config.getOutputFormat();
    if (!((outputFormat >= 0 && outputFormat <= 6) ||
          (outputFormat >= 11 && outputFormat <= 59 &&
           outputFormat != 20 && outputFormat != 30 && outputFormat != 40))) {
      throw Ep128Emu::Exception("invalid output format");
    }
    // TVC video modes are only valid when using TVC KEP output format
    if ((outputFormat >= 50) != ((config.conversionType % 10) >= 7))
      throw Ep128Emu::Exception("invalid video mode for output format");
    if (outputFormat >= 2 && outputFormat <= 5) {
      // non-IVIEW formats do not support interlace
      // Agsys CRF format only supports 4-color PIXEL mode
      // ZozoTools VL/VS format does not support attribute mode
      if (config.conversionType >= 10 ||
          (outputFormat == 2 && config.conversionType != 1) ||
          (outputFormat == 3 && config.conversionType == 6)) {
        throw Ep128Emu::Exception("invalid video mode for output format");
      }
      if (outputFormat >= 3 && outputFormat <= 5) {
        // make sure that the output image size is EXOS compatible
        int     newWidth = config.width;
        int     newHeight = (config.height + 8) / 9;
        limitValue(newWidth, 1, 42);
        limitValue(newHeight, 1, 27);
        newHeight = newHeight * 9;
        if (newWidth != config.width || newHeight != config.height) {
          config.width = newWidth;
          config.height = newHeight;
          std::fprintf(stderr, "WARNING: image size changed to %d,%d "
                               "for compatibility with output format\n",
                       newWidth, newHeight);
        }
      }
    }
    if ((outputFormat >= 3 && outputFormat <= 6) &&
        config.paletteResolution != 0) {
      config.paletteResolution = 0;
      std::fprintf(stderr, "WARNING: output format supports fixed palette "
                           "only, setting -palres 0\n");
    }
    int     videoMode = 0;
    int     biasResolution = 0;
    int     interlaceMode = 0;
    int     compressionType = 0;
    if (config.conversionType >= 10 && config.conversionType <= 19) {
      config.conversionType = config.conversionType % 10;
      interlaceMode = 0x9C;
    }
    if (config.paletteResolution == 0)
      interlaceMode = interlaceMode & 0x98;     // fixed palette
    switch (config.conversionType) {
    case 0:                                     // PIXEL / 2 colors
    case 7:                                     // TVC 2 colors
      videoMode = 0x02;
      interlaceMode = interlaceMode & 0x94;
      for (int i = 0; i < 2; i++) {
        if (config.paletteColors[i] < 0)
          break;
        if (i == 1) {
          config.paletteResolution = 0;
          interlaceMode = interlaceMode & 0x90;
        }
      }
      break;
    case 1:                                     // PIXEL / 4 colors
    case 8:                                     // TVC 4 colors
      videoMode = 0x22;
      interlaceMode = interlaceMode & 0x94;
      for (int i = 0; i < 4; i++) {
        if (config.paletteColors[i] < 0)
          break;
        if (i == 3) {
          config.paletteResolution = 0;
          interlaceMode = interlaceMode & 0x90;
        }
      }
      break;
    case 2:                                     // PIXEL / 16 colors
    case 3:
    case 4:
      videoMode = 0x42;
      interlaceMode = interlaceMode & 0x94;
      for (int i = 0; i < 8; i++) {
        if (config.paletteColors[i] < 0)
          break;
        if (i == 7) {
          config.paletteResolution = 0;
          interlaceMode = interlaceMode & 0x90;
        }
      }
      break;
    case 5:                                     // PIXEL / 256 colors
    case 9:                                     // TVC 16 colors
      videoMode = (config.conversionType == 5 ? 0x62 : 0x42);
      config.paletteResolution = 0;
      interlaceMode = interlaceMode & 0x90;
      break;
    case 6:                                     // ATTRIBUTE / 16 colors
      if (config.ditherType >= 4) {
        throw Ep128Emu::Exception("ordered dither is not supported in "
                                  "attribute mode");
      }
      videoMode = 0x04;
      for (int i = 0; i < 8; i++) {
        if (config.paletteColors[i] < 0)
          break;
        if (i == 7) {
          config.paletteResolution = 0;
          interlaceMode = interlaceMode & 0x98;
        }
      }
      break;
    default:
      throw Ep128Emu::Exception("invalid video mode");
    }
    ImageConverter  *converter = (ImageConverter *) 0;
    ImageData       *imgData = (ImageData *) 0;
    try {
      imgData = new ImageData(config.width, config.height, videoMode,
                              biasResolution, config.paletteResolution,
                              interlaceMode, compressionType);
      switch (config.conversionType) {
      case 0:                                   // PIXEL / 2 colors
        converter = new ImageConv_Pixel2();
        break;
      case 1:                                   // PIXEL / 4 colors
        converter = new ImageConv_Pixel4();
        break;
      case 2:                                   // PIXEL / 16 colors
      case 3:
        converter = new ImageConv_Pixel16_1();
        break;
      case 4:
        converter = new ImageConv_Pixel16_2();
        break;
      case 5:                                   // PIXEL / 256 colors
        converter = new ImageConv_Pixel256();
        break;
      case 6:                                   // ATTRIBUTE / 16 colors
        converter = new ImageConv_Attr16();
        break;
      case 7:                                   // TVC 2 colors
        converter = new ImageConv_TVCPixel2();
        break;
      case 8:                                   // TVC 4 colors
        converter = new ImageConv_TVCPixel4();
        break;
      case 9:                                   // TVC 16 colors
        converter = new ImageConv_TVCPixel16();
        break;
      }
      if (progressMessageCallback && progressPercentageCallback) {
        converter->setProgressMessageCallback(progressMessageCallback,
                                              progressCallbackUserData);
        converter->setProgressPercentageCallback(progressPercentageCallback,
                                                 progressCallbackUserData);
      }
      YUVImageConverter imgConv;
      imgConv.setScaleMode(config.scaleMode);
      imgConv.setXYScaleAndOffset(float(config.scaleX), float(config.scaleY),
                                  float(config.offsetX), float(config.offsetY));
      imgConv.setEnableInterpolation(!config.noInterpolation);
      imgConv.setGammaCorrection(float(config.gammaCorrection), 1.0f);
      imgConv.setLuminanceRange(float(config.yMin), float(config.yMax));
      imgConv.setColorSaturation(float(config.colorSaturationMult));
      imgConv.setImageSize(config.width * 16, config.height * 2);
      imgConv.setPixelAspectRatio(1.0f);
      if (progressMessageCallback && progressPercentageCallback) {
        imgConv.setProgressMessageCallback(progressMessageCallback,
                                           progressCallbackUserData);
        imgConv.setProgressPercentageCallback(progressPercentageCallback,
                                              progressCallbackUserData);
      }
      float   borderY = 0.0f;
      float   borderU = 0.0f;
      float   borderV = 0.0f;
      if (config.conversionType < 7)
        convertEPColorToYUV(config.borderColor, borderY, borderU, borderV);
      else
        convertTVCColorToYUV(config.borderColor, borderY, borderU, borderV);
      imgConv.setBorderColor(borderY, borderU, borderV);
      imgData->setBorderColor(config.borderColor);
      if (!(converter->processImage(*imgData, inputFileName,
                                    imgConv, config))) {
        delete imgData;
        imgData = (ImageData *) 0;
      }
      delete converter;
      converter = (ImageConverter *) 0;
    }
    catch (...) {
      if (converter)
        delete converter;
      if (imgData)
        delete imgData;
      throw;
    }
    return imgData;
  }

}       // namespace Ep128ImgConv

