INCLUDE "COUNTER.INC"

ORG 256

 CWD

 PUSH   08000H                  ; ES and DS both points to the video memory
 POP    ES                      ; for a shorter blur code
 MOV CH,128
 REP STOSW

; MOV GS,AX
; MOV    AL,13H                  ; set video mode 320x200
; INT    10H                     ; call VGA Bios

 MOV    BP,text                 ; using BP to easy index the code segment
 PUSH   ES
 POP    DS
 MOV    DI,24+8*14+48+8*13+320*9; starting position to draw
.2:
 MOV    BX,320                  ; the linelen constant for cheaper indexes
 MOV    CL,45                   ; number of iterations of the blur
.7:

.8:
 ADD    AL,[SI+1]               ; AL contains 0 at start, and last color later
 ADC    AH,CH                   ; summing the 4 neighbours
.6:
 ADD    AL,[SI+BX]
 ADC    AH,CH
 NEG    BX
 JS     .6
 SHR    AX,2                    ; dividing by 4
 MOV    [SI],AL                 ; writing back the average
 INC    SI                      ; go to the next pixel
 JNZ    .8

 CMP    CL,5                    ; after 40 iterations
 JNE    .9                      ; and before the last 5 iterations
 PUSHA                          ; insert some smaller blocks (3x2 pixel)
 DEC    AX
 PUSH   320*55+181              ; scr pos of left breast
 PUSH   320*52+247              ; scr pos of right breast
 PUSH   320*118+232             ; scr pos of navel
@@:
 POP    DI
 MOV    [DI+BX],AX
 STOSW
 MOV    [DI+BX],AL
 STOSB
 INC    DX
 JPO    @B
 POPA
.9:
 LOOP   .7

 MOV    SI,26*14-16             ; number of bits
 MOV    DL,14                   ; coloums of the image
.3:
 MOV    CL,26                   ; raws of the image
.4:
 BT     [BP-text+bits],SI       ; the bit means a block colored with 0 or 255
 SALC
 CBW
 MOV    BX,7                    ; drawing the bigblocks (8x7 pixel)
.5:
 STOSW
 STOSW
 STOSW
 STOSW
 ADD    DI,320-8
 DEC    BX
 JNZ    .5
 DEC    SI                      ; counting the bits left
 LOOPNZ .4                      ; repeat until bottom of scr or end of bits
 SUB    DI,320*7*26+8
 DEC    DX                      ; go to next coloum
 JNZ    .3
 ADD    DI,-7430H               ; DI = 24+8*13+320*9
 JPE    .2                      ; loop twice and we need the carry later

 MOV BL,253
setpal:
.1:
 IMUL   DX,BX,6DH               ; setting the color palette
 IMUL   CX,BX,3FH               ; from color black to brown
 IMUL   AX,BX,30H
 CMP    BL,105
 JB     .2
 IMUL   DX,BX,37H               ; then from brown to yellowish body color
 IMUL   CX,BX,50H
 IMUL   AX,BX,5CH
 ADD    DH,016H
 ADD    CH,0F9H
 ADD    AH,0EDH
.2:
 MOV    CL,AH                   ; DH/CH/CL->R/G/B
 MOV    AX,1010H                ; set only one color by the VGA BIOS
 INT    10H
 DEC    BX                      ; BX is the color index
 JNS    .1                      ; one by one from #253 to #1
 MOV    CX,256*42+42
 MOV    DH,28
 INT    10H                     ; set color #255: turquoise blue
 DEC    BX
 DEC    BX
 MOV    CL,0
 INT    10H                     ; set color #253: nVidia green

main0:
 NEG BYTE [BP-text+pic-1]
 XOR BYTE [BP-text+color-2],2
 XOR WORD [BP+5],"ff" XOR "n "

 MOV DX,23
 MOV AX,1300H
 PUSH 0A000H
 POP ES
 MOV DI,80
@@:
 MOV CX,80
 LEA SI,[DI+80]
pic:
 REP MOVSW
 ADD DI,160
 JNC @B

 PUSH   ES
 PUSH   CS
 POP    ES
 MOV    CL,7
 MOV    BX,253
color:
 INT    10H
 POP    ES

 MOV DH,[COUNTER+1]

main:
 CALL ESCAPE
 MOV AH,AL;[COUNTER+1]
 MOV    DI,160+80

 MOV    BL,200
.1:
 MOV    CL,160
.2:
 MOV    AL,CL
 SUB    AL,80
 JB     .3
 NEG    AL
.3:
 MOV    DL,BL
 SUB    DL,100
 JB     .4
 NEG    DL
.4:
 SUB    AL,DL
 ADD    AL,80
 MOV    DL,AL
 SUB    DL,AH
 TEST   DL,16
 JZ     .5
 SHR    AL,1
.5:

CMP    AH,60
JNB    .6
SUB    DL,AH
SUB    DL,AH
SUB    DL,AH
;JNZ    .6
;MOV    AL,196

.6:
 STOSB
 LOOP   .2

.8:
 ADD    DI,160

 DEC    BX
 JNZ    .1

 SUB AH,DH
 JNC @F
 NEG AH
@@:
 CMP AH,32
 JB main

 JMP main0

text:
 DB 'RTX on '                   ; 1st text

bits:
 file 'BITS4.BIN':0,44          ; bits of image

