Unit xPlayer;

Interface

Const
  MaxPlayers = 10;

Type
  APlayer = Packed Record
    text    : string;
    login   : longint;
    logoff  : longint;
    score   : integer;
    moves   : integer;
  end;
  
Var
  Highscore : Array[1..MaxPlayers] of APlayer;
  HighScoreFile : String;
  
Procedure InitPlayer(var pl:APlayer);
Function  ExitPlayer(var pl:APlayer):Boolean;
Procedure AddScore(var pl:APlayer; Score:integer);
Function  CreateHighScoreTable:Boolean;
Function  ReadHighScoreTable:Boolean;

Implementation

Uses 
  xDate,
  xFiles;

Procedure  InitPlayer(var pl:APlayer);
Begin
  pl.text   := 'Player';
  pl.login  := TimerMinutes;
  pl.logoff := 0;
  pl.score  := 0;
  pl.moves  := 0;
End;

Procedure  AddScore(var pl:APlayer; Score:integer);
Begin
  pl.score := pl.score + score;
End;

Function  CreateHighScoreTable:Boolean;
Var
  i : integer;
  pl : Aplayer;
  hf : file;
Begin
  CreateHighScoreTable := False;
  if fileexist(HighScoreFile) then exit;
  for i:=1 to MaxPlayers do InitPlayer(Highscore[i]);
  assign(hf,HighScoreFile);
  {$I-}rewrite(hf,1);{$I+}
  blockwrite(hf,Highscore,sizeof(Highscore));
  close(hf);  
  CreateHighScoreTable := True;
End;

Function   ExitPlayer(var pl:APlayer):Boolean;
var
  hf : file;
  Count1 : integer;
  Count2 : integer;
Begin
  ExitPlayer := False;
  pl.logoff := TimerMinutes;
  if pl.score = 0 then exit;
  if not fileexist(HighScoreFile) then exit;
  
  assign(hf,HighScoreFile);
  {$I-}reset(hf,1);{$I+}
  blockread(hf,Highscore,sizeof(Highscore));
  close(hf);  
  
  Count1:=0;
  While Count1<=MaxPlayers Do Begin
    Count1:=Count1+1;
    If Highscore[Count1].Score<=pl.score Then Begin
      For Count2:=MaxPlayers-1 downto count1 Do Highscore[Count2+1]:=Highscore[Count2];
      Highscore[Count1]:=pl;
      Count1:=MaxPlayers+1;
    End;
  End;
  
  assign(hf,HighScoreFile);
  {$I-}reset(hf,1);{$I+}
  blockwrite(hf,Highscore,sizeof(Highscore));
  close(hf); 
  ExitPlayer := True;
End;

Function  ReadHighScoreTable:Boolean;
var
  hf : file;
Begin
  ReadHighScoreTable := False;
  if not fileexist(HighScoreFile) then exit;
  
  assign(hf,HighScoreFile);
  {$I-}reset(hf,1);{$I+}
  blockread(hf,Highscore,sizeof(Highscore));
  close(hf);
  ReadHighScoreTable := True;
End;  

Begin
End.
