;=========================================================================
; Vintage Computing Christmas Challenge 2025
; Language: 8086 Assembler / 16-bit / IBM PC and above
; Copyright (C) 2025 Sergey Kiselev
;
; The code uses -9 to 9 grid in both horizontal (X) and vertical (Y) dimensions
; It relies on the following observations:
; - Symmetry: 1/8 of the image can be mirrored, and then rotated 4 times
;   to draw the entire image
; - There are solid horizontal and vertical lines at X=0 and Y=0
; - There are solid diagonal lines at Y=|X| && |X| <= 7
; The solid lines are printed using simple coordinates comparison
; The remaining 6 asterisks are printed by comparing their absolute coordinates
;=========================================================================
.model tiny
.code
		org	100h
main		proc
		mov	bh,-9		; BH - X coordinate (column) [-9..9]
next_x:
		mov	bl,-9		; BL - Y coordinate (row) [-9..9]
next_y:
		mov	ax,bx		; AH = X, AL = Y
		or	al,al		; Y == 0?
		jz	print_asterisk	; Y == 0; print an asterisk
		jg	positive_y	; Y > 0
		neg	al		; Y = abs(Y)
positive_y:
		or	ah,ah		; X == 0?
		jz	print_asterisk	; X == 0; print an asterisk
		jg	positive_x	; X > 0
		neg	ah		; X = abs(X)
positive_x:
		cmp	al,ah		; Y == X?
		jb	x_less_than_y	; X < Y
		ja	x_more_than_y	; X > Y
		cmp	al,7		; X == Y
		jbe	print_asterisk	; X == Y <= 7 ; print an asterisk
x_less_than_y:
		xchg	ah,al		; Mirror over the Y = X axis
x_more_than_y:
		mov	di,offset asterisks
		mov	cx,6
		cld
	repne	scasw			; compare AX with asterisks coordinates
		je	print_asterisk

		mov	dl,' '		; Print space
		jmp	print

print_asterisk:
		mov	dl,'*'		; Print asterisk
print:
		mov	ah,02h		; Print character in DL
		int	21h
		inc	bl		; Y = Y + 1
		cmp	bl,9
		jle	next_y
;		mov	ah,02h		; AH is saved from previous call
		mov	dl,0Dh		; Print "Carriage Return"
		int	21h
;		mov	ah,02h		; AH is saved from previous call
		mov	dl,0Ah		; Print "New Line"
		int	21h
		inc	bh		; X = X + 1
		cmp	bh,9
		jle	next_x
;		mov	ah,4ch		; Exit to DOS
;		int	21h
		ret			; COM program can exit with a RET
asterisks	dw	0507h, 0107h, 0208h, 0506h, 0205h, 0104h
main		endp
end		main