; CUKI (cute) 256b DOS intro by TomCat/Abaddon
; welcome to the new Hungarian demoparty T0AD

; painting a panda with half spaces (half planes)

ZOOM EQU 16*5
P1 EQU 64		; tong color index
C3 EQU 124		; background color index

ORG 256
 MOV AL,13H
 INT 10H
 PUSH 0A000H-10 	; horizontal half screen shift
 POP ES
nextframe:
nextpixel:
 CWD
 MOV BP,320		; BP: line length
 MOV AX,DI		; DX+AX: pixel offset
 DIV BP 		; AX: Y coord, DX: X coord
 CMP DX,160		; skipping the 1st half the line
 JNB skippixel
 SUB AL,100		; centering the sceen in vertical direction

 MOV BL,16		; default black color
 MOV SI,startdata	; half spaces data
nextplane:
 PUSHA

 PUSH CX		; adjusting the direction by the frame counter
 SHR CH,1
 JNC .1
 MOV CL,0
.1:			; multiplying the direction by the screen coords
 MOV AH,[SI]
 ADD AH,CL
 SHL AH,4
 IMUL AH
 XCHG BP,AX

 LODSB
 ADD AL,CL
 AND AL,0F0H
 CBW
 IMUL DX
 ADD BP,AX

 POP AX
 SHL AL,1		; zoom in/out
 CBW			; zoom factor from 16 to 64+16
 XOR AL,AH
 SHR AL,1
 ADD AL,16
 IMUL BYTE [SI] 	; distance multiplying by the zoom factor
 INC SI

 ADD BP,AX
 MOV AH,[SI]
 JNS nohit		; dont want to paint this half plane

 LODSB			; fill or overwrite?
 SHR AL,1
 JNC fill
 CMP AL,BL		; is it the right color for overwite?
 JNE nohit
 LODSB
fill:
 MOV [WORD -10],AL	; BL on the stack (AL: new color)
nohit:
 SAHF
 POPA
 ADC SI,3

 CMP SI,enddata
 JC nextplane

 IMUL BP,DX,-2		; BP: -2 * X coord
 XCHG AX,BX
 STOSB
 AAM 64 		; calculating the mirrored color
 AAD 64+22		; +24 for the color index
 ADD AL,2		; but only +2 for the gray colors
 MOV [ES:BP+DI-2],AL	; mirroring to the left
 DEC DI

skippixel:
 INC DI
 JNZ nextpixel

 DEC CX 		; decrementing the frame counter
 HLT
 IN AL,60H
 DEC AX
 JNZ nextframe
RETN

startdata:
; data structure of half spaces
; byte1: direction by digits x/y incremets
; byte2: distance from the origo
; byte3: (new color * 2) or (1 + old color * 2)
; byte4: (optional) new color
 DB 03CH,-8*4/5,2*29
 DB 0C1H,180*1/5,2*24
 DB 0E3H,40*3/5,2*27
 DB 0FBH,20*5/5,2*19
 DB 02BH,-29*5/5,1+2*27,24
 DB 09FH,348*1/5,1+2*19,26

 DB 01AH,37*6/5,1+2*19,18

 DB 021H,-30*1/5,2*28
 DB 03FH,-70*1/5,1+2*19,29

 DB 081H,95*1/5,1+2*29,27
 DB 01AH,0*6/5,1+2*28,29

 DB 01CH,22*4/5,1+2*19,27

 DB 0F0H,25*1/5,1+2*28,27
 DB 032H,10*2/5,1+2*27,28

 DB 0F6H,70*6/5,1+2*28,C3
 DB 0D4H,90*4/5,1+2*27,17
 DB 0E1H,160*1/5,1+2*27,17

 DB 017H,72*7/5,2*C3
 DB 0F1H,155*1/5,2*C3
 DB 0FEH,12*2/5,1+2*17,27
 DB 0D1H,230*1/5,1+2*27,C3
 DB 0CFH,315*1/5,2*C3

 DB 0FDH,54*3/5,1+2*18,25
 DB 010H,-16*1/5,1+2*25,24
 DB 0F1H,-35*1/5,1+2*25,27
 DB 0EFH,79*1/5,1+2*18,27

 DB 0F4H,-22*4/5,1+2*26,25

 DB 019H,62*7/5,1+2*24,P1
 DB 0FEH,71*2/5,1+2*P1,23
 DB 01CH,61*4/5,1+2*25,23

 DB 0FEH,73*2/5,1+2*26,25
 DB 0DEH,116*2/5,1+2*27,25

 DB 0DEH,140*2/5,2*C3
 DB 0FBH,74*5/5,2*C3
enddata:
