#!/usr/bin/env python3
import sys, struct, zlib
import base64
import re, os
import ctypes, ctypes.util
from ctypes import *
import pygame
from pygame.locals import *

DEFAULT_WINDOW_SIZE = (640, 480)
HEARTBEAT = NUMEVENTS - 1  # triggers every second

################################################################################

"_GLPROTO_STREAMS_BEGIN"
# automatically generated on 2025-06-25 21:11
# source files: gl31.h, glcorearb.h
_GLPROTO_CONST_COUNT = 1972
_GLPROTO_NAMES = """eNqVfel22zjS9q3oElpLZzI/KYmSOaFEDSnZcf7oqG050deO5c+yPd1z9W9tAAobnTndsYCnitiIpapQAGd105X7TbG92q+vB4ui7srBulnjn33Ztk072JTt4t+7sr3dd9V6WZf7WbPell+3+wp+6sGmgd9usC3bVbUutuW+K4F7PUO+1apYzzHdb2XbDKZNPd9Pqy0CJo1Z00LubbOoIGGgWcKiLpb7RdPeFO0c
U4ISVlPhgUJ0+NC22d5uyg7it5ur/U01h0pI+nW1BsKq2OzbsqBcoUIbXSSso6vasm6mRR1UrdtNl22z2+wXZbHdQUGnRVfNKLHudj2DMu66K5NmR/i23ZWD67KFVPbFdttW033RtsUtPNq2VdkSk9C7q2IuiGsOrmhVV9vbfLvMy+luSfC8LW72ZV2uSngJunqCJXJftMWSSCp/bsGrslpebU0TVtui5tqaBt3XTbOhRr1pqy2Xa9Vcl/tt
gyxRc103wkSlpJJ4ZaQ0O2ikzaAta6g3JKXS86rcNtNdB9WZzcquS1SdktGJL8tmVW6x10bVbNrqG6QN73taFi106v1Xr5qcPdazWl9DI8yxW7fFesm1ieoJaWyvIDPpG1CSAgdKN9itK+jCK6/5dVtEhbbNoMphkpOW8qtdrbttAYNtrlNRFUylsyjWXimSafx7V8w7V550kt4bMhMG1dJ2v/m8xRemX0zuJdyalxC0/HS3WEjjJUZkXTdb
bnbOZ71tm1q/dCwhsi7K7ewqGofVzK8SD9odZJsoum2O1JM05cBT/ypmMP3dUgu2BXaK2a61ndp0iUTqML2t8R3U0IbJUaIStyVJ5zLbTQOk28JzVQ3T4UInbvuqSpsy5Nk0Vfc4bb+HqpRgLptdwTjYNPXtslnvm8WiK7c61W7VNJBPuhZFvbkqwhLbcvQ+mu1kxfwa+7ruajyNl183MN1V3Jek+8iqYCYd13VU0RNNHXbS7gp6sMzj1EtL
6Ns7KDM0ieqo11V5s2nabV9tE7nNqq7ze8yihTrDMPfX4G4FY2U/m+G4n8nDKvmYKFgfv6bVRQsTZCb9FFGwPn5Ng6EdVN11yYiECykO4mjytyM3mvqxK+zWuLBfQftV38q57grVqoACxT0h/7Zt6Xj55vegn8wUyJsGQULpKhy73C9XJfRUV6dkb5tBdwZpTIqfySQxDGbNFTwlGW2qr2VtZ96+6uL4455ddF/Csl0VWI5yDk2H76vZrecQ
b8vZ1nt/EUHFR1nOUcg6ybJOQtbPWVahwJIII9HIxXOscNWCABIPQKTVRZIUV1SAWdXOdtDHgxHh4CS6RRGEZDpDSowcB83LDQrEbvWc366LFRSx2zZtsSy1SFR0+y9lu8auketXG2iQCues0krxZmndbXihVv1Esk1QZnVF0qcqxLqEDjqAVagbgPJQ1BCknyUI79CVQXTfCsA/RX0Dgsugg6rSconC/B7Ujx2IVBbDEK0gAZWxOQqTAdVh
GApTdphNZd9h00ARUahelYnhwlNxXS5g5EADdqVXb7Moq3fED7QoiA+mxewLP0shBomBgAGRFLrnGQYoIj3ty/VuZSO46JQ21sDUQksQlAJTB7m7XdTNjURxQHC82W1h4d6vylXT3trHdYVdUkYgBKUS5eBi3ZGwsyjLOVXB6wc3A+j9rD+CavmtVEGWts0SG+EKWAKCgwP0pQS7prIcRSxKxNHSjpdphCsgkWmGaiSfVTMvbUQKAYO6plXa
hZjPrd8yhrkAHAYBYitB0sJWMO1KfFbD7C6vmZHFbj2zvYyeNBHNazCPm0h7St3Si6q2kU0BC6HkksExqAVPG3YFNzLPgGZarH2N0J47IScDEw1RQR3+F8yfJDUlyO7hVQFy6NfUc44yB5UNZhaWuWFoSwiGNocGdbOEqbLZ8CthqdxgrD5x7x+wgYHDRhibNl9tmJpdpHrV6IyoV9jsIGOTDi7gje6y+yvo1EEPYmy33mBjdDewhk9vt6R2
ElJ3U160DNA2NzCdrJfQ98xDX0BeB7jzAFr8LQTDfblGZW4Q5hPkEuYR5BClH6S+Kr5CAwF5XrE+2hFk1hieIehFA9rfU5Aj31uQamXtebXqcK0TgafaotI75wAsP+Wag1McDBTiiZ+CssBi0M7kFdnCuMjDuQ2O5qBZNrj4zkDW2AarhOHiGcnE2Bxjo2iTatcgw+GUWjh82rQocvHSZMAtys8wT+BEMgMhbLAACQU7IgjK+IMvEF5wB42P
tcVYd4Xj0GIc5Q4mEEZgSSi20lkHV0W92DOygPabI/unCf9lZdc9CbgfJdEGB8QAli38B1MErEEdDo3NLQGw2KCpbA4CAAy6r1A/+EfGO5QJWhQWqusBcwHmJeAeBoJLCPMCHTScMhJzhZNveKzy6zZv2r7xChbKr2YCBq0DBAZoJuhD1I9QFcVeJH2JtHwY/NSdjIY7aJdT/FcM6h3aUKHru5AIJLSm0XwALV3Xgy9liUazTY2LRLWeYeng
zzXMXA1OSbh6lxgH9QHWZahHucZQZ/QZK4aobriGl4GdA7OB1yJREH82qB/41BANmCUJn1dA00dXaOGtahTwLFStQ+imhSc7P4rtuwHRMDQs7NY4/AKQmy4AqSXb8X453k9HA2/a+c2PDv1owDz2oxM/+rsf/eRH/2FEYWibTTlPaVu8SCjxkK3VSU6y4sVia0Cw0VD4DQjKGDVAuQANVgPgxNlTiCiLk9TnR/fYnekRmFZBBpxtOSaD06He
9LMfw3+jYPrZT/i/EP6d/ht6E8r+M//ng8Pf5P9R2ANoGIUYFAvqSy3w2Y1BHdwLESo5wT+/4x+KDn+jvyP6+4kGNIUL5tsXQ4oJ716IQ/n5ZHs4Thu02BmApw4PovnDQ0QfoUWybb7e7tUi5AMjtypNYfJClW8YQwmu8Vyt4WQPkTWcbSOyXGlBQpgE8thM4uOweGOXMU+43shvafUez32xwGy4oD17sNrV26orVhtYoPhHGge04hlqOcUy
JuBukGAhDw+2TqJdyGZk6ACVRcnKlzQqrIypYk7pdFSJL1v8V1CVrcWfTTkiHKl9gDmBoGOCXkbyBUuSIWDepuhQC1gM9tsrmLqvcHeOWnNWQ12wUViycHG043hTdd3M1Wz+1YtPCxjrNYz52mchZFmuUWUszcpAgmywhsKQCJDRJETGI0/zLrYg6V3RxgPPnLBEN1TbLJcktMedxByXHZEZuhqgGQ43XjMMavhmOLjmfRxGIol45uWigEHh
YajfL2ARnEuTmoddetDB/gVNaEQIeN8qtt6t9kqo0BtBnbH9VKvVbltMa2vzMAQjezD3pq1WlVjH2OoGAu5etg5gtdignA7lxHeFWyZkp/OjywH9TyLyElUymGRpCsbJFgPDTwtY7UcLiuJfCn+u4N+uQjL9weB4RH8wuPxMfyhIHEtmWRLPkphoH3hW76FXr7d+jDpXDUNvwNu1zW672cFbEgNzs+uEsGaLyXIJVVlBjbBpRIVihllR12Q+
wXWUVtwA33Ulthi8XqF0za5F2XFT+cANDH5Q0LpbeN0Br8iFWOiqLlufuL2q2jlZAG/DHHDXpFCFEkJD6jVDOLbEmUAB0O/aEh5FAaC8Kq4rn2w7aJKKfaLgbXIPLlvSjtazUsNcGPJ0MD0V5ZQSFYHlDuTNW4szWK3XzYzfoYZ36y/r5mYdoPR3v2621UKaAjfCoGLLW1zbYAZf4axbgODWlluQ2K5pULBCL/SuxNeHOhWIIDgWhGAZNtWm
JHOAmb+1Ftu5vSNflbXwFC3cnbFkFbfYX9rmuvmCCzsvn46ZVJqY7t6IAOtmH9ed9Xi3/dJSr0bbIU9Mmmw2Q+003HnkUGOWhTjPYmlTKmZPNoZ007Rf9mznptKpTrMq2i9+F97gPiEx+11x44EdyrnovhG1CtMlN2eTGORwfMaUvW44oW5g7ABsBlATZECA0QXN1cYEu5wFuFrGAopbvgKCWrYCilquwgLrZSqkcX9JkRCnRTpZ6hSFSp0i
iNSXoIiJNUGxRlSk4YthWw2GRKLlN2zeG42xoD/Oq5VbMGWX33TIQLBxFiWv09Zk5EDlnuYKsQ47wBlbLaQX/Q9hLjZ0GW8/g+yhZOYUy50KG2uUhqiNrNmKpP7AZsUg8S1h/kjyxgRue5IYoWHXu6LeB4LkoNiBnBqCgSzYgfBNbmEcIhMsB+fljOzvbIEQrcIYgTz/Eg9U2/kGt95HBrBeV86mxDOQS0kUGliHmxun/BW0dvlRw+TtTdcN
1kgjKGeVwQY2zZcDac8SFwoebAT47mcg93edUHhNkTejIXonXYVKV7EuQaix7wwNeGrLIsvjb0/0pyTv6qOkmM1QlKQ4hWn0S2BmjciBhhrRRUlCw5YoWYYVV1BaRpMtucBdHpmuB7PiunSzt2l/5NtP9qDhjjxoFEPDGMIHQdoNHwygYQzhg5+j5z5HjwXIkP7/zQedwYUbgtHRZyeQCPbPTxH0aRJBk/jB8SiCRvGDwzj5OKluvJ3t51+3
Q1LIc4QiRRlnKb9HlHa5nQ1JawnAEeouCptuIIkdKFqrCGUzu+9aamRBH7WuAGzVMlRjxplX11XXtCGcZkaPrjkveP2ZxBySROeNDjYbeFYBtr+DPklwih3XpAQ7r7BuiTDapqRjttJo+jNyNBtQI6k6UXypOdt1WlnTpzDjiWqGRcC0sZVqEKt3ZAti9bgTO63swiQ2wu1ue4IGOZdQNstiLD4o24OmjKKe1Zk16LsVV+trKzKmXCONb17G
IU0/HrrSqtxLyTt0KtaPB75YHqmuNhtswWqNurFL2FFEbVYkcaQQ6WRDK53VLHCO9TcQnTqAxndcJgImp83BnI4JG30zR2CPwcB+PSILdltex8bqT/vfk2CKWyzeKdJQ7N4eSVm+Y8LITcdIW1Wog5P9hHZPPBPK1M15AaH4Bco4S/ldednPG9CJxN9STg9YWhq9KSrjjT+tYXBcNeRZt+aOhDDuW5TttfhX4S5nW33jrswMRV0VWKrIi8QQ
Ik8PmVJ+M4GhCYxMYGwCExP43QSsIf8fJvDZBP5pE3RJ27SHNvGhTX1okx/a9N1OwdDmMLRZDG0eI5vHyJXf5jGyeYxsHiObx8jmMbJ5jGweI5vH2OYxHhrDhZFnaTuVZrcN2l2y3hmOJemngSOY37cxHpL05XW2sO9FohsmKb4S4pBPghwpyCV5vk9RUo8myY/5o4lTbePMtuQVHe2jOIq/8+FwrrTE/K0Oz1objPYJCGjaZaJu0JGh6DwD
fLGG1R/quLn1eANSlATuMdMWDG00c8g2826KCWyimkYEA8Bg7Njm+zWmrctlkaPZ5257nrvtee5bz3Pfghdii88ri7B7r6NrQbDj7Rq9CWUls2AKx1kaTaZligBTtBBTB4jKNQo38yTN2wTzCCzEpEikuM12Lbn8egxOOnKuecKQp3hpE7lsrVsayFApdUq0VL2N6agkYClme4yDdNBu0EMKjK4isPHqt/d3s1Klrxt4cXq2MVsmaJmnYgUZ
ZPI1sPUNMib8ANHec4TkXOtCIvnX4YTHOxtT/KG+iAG7Ze1F9pbOu84L3q2W5zBgWb3I3tLJzOXc3zrtC/ebjgx1ZKQjYx2Z6MjvOvJJR/6hI5915J9epn4RvDIMvUIMvVIMvWLAahv4NPAQ9zam445btOLAGYL00k0Ez7NA9wvtPnZ+6UD4J1doloCs9RtVVzNeWYthBhgEuLmnI/viGvoN2fkixaZL9nlUOUEe+gbjjlcFtRaybB7Y6MPV
L8OkzXfsnRMqE1odkLmTFbfgBCODOmIn2RRnRjdOspDtslnXtwM+10hBAtmQZLZa6fCHibHTjorZWW9brco9qMcbnMVEmcPOZcJseuQwubqBIoLnl4SHwsLD55qQx/juE5OJEJeJEBsb5cjdwjgAECIuGB6mEOcVEHNbGvV6EDJkOvrsTJbaok8rYsIrPwPywKJJBe25snvoTTCpN2h2elM0Y+AgkYbXOiPNiFG+WtspnG2gyoiRJIjvB824
8FJtH7aqOWipDuWxINZtwUSNZXMp2xRsw/KSRB1OHK7QmZK7oZVAxdkY9LTJaGSFCE1UQocH06Z6BBqNWVrQk3R59NqyJ2hW30/QrMKdoKVLHNCcldVLLihpvGnIbFGxc4xRHRRjUE7xD3POyqLs+EXG1GEs2t37FJNLmrqCiVBtTUSn4efAzqYGk85pj5Rqkc+AokkFaNWRozZ5eARZRJ2I0HmxLfxCMp4vql/5rpdq3Zf69C3PvNXLGSwx
vbyB4crNaWo/SH7IpU3C0bZ8M0XdlcYnzl1ujIaWsXnVzYp2DtOf+JOFJfDraTKS9CURiSVHYtDd+0fNNQiqpKmlYTI6e+mklnRvVKUYpNTsY4VJQmqzkQuOXZC8x5ksgbEJTAbTpqnpDzOY0NiGJpIQ9PqRC45dcGIn3+HcBkcuOHZBFMgUt91zsw8lkJbekR83bPMSnYFwNt7uWH2pahuFPvTFhO3Bd4lX60WD/kF2WiEXrXIuXaQbhEMt
GFzsdkePGudvXmX9acqefO8iRCcR9eeyrcT6RiaWnE3cyq7GEl9hK2FKLECaze3CbPNnybILqbeoF2javUXvqSLGv8Y4HWL5Kg8YCZu8OYrV3AJ85QMiwckFhDZlix5ChXCgyXLFTkWeAJ4ikg0y9dBq7nkBe/voys/B8wL2EOXZ4OsqsthILZS079yExX029B4W2HkPJ/lGIZ9zLc4Q7BOeqJGaPeyT/mZrIPRofUPLOGG+6VR4fcP9cptg
wCG9rljf7gNpUFx/peOTdOlD4iIM6uhiv8Q/0+Fvi9BPfbFHCv5DUz2sI//cl7/7TL/v/0n/IYNyF7AeM7hm0Z/P7M7AsjUBxm1dWU26wHKqHklsSpkVQc0EqfOdog01smeY2t0iT7dtqZecfH5dTy4s1/bQ2Rne7lUZt5B56hnFh0ofaDQDs5ngFu1cnUjvq8viWpzOtArc0wJGIdePGyxiytazpwV8X+9uQ9rtrGlaUC7aalmtB3VzA3x0
kHgH+qwEPYOTPrgpryY6GUq4OsuIIpDnQiQFSWGedd9TyRV3lGTEkU7P+uObMUtH5fV2gkhhkWP5giEIOIU343jN0livC7mwoLicY7FKKu2Of8BkrUV0SvijFGkDXTNZ12QNVmsDay/wDMeq6jq6SOJDTuX1luNQp2kzLPqQre/G7vwfWQxFMcEVyjjNOeS3CBlGyChCxhEyiZDfI+RThPwjQj5HyD/jEiYKHZd6GBd7GJd7GBd8GJd8GBd9
GJd9GBd+GJd+FJd+lGjzuPSjuPSjuPSjuPSjuPSjuPSjuPSjuPTjuPTjoUwXqvMnzk/4s5Wbc/wJiJ3RPEgc0DwsPP3rHT8d+tGJH/0cMH/yU7big4cqZ2B/grauwB6sHIE9XFnK/Wk3d1ZFTzHqIBeObTNV42m6T7+nzo2Q2YxtJLGctteeAvr0lDzBGyl0wGNqfgs58TE1vwUfB5nKT8FHQabyU/Axkan8FJ+Zt6KjwMZkyS1rYtSe9twK
SGAqXDiuZavDjpDw8sgsBinPXtXYfCaAHZa6fiZSjxILpr1zRq+ZdB8Vad/j0T7aruYC95LlHiHeKpjVu3npX2wjqj1InHz1lVLyQtcAcg/YzjwvFskxSWuX7KSX4jckZSBgdUZp/z5g/NGCBxJWhCROK75gXkORKSRExhHChhVl/dDRkR8d+1GyhPjsbOnwU5T6BowxKA3hFVCVK4mPMvg4g1ORMylx2TPZS3lzj/ZQpVqh8dFTb3PmNrat
ZagfGbTDPQbvhKjTrBu8Bk9YVApi6+l20xaIdG1qBDnTEs3DitWPJ06roMQ7J/Pz2hqwPIykZlBDxMEVKNVuJZErWAcliBxoXhI6BolqTE6sAOhtd+OgGVPCo24JMykMmG3T+sZQjUVWV0MMtA8UHJTqQVeXuGXNqSc4fzFHL9U5xamgI6wbTZOYI09xf3iJ1jTF5YMpZj/VCPfL5a7a8AsRwEGuWWr0eHiVJPmWBAZotXf90R5QuI2dPCoW
vMRY3+5RwTfFrstYHLIUHn89ifYwGOMVKF0gFEHbmA0E3ggaeO52muBHvXNo1tZ0U337hv6XEbKMkGmEFHE66KuXnWzUJBLzKDNUPgHFZJyJ5BZpPYVlYLoAF6aMGmee8Cwk9i8844t2bb4XMMbpTsAYjo5VymA3tQ3jJP8wxE5sjoVNMC4sdkYnKzN607TzYDFI+F7Q1StmViNtA4Yal0Dtjvdz9FLZgyXYe9eHmtKb8BkOugnT31m1EyyS
EoZkj25xWtc8UjwHeOT0qdQeFp8W3r/jFd3OSx8UhO7aTNeeSD21J3q69l6qmUz7a59g8Wm/VvuPCpKbGD1pij1sOr6E2AlFHJUrEaCjrsnoiSY3nwLzgKV4S0ooZRFxWa6N65fEuk0x420EAaRYfKeGRdk0S49WXcPX1i/wehwYOCivzec6ihcL8ADxK2U9sjBJLnPkxpVZCn9hBYySym0CZ05DpvmC9kzlx7XsLUlGqk2VJubKunDHnuDZ
5lTOLbmmFJbwhIQ67JXchskwIJ0oooOwfJxisGoKs5D63KHgUH41IbkQwrmeh4DbywkpLGHHqDEgbXb2knMYtylHLWyfqkx8rkARUs8lkg1x3uGMcTHlhTDfeBDBzo8Tt0wiMt1rTHffR6SuhH4yL8h/M5njollmk/Xa4oM2ZPkmagoHey3hYF0sh+p2cGiqGRw1bAVHSTeCo4dtoNL0msDhQaciSUdUPJGM9ave3Hr7BiHg/O+QIJ+0UKwa
8baZs74vernFg2ZWHuKpJ+A2vjw8LUGxySvDnLg2+9W0ZeRDPMEHmJj3EmiAiRsrbbogRD4qepfNgmoY+gTVyj7BvalU8s6TlK6PZC8dFx6r8CQ8iGpM55/3HU2I7dKFpipY2PDwk0VVcKrDhY3EjhGReTlhcGbDcY/Aqu9zaGlX/jOawj7zWINfNN7pyFhHJhKBUtqAeoBjYy9mHvk0sT5UEvQIYxX0CBMVDG/w/BwDJuEIHSfRKEmuWYCk
ElV1jeHEXaOxVVQ1QwyPU1iadZLCrJWbK2SCJkMVHwdxelT6PZXZhccqPInPCaTdagJy+kBTYJn+JdjYnkMrq3owa4lVPHzFIp3rRncnE0VX7ZWZvYYmMDKBsUPE8sxXDpBhmmc3nh9MAsbsbB7S0aBElkfvN6VAZcp25bSRkY6MfYqzluty26gpu0o4ymsUQ2E9NK9Xlwwh9dZsxRLoKImOM7wJK7uqfAJPbQsEzZHOKEvr657JlvqQQ7ms
yeE12ZP0l1hzJ45c9Lmr+KiruUroemlPv5q7mlhoBBF6jt87W+C1zeRajShd1uZj9FkwE6GEQNttvphjzAakK1wLTpyACkSTCvVIJrhDuPz1tpjwrwa92ba3tcsJ1kBUjHEttNi8wA+hpXIylDiriEKA2IoMJjfkOrmCW62qa7vlpxA0G3gIWdB9TmmoPMWkQvaL/W7jwnO8+81wi0cPXaxGAkrzVb5Scw1iyxVeMYC3PQdkMl3U6NcVRG/9
6Gjux8cULxZ4/5oQJTJ2nGTW9XgimLl328Vn+eUFyytms/BqVbqXar5iw83h0KYNMXqXvG6EzHQZxDz5SsPW0q8lpHX/3uFpOvNdF/cdKvpUCtYJpWTSEqjD0vXDWxfftrs13j5IaaFnv/Fo4i+iYOt0ZQzyuKKTpMYcSy9jNtutzJev8LsxFRu+YoTNxVu6Os81i7EfecCsKReLANG2sGjUyG181/arfAR0GkHzRbXeqZeqv/4QgXhYMcSc
/x+35prmWOsI4r4WoJ7hLXvvmuUoXY/H2iyl11xbZxJTTn1ZWHDfkjiQZ+nTW33rVY6Fb21SFkXfapo4KJmh62OSMYs7NhbTnEE9psVaJ9NCE6u+BidArUKWprLak6EF58eSht3kpkOCJXU/TY4tvqomwRkeUkiwBLfSpDk8RT3B0tuqaRZ3uC39cHTUzL+f197XYMxyph7s/MSXSHr7OopH3XapWfrOR/nNNEia//sfmVcd23EjY0OGoOwy
cv+O/vanPomgZbfoPIImpuHcSYaYJXF4IZV8mhykYURGe2sBvbhg16/T/kChMJ8h5XxW4gvR27xm08vwCzkoCZmNfmG17TWZSYr4tXkYOu2hoyT6AeC+Np611S7XfOtyA03Pm6MYlaNT8plevGaag9hJOYimRPvpXusPzTUs8KINGyhqNBre7i0ghcBPRlZ8FbXkjd8Dqzq0mQ2otHh7gzsjLh8P9O7Ips9i8Ba1QuI71dI7HMGJ4w/8ggKy
2qwNqGbcme8P0z6znAnPXKaYo/ofBYjI7F+Qo8onf/K59ubZl2NPfvF9cqLNuRt8g0u6HcG/xNvc751G7TXB6MYUYuzlFKJ4GZxZJfgAKLvLSMTbAPAYZML1Px4ik6x3b4Rx9bmu2i0ex7eXq+2/JrDbBPaNhyxf0eZdlaPw8PsNipQ8sB8cxZLh0XvaK7OY2mwpt0T52aSLO1sRzd48Z2duVPJEySFTA103K55nzCp3ESpBwHid0VcX8BvL
MvfIh6pw1go8pRvvAAuaydzs6vm7fsyRScsXMXJpUrXMaQtvzmf/NOT5iB7IBqnLwBMyWs+hY6KnpeNQ5GG/5ZzMFF1OHl4NrndYh8N9WcxSfsExpV3muZcp9unnfRl6HSdRAjegDl1BX2p2yyu5pSfz+K9w8g4KolGR1TFCx8DX5AAPve5NXZX8BRP7OWtU3Go28kD2TUv3hsqeUtX9i7wf2Gxiw/ygfKF2br9Lm8NJgecs552NkcIokAkj
Xq0NyiHi3W0t686mAKLuxsAmvKl3nf2d0wXx1mlzU9/aAH+YmT78xT/00TJqilvzS2ljEmv54Y99w9IFiPzandp5g7dVuaAlTHft2oXo6+9FO6fHXYiK0yy2DNsQv4SFyO4qKHo911WcBegrYhIy337HE5K8fUS2FXQ8kA+WF66YHDWlu66uK1coptnoplrbMBZ+xXcAXnX1/mpXml8DycdXsWR+1DDwZSo2ZGC61AptN7dB1L5Z8irlTurF
2S3DNo5ikxZoxLRrdwq11SqtPGVUKrM8p6msmWdoOFmlSe4WjzTdnvv3P6rwPzDbmzx+RVH0b7r4lSdSnjm//Fzs6PMrj4b+/L/yTHilh3cJV/abFl7lPuJTlelhtYXv4bGF7f/cBptCeniSFfywZr9Spd669Fait/RM7BtEyR5u6myv3UkmYG7qUQqzz9iTubUf2VrZkwBkwZW5LKZaErmPmpuTy9a8G/VlYj6s5b5LZKrjG4OsVzjpiO4y
Gn5EinsNCfLXJxKmrkHVUQnI0mPvtrF+1oGvXYDrEetIbkQ6zI04h1lZ00FR/kZozJXDpyfLY1kS5bK0RPksLS6nyzV7MYLpnM5tKLx9iuK4KcGM5i11lpBxfNdpkH1F3TEqmpe+jMq7dcq/bcq7ZapvmARrXrRaJasRAX2Ly8fLyC8tGP1LQ/8i0GskRfmSdEV9o2sEcrPakwL2iAC3YuKTb2InSVHESpIiidadIqlLqyJaxpAp07Nldx/O
0aj6iI6G1Wd0EmqpXNHhWTgF0gbEAJJorrhKb/WvEy/wKEg5H5RQhJm6bjy4Q0KdFLKnnNUJMMrV53RKs2UIn/RY9LmwnZyxYFNVhtj7DJk9gOOmaDdehCfubkU1Wbl9XNqqdQ7C7nyK7Y/+R8h6qanHmbqEzi6d5SOGDxKRvvUhB4vutMStuGmCJ1yD/SrfR0n2pxMcaO7j7X6dMzonnW2XX2RT5zdoTjNT8ge7UQGbGFmyt/njOzY9B78c
WJEmipeT77+6rpThuLUccmI1yWV4bB3dB73zh/F48u27pojv4LZf6JPTb+4KdNaLA7K7BT1Jdheh9z992//0t/6nv/U/fdP/dJqcrk+6nOn8b/jT8dXG3GLEn9WmOZX2RW0J8LJZ+brvt7JtTJg/3hTewNyW8518fgATuaE5AbUG+R4weWCRI0in7ncjP3a8bIeuTgDJLSalMfo6RQ3lF9j3/hKnBC3m8z4NGdK8y0mVm3ZAUX7aAcV536j1
TkYQzPrm/rJZYV5YDN+KFYg/uGmseOHo3c+rWrxseqh8014/T6C82F5h3XBupGC9xK/OqybPdOuYWvxKacfXEEKR1Gfc2PRFRnFzXHtHe2tKgIg+LZIhqrrpDz+VxQwtyhG0DDD+kNQ0hRURyClM6fvSxWf1rRUjmvPXa8MvsRjq3BrZ+OLWD7j4GECaSWzR2KtzLL2PmzPO+VKgBrGr8HaSj3k+Tfp5+KKRXhbx1+7lwatKE8WR0/JO99qb
7fBUSr/KNy+7WR/fclPwZ5zn5dwd2GQuWCTVwuxiVhLttrSdmaAsSrTFahqepkYB2jzkzunSAT71gVj/HGuOqg0c9hLuBE1d66fTtTviItLax4JNH++hDI1OunBdgKtTiWYSzCYWGG2cFTmY+lKTpHEezNJgkoMVdF1s+rlwbxSZ2JdS1oSP2d0lPd5dG/tuU7V7oNGP0ExMfT+cd0xDtAPZrCMXkg6dLeTMIu+tMAV9QT2CfZE463W2VaVs
pvFd1NzQSVctBgevklS+Ft5pHTkOp1EkWDawyGy3pdeNZg1tGDurgVqS4xRCdN1oMTsiDxWV+xaJvx+yDb+OzEddP+QdfR3+D7z/S7qTX+ad/A/pTvLpjrzGzLfX5Bf5Pv8i3/BTnpF7tfregAXVHKdh9cUBNw6cidGOBQ8KueyV9DG3IvU5EAbjr/eLWv7Y/JWdliD1X9oL8nPpTa/3ydSiEQzC1NoRsNjbvGWVMzeFJij2aIQAzMC3TBsP
lzTZLTEhhbYB/Hyq9axo11bptmTRkzoPDC6ASDJ7BPWA1/dFKKbrEaxJsZeJhwZZl/sZ7WUoKU6Zkb31tn/Wdoaw/mtX2YkIl6HmWvYAbeyDR6f4uUkS3PlEdviIupOPuOTePuZD9fErnbCj3Wcya1i98zZH+EoCYvqJNIFd9LHlypVHKLoZf6FRgyiKxqgskxqifTF28pB1NkdNPLzDHEixskpdmry9qmZf1qgce8Upuv2Xsl3Tjr3C8VXy
ERDZ3zZUFGmnRdtW5gtNJOMaSWiLdzvTdf5ms+Tu9fR+3Lycv78cfkqs+3G4P7742Pb41+vby3FQPD8//r0A/PjH28PD8aV4fT3c/fh5fHqdrYpCvm9JGKcymB6/n55m56f70+vp/HR4bI9PeRh9bZCwOb48rM5Pp9fzC/poWezfb8eXv+Xjm4hRXAUrSOSv4z0j25fD0+Xh/PJzcTze/3G4+3MwPT3dQ+FeTn/U57sDZkzQlGqigtPD5aii
7eHpu45fAvrFMUDLfJ8fXg9e+iFoS8k005QUr34evtvGDoELIau3x9eTZpE3tTk9Hx9PT4xxe6qEu8PP50c/zMnhezo9fW8Pr0fKC98BwDoDCe/gheg4P59u5uvjy+vxr+Ll5fC3iquW1gAk9AjlnR5eXk5IVhEsDUZn58ezUMr//yZtq2Pd8fnwAnVIoycfluji7enOhfwUNKLYJbg54Ht7Pb6cqICnV+89QnwNUf/l8nC5v4d24w6DT6ox
tDr+PL/8bUHsMBLcwFuZnX/+PL3iOEuC8LB9soNRc8D+yLG3Pyip2eHxEfkPT/f16fKKOtSP492fqojd6+H17cJwWHxDe4Sew69i9ng8yF9VYBW3GTvo4eTF3nXs5MXeTFRlNj8+v/5QwXusg409cJgKHhZIgV6pwlqa8kX4exo/ZXBb+u71CF3mkSMwamiA2RiUxQAneIc8M82PDwcY4ILdHE6v3d/QSyEKDf/0+nKG1LBNFjDiDvQaMbY6
XP50IaiGe9Pd8Tv2kAux/nw+PR6DbsCgTNderHq6e3y7PxKI3fZo5x4q93Ceo4yylHGKYhpi2Ecc9RG9ZJPlSxYtWapcgXJl6SkGzpLJhCxhlCOkksoVS9NGPTRK8+lyfHk/4JreHi6vOJHIVPZAnSFLPhH5+e9gHAFCaWsg7iUBNvIxr14xnOEeM5wa3ABvDq8/pMRBSYJCxPnHWce5Ri/Xh0YeFKcfvbEIpXzejy+L0+Mj1qV6urwenu6O
NOtpgol3MDf8eUyyOpJBIIPV+f7tkVbDJLg9/PGIS9Ts5QgroFmnOaYmkItlUfOf4QtENgFFrvRiRnYxT+JTJxvTwozBrAwjUZm+VMTPyMPeDQjL2tFVAWfaxcv556w+vuNKy6iVdiQayjuGoEQegN4eHxeHu+NgDm3yfQWjEddrWINJQvJAmdU1VuEofAXo8ejanmNB2zPotT1DNCzgxYNoJwi+f/eIErEvKGM7VL0xAaUhvZh7YwybN8Yx
/40xZt+YRPmNScS8CIniksdB2/oSjVufCV7rk0QwPb893V/uKVGIkrBHIVosKcSCuwvS4/fv5hGHvSvAiO8Rcu8958ceIKy0ovnpguPL/PJiT41gU48oJ4MFLFrUjiGWKgICYd4TlPjz4fXuB64eb6/HML58Ob89d6f/RgQozenleAe99eXwH9P+Npig2ukphaFqZSJEF5XBBTl1GQYXEaixrRUaRLl3pVldzwOwfDySrORFsEjcbh7s1cyB
um4RGtUuyZHMLKJHacHc8WMLXduWTCplcYlTf/Rq6iFBCWL1Lon6FY/IMBEdcQbJ0/wErv80umi5rFkFPrx8P77iQizqTUSg1dMQ778fF4+H71ZKLp9ovPFPYrhFhJNAPoMeaxEiQ83D1UhjHNO9j+0hKZCKfR/YQgRRkzQgbAcxAVfkhHJevh8eQQk+0tR0DWGYWhegpfCcuzg9nS4/BovHN/N3dXh+PnqGEAUr2Uto5++z8/nl3rY72j7I
OiQCBukojJsVS43yJHrR8OIIM48xFCjcialplD+46Cjt8XAfZ+pZTbT6S0uXsd9cQB/sI/rVM4aUGAJxMAZHKXCcAkm8iOH68LdfeMFJfH4/Hf9DJtkXkDoogeXxyTQzBD1BAuJGZsBgIDAgFIoCgBk5AIK+EACAlQAgbNd1DMeLOqDeig7xI5piVqfnn4dnFxWdIIBNlQ36ykbM4vX883Q3A7kAuoQ1OygyjV8bB1EcFr1XqBn28xS+ezph
sT8g6zwEioDp45mtLmlKIokk80UYyaJ0vGdp4yKQtnsCMj2fH48HY418V9Bpr2McDsbTp0kSToFvyEx9yFDOJ3wBitcobgDIunx1PPAMyFDKlOCTsqjVyZIUa4MhYk4JAqIWz+vzd4LOb26BeHeINB9HKFi+vJxfMLA4vVxe3fx9zzM4Eh7Ph1edFAGSEoU5JKZk4tSAfrFJ83zwjpKTZA+F5k+gLl8Ozz9Od5f2eDm+ilUQYGrDK3hvj8cg
yq1XwQv/fnz5NJEa2biO6eoL5LNjTwLES1L1LkHsEy+wkj7QQsQTz0nxOdpJFUKhhLFNtvnj/4E0xfL78R5qfn57uTte3kx6pleWT+8P7wFw8gCYn+5D4CEE/Eds7zQA6qaPzmjznqf5CVm4yuFvGcJDGlbcF2pf5lMyQTRdJGlZinq1mqxmj4Ttx6C/MghCxhRZ1jgcX49hE/YwvH3Ecf8B/SGiizIfoCofvd6mqhIkwFGhw2yYmpa469eH
P46PLrp5fbEICghK67IIyIAqPj9cftBC7qD6+PSd7FESXx2hOHdmY8QDVUKqeRLgSYHd8+EOqicAPCDLfvX0cLbVUzKNkLEPsXSTIOKzWSI3Z5Z8iSmsUmceI6J+iF4Nzf269PLCpmQGTVC82vLI0dOsQDLN6qEl3Wt6ejqAauEATFHWP4vg+wBZ8qQfNEJhzG8oHruZVe3CFuB6fcuQco8aQSmAbQ/yYa9UsMB99xGOUNvyvMNDwkxwMSEN
v2UfeFNPyJtSSCK3KJ9UDnHaHOyZMkRYD+e8CH5L4w9JVHhld8n2DGOcPd6dLvAmWXt0hI7ejIu7VPTG9ebweHx9ldlDEX39zMwR9GqpgU3cTI4yL1LQivK2c0XSve6ZqENz4fTKnVm0M+t1YqlOrdLxAh2vzSLjOrnMA7jeoYRstMh0gWOSl1Oi4D78lsYfkqjHKz0pqouHe1XSon2kYV7DrCbvO6LByOH5MKbkcIK1wmb7i4Bok7sjbfc1
0W8Ecn3rzUvxXkcedMQMchXlNvBUT4m8BdxvEbtkqzRvmYJA7s5QEriW3GNCCPtLUEwIYS9DUmqrBPQWY/V9DLkW8GDbUjEacyfKSXic3UOESCn/hNXlDu3TnPpTWq198iJe33jyOsdT0DuevN7wFHaHJ/X2r6AuA3q11oTHm1El7oitDi9/Hl8GtOI/nx8PblOpeno/PJ7u7VYhyeIhaGR0h2sPGYeGcnnwUOScEiULSDpl24IeZGeK6iI2
QRMAqeB0DxXHGl58v4nqwgbdexcyhlcLnCDoFeSiNGOTdhqlHLR9NcJlxaousrELAeyJ1ZPaGbaYtwUMqGzp2ZB1HqsubEyuLp4xtLoYBzII8R5WxXsnlB4Zj6uLsXXaUFTTJE5JxKbq6qLN7aRysBwzqKGkN6f71x8Y+tNUBl9MvLXDNn08Q3v+frprngerw5/SH9fnJ1UEhwegtma4J3pI8XO5h4In1PuOk0t3BqT4y3pQxBwx9Wz+Qe+p
ZxklNsTGf4iqMgZRwwKd9q/Fy9vl9e2nxOrz4X781+iBknbA2AcqzP30+reCqMc8ny/HiNlS7lPggwI1g8HRpOEViIGxD6Rz9yj3KVDnohkM3ry8/jhLeHN+NiHckOFge8Z+fe/FzMPd3eHRkihiKJT/o3rQAsjxF49p8f562f54OR7uLwO2f5ntFi82/bs9fkfxZXUSu76I3AOyCKnN4CBu900zODqHPsLaR3oztms/W56DEnBEu+MZIWrH
M6LFpQ0p2fLmGPt4gjJHW7pRJqlNX2OpM+NQomSUEWFloG2WA9+Aqa2XA9+Uqe2YA9+oqS2aA9+8qW2bA9/QGXqKhV5ioe9g0piZtmTGZsxByrIZmzUHKUunwbxFMeG/lvBdS/itqXkxcP4N/Vc9u6jnBpylsC+wNo3KpnjCWkpQ7NUXCWBuizZPugzy9tSIpPZfY5Jq4kjWi3ZiP+QwjZHYk83gw3mOMspSxlkKbbNmaLxZmyF6O7Z5S/Hk
vpf43kd96CX2PVpNTv3U/offTh+Q+x6/9Bft8kHulzh9kaUjM7o3dBIEtfvxKzzF/Tv5uNDlxR+zmw3JgZb316iXPVrtTFvoA/P8Br209FznA6dBYLz3LPccgfyt85yA2paP8eXj388/SPNJo8akb9EIMNnxJJhOz/NSjncC/G2ACDAs4o9PVWoeHi7HV5+gqsmtbSJvfwTtRIhtqrdL7Jg42Jz+Oj7iSwUJy4Wh1XEJLh7PT99FHSNALVNB
/D0ATmFcGMg5b3N+/Pv7+Wl1vrdhrqgfo4McAD3TtjbtNWCMAqLkb15OsKCc3o/kRwltMT3/5UDQB14PL7xjPfD3CoxGqcprEOhI4g9UPT2/vYIMgNVnqhghhvcR8B4iDxEQsZwi4NMkAcXZk1EkgSU4I763U4zE2b4l831LZfyWzvktynp0HwERy0MERCynCIiKP0qVfpQo/ChZ9lFc9KjVRolWGyVbbZRqtVG61UZxq43vIyBieYiAiOUU
AVHxx6nSjxOFHyfLPo6LHrXaONFq42SrjVOtNk632jhutcl9BEQsDxEQsZwiICr+JFX6SaLwk2TZJ3HRo1abJFptkmy1SarVJulWm8StxmaURG6OECXjSPnU4sxZvY8nAMEfMvhf4/ssJfvMJPvMJPNMLpdcHuNsTcbZuoyz5Rpny5V7IsufLdckW65JtvaTRP2TXUK98vfzn7Aqi+EC7UOpY4SI6zUeonqRJ1uveCgM+MAX60+XgdLQMEgS
DKNPNvx4PFyOvulokBKfP5Ccf11o/jV5Ge/JQP807b5lxREmnh/ftQs0g28/E2Jc54viHOVTlqkt8uT+eLQ5Pkhsl0d75YPE7nl3d7pczi/mVw6nSKz86+7x7YKerATjpREBwUFmr8KPQlLHu/PT/QF7hT5l2sG7vsu5tXAPEPHP27KXCL8p2hhFKxiqMeHuvTvvnd/Xjzb1mxfseW+X1/PPLBkJp+9Ph8frP8nPXcW748/D8w8QyhF7Pt6d
Do8gQ8v2Bu0ezA7PqIkjXTSExHG8gKQQPHKkwvaEuWB0EEmFQ3rz7EIhLX3cLyI6bPvj+JQ9UZjjSZB6M05wIfHtj2ecMqyDx/R0wCG3pW1Qbf5yVksb4o0DY7+0HVIZDZW90AX1/KIMiC4YMATWtQhhq1poeoysjr7BMbA1+mbGwMLojrZwlSQy8iNBqQUfz71IyOTMk75l0jdKitUpfiOImj0AP6ro9q25mH1z+qRscEo2OPJsXUDClxGj
9oVEjidJr5PI5WSQcEKJPFAGCZ8UgTwzpX/8yFXTe4keELwjRRvPIyDF7L3U4DxxfJZYkOvT8T+DaI1Tt55kaPIqM140F0eREe+UeaXFO/Vd6e1OYdeauq+ie7p5oJQrbVyp4Z7+HSjevsYdqtpax3bKtdKqnTqt9GinQGvN2VeZPV05UJKVdqzUYk8fDhRhXwMOVV+t8zplV2m5Tr1Veq1TaLUm66uwnu4aKK1KW1VqqqefBoqpr5GGqqjW
QZ3yqbROp24qPdMpmFqz9FVKT5cMlEilPSq10dMXA0XR1xBD1VDrhNpFzEhCsYKY0gwTKmFSF4yUwEj7S6h9CX0voeglNLxItYt0uoQyl9DiEupbQm+LFLZIU0uoaAndLKGUJbSxyCnvot6g/1Zc4/+0zhEU1v4Qu4s9Se+C5IZ6QcC/tOBavJMyceuuEx0/Nb0qIohTbYRXOUIdE6KbnAIaZDw/vZ9QQVEU0iTECq1gc0Y3QeFd8TgPc7w0
foT0lxj29r5jMu+lxLivBMX0fIrauS/xKjQ50VKaHLe+5+D4Abm/ZHX/03X/0zlqvgfk+ox/CVhE8DOivEGi8KPvfvwhiAbkSxD1yaP7IBqQH4JoQL4EUZ88vg+iAfkhiAbkSxD1yZP1HyFwCoHokbc/IiBiiVJ5C5MJn7kPogH5IYgG5DC/SxANyFGJowKH5Q0GZWokJoafgvCefj3SQHIN4u8B8HaKgIBldArjIUOYxihKY3wK4yFDmMY4
SiN8mbjJH8RDhksIvEVphPlO4nzDt1Qlmr9Kt7/xaPImsGCaqMN5ohbNIsLeI5AkshhK8r2nsJAzmGXqcJqpR4nkR8mUUgUZJTMNZp86nH7qcSKpcTKlVKbjZKbBXFCHk0E9SSQ1SaaUynSSzDTRc+pkz6lTPWcTjtZNNFo34WDcRINxE461TTTWNuGw2ETDwi9fcnV1FQPF/vn88moDYhk2UbHvPkSAY9mcL3T9yA35jao0u/+c/vtfQux1
hBjw7ac3x9P3H6/mOMANFPb8n/Z493p4+v54vPwfF7D08Q=="""
_GLPROTO_VALUES = """eNrtGMtuFDEsybzaWdrtaqESqAtLOdBWrSr1xgX1woULAolfAPWA+AMERz6BA/wDH9JfKL9ApaoqSO12R0pUy5s4Hs+UjraMZDnJJHZsx49EKfrTSv5p4VzdYH4dOlpIS0doxPhoBmQeOmPP2H5gbIPBwwCgxijlU/T/MPZw5iEdm0/ytBuv2itmVvdLSC6HR7adgP9bHvprjD2WSJ8V3qz2A8aX7b8+6Fd4YLE
bf2Tx9wCvXmB8B8jj7LmK7Arhq+NnrvRiAP4L5l6YsOwpkh3q+JjQGdcvjjXYBxifBOxK0T7VYZnO1Wxf5bO8fHMv0JzKtr+zyLntXzkvRw9QpqeKtkdq40nJ1LFWcfumgrWbqL+A+iPUv2dxAWJihZ/ZtvGc/7dTGIL+QQsyS+XtEv3/0B6YSH8e5WxDxnfEvyoWfEZjuWc/H237TQf0kwDfzWr4dIJkyiO5HMOHKWwDnu8DdYqyvKq4/xr
9/wHi56od+xbgN4icA4PicxNYtDWaCeQC7alNHO8lFPtdLXafON+Pa553Q+QvXL+7Os4E7H9ia4PFjvh4BvpHYP8LRO1xXbFvTbjO1ffjgL9heEn4pg/uRGrKAtExjDOyA85AUlO3A0FNDcefMO+IXct1Y2Tj0P6KCJ0empMJsY93inzHBGxQ3mBNkdbIWzkjn0EYBs4d937m8wW8JkE2GDbQBX6DKOa0Xv1C1GD/Yj8+uytB3eVs9KIm/4c
WrzP0Jnm/k6zrMXLa7i24W6XMOGgCb5Vt+kksDicC/0mEe+sR5yhF75o3GVskcJe4Czj6zwVxgZu/QrUOjE0/mbIUDd838d1GMXMnhU0g1pqIH9bJ1+Ucv4N0CfqCNTkjBythjdb2O2becH2TN4gHU3il5XF7r0HOK1uKuRL9U7xH13iWP6H+4QGMTO72tGJvevv2hXB2wmQy+eVq90u6IDPN"""
_GLPROTO_ARGS = """eNq9WY2W6ygIfjZtTH/mGkzTpH3/J1m+DzSmnZ17z57d7ZmAogKiAjox5FPIOYYcAgr1U0K0pkE/lIGHRhgBliUpkulM+HiwC0jW8QJyEo6QqfKpEkh8r7to8FhkBOVRgv5SWPXXa1SHUZyps7fIVxD/KQFqtBr6zws6zlpcIgg6jzOgkjpahA2UXW4WMSkR89LOOWo3WQWKbwCFU6iqPvm3vo9BXQfRcBthMSPGw
Alrl18hN3WhxKBqzDZxUYOGpD/tCrQvFXSJ5QpWGB1vtSTxqxUlXs0Y2ali5c5EWrsE53ENlcUtNA6X4AxuoY3vNHYRP+nwWw46qxWrONJoS3Htmo5NguwS5FLncNsn89UtvTPzjWmD2gTl7PKvTY9bK30v78cRF10p3Tt5M3FdhXtYtIjNXr88kTr5GbDP9t4wZFpEG2OM+dgDo2LE8cPGI84yHHmjnsW7m/S+dXJSDPHY8nyyf0IJUl8Vs
Pp8gn7Svd4mlT++/ryacqDh8IkqZOeHC4PFdT2Udi88aQ+ge5kmjH0Aoz9PkEIcu1Y+G8qO5eIY0qCBWchOIVuqWuRiPkR+hTmv9af0WAj0XP48PfgnM21HOEXDAzwJAVZhN4hMbDMFZHdknV/YTC1zIBX5GltVzCOJUXG09uWNtuY/fbH5fkoqPEGlTIOxKw2b7L2dPqyYpy9eobPO8GVSppPovlX6SKBCWGB8gFHznYtnXvZUZx1hFtsTc
Bf1KGFbbldscP0Vsn0RKNsXbM7IshEoaYNsfKZdE6lOZJwZjhxRIx2wa2WqKQlfOdtRL2bihyGbLXepijMRhK+eYkPd1+fNUOl6H8Y39b+3TzePDw691L7jqKeeCyRDLnAvbcWiQqwHLaXfsPpmEtns1FgwM43KzUjrmrdfjOt5wDLcOWIyVeK+A0qhaQTLpEU2RN1rw4S9w6GcGQE8wMjtEm1Mm57YMpcBEgepoG7Hq/k7KVsrlXcrLX8Dy
zeGno47oDTaVvm5cuWgXKirUOJVp5RPI+xTlR1DxGHxkE7PtRF+KyPOWf/ovvwM/NT7NKsDmpnZtESBYdWOJ5V6dBY5WVqGpbCDaZHm1TKXRwPMYe4NTD2vdxvHtpZvWr6ake/7bm4NPuM42FHvJy0vQk5dHoQ0udwJJ/e88Gw2y9USU7pYD5/YxZMnBFbAiD1Kx5Tb3yllfqzN/NO6DIqSkjUMJAX9iO4v9qMwgu5cUz7VCWsREbL2qBDDr
H8nDTL4DkRv0pCRIrLEvXRBpMWvnlcbh+LrDfffoa3xMF1GqypCnEusJVb6cgtoOp/Eg60wMtJEz6aio4WoWBgGopO0KGydz14g1u4pLAqHwKKn72JbQI3e+TTpNt6z83jf9Lm1JLHLbJlL55ZLf/jPb/gwIahZ8pFXnyXbfv7tFaJLOtsl6F+L9sxmnrZkahlWfU0zl93U3YN7rjItIKjQLqplcSLNZGlZ9jS3wyAPllPahh80pgy+39hrF
Pd30Q4nozcSYMnrmYV1wmqRktcvFpkhrzf4ac3jtCcstTZ3IebHAhMz8XzBzvToKSGSvVBvDtekhHXTn1M2cxvqd8JqXgSs1FhI0q6hpn2eC1l26Sagh3yae0JxNR/FLBaAvmfpXJY7LmoKMBN0fsy9GeDzufu9de28H6wrvGA7PDKngZkQz/MOj/xH8ncBIwW4BEu5OT/dnY4+hVjw4umc59nRp5yzyXFBZxPkkuot6Wwyloo/hVkcYK4OM
XPFn/K+tynnlF6Gtv+71qnT7uN2FRs8aCWGBXce11CjNt42fjhu7T6hbrheWvZA+35AEtm2OO51X23sfr4g4O2Ap10T9ij2cOCvM8neIixCBw9PI54gJgbfq19lTWjeD+PhrmfOzfqK9ZV8q0Pd3zpBnCDtFSjP/QsTNfborRq2J4NsiYPavt0V7JmF1/O038XTniWJeuffGTBL7tcCAhxLY+4PGAdtDo82nIVf/9pM/iRC/UO1q9X/Dd2vN
VC8P/RJtIXF28VTl0U0u5AVBVCQky34QHg0oD5bcCed8YFwb0BnIk9jpGA1TgA6J+HCL+/MsBnwCjbPFfT8EvgZwwSGxtHOQArm4gDfmCYw1amZcwN84zuSrzEeydg4j8EflujRHL0xH8lcrUhf5ujDDnxifLcRFE8vwu2/LtdnJRPvGW7YX1rNp7WHHD302W61PcqLdD3EHoeZ+1hisTjyV5hWr/0rrq7lQ9ZhYF+3e2BOPtaV8WfpepOHJ
k9PimtK8KXfL3/O4u2E71kwxxebLCVGm6XFaExoZKt+F3hVlPcHWdyt4SxvaPZsGxw843bJCK5fO59+UHaT+cwxr5q9eOtUn9BKXaHJkgaQzLs6v0vn/KsofyyvEvdUonqP2FkKVsMzyewf30d6izG7xWVvZvPBYpb6IsDP1no0x+LtI9vr8HdlMB+7XaXpT8pnM1nsXsxrVNy6NeBit/8bxIxIB7mTveX/BaoDR8w="""
"_GLPROTO_STREAMS_END"

_GLPROTO_TYPEMAP = {
     0: (None,     "void"),
     1: (c_void_p, "eglImage", "VULKANPROCNV"),
     2: (c_char,   "char"),
     3: (c_char_p, ),
     4: (c_uint8,  "ubyte",  "boolean"),
     6: (c_int8,   "byte"),
     8: (c_uint16, "ushort", "half"),
    10: (c_int16,  "short"),
    12: (c_uint32, "uint",   "enum",   "bitfield"),
    14: (c_int32,  "int",    "fixed",  "sizei"),
    16: (c_uint64, "uint64"),
    18: (c_int64,  "int64"),
    20: (c_float,  "float",  "clampf"),
    22: (c_double, "double", "clampd"),
}
def _glproto_get_type(code):
    try:
        return _GLPROTO_TYPEMAP[code][0]
    except KeyError:
        return POINTER(_GLPROTO_TYPEMAP[code-1][0])

################################################################################

if sys.platform == 'win32':
    GLFUNCTYPE = WINFUNCTYPE
else:
    GLFUNCTYPE = CFUNCTYPE

class GLFunction(object):
    def __init__(self, required, name, ret, *args):
        self.name = name
        self.required = required
        self.prototype = GLFUNCTYPE(ret, *args)

class OpenGL(object):
    verbose = False
    _typemap = {
        0x1400:  c_int8,  # GL_BYTE
        0x1401: c_uint8,  # GL_UNSIGNED_BYTE
        0x1402:  c_int16, # GL_SHORT
        0x1403: c_uint16, # GL_UNSIGNED_SHORT
        0x1404:  c_int32, # GL_INT
        0x1405: c_uint32, # GL_UNSIGNED_INT
        0x1406: c_float,  # GL_FLOAT
        0x140A: c_double, # GL_DOUBLE
        0x140B: c_uint16, # GL_HALF_FLOAT
    }

    def __init__(self):
        self._overloaded_funcs = set(f for f in dir(self) if (f[0] != '_') and (f[0] == f[0].upper()))
        self.reverse_constant_lookup = {}

        # decode streams
        names = zlib.decompress(base64.b64decode(_GLPROTO_NAMES)).decode().split()
        value = 0
        for name, delta in zip(names, struct.unpack('<' + 'I' * _GLPROTO_CONST_COUNT, zlib.decompress(base64.b64decode(_GLPROTO_VALUES)))):
            value += delta
            setattr(self, name, value)
            self.reverse_constant_lookup[value] = name
        args = [x - 65 for x in zlib.decompress(base64.b64decode(_GLPROTO_ARGS))]
        self._funcmap = {}
        offset = 0
        for name in names[_GLPROTO_CONST_COUNT:]:
            l = args[offset]
            self._funcmap[name] = tuple(args[offset+1 : offset+l+2])
            offset += l + 2
        assert offset == len(args)

    def _runtime_init(self, loader):
        self._loader = loader
        version = self.GetString(self.VERSION).decode('utf-8', 'replace').lower()
        if version.startswith("opengl "):
            version = version[7:]
        self.es = version.startswith("es ")
        if self.es:
            version = version[3:]
        try:
            self.version = tuple(map(int, version.replace('_', ' ').split(' ', 1)[0].split('.', 2)[:2]))
        except ValueError:
            self.version = (0, 0)
        vp = (ctypes.c_long * 4)()
        self.GetIntegerv(self.VIEWPORT, cast(vp, POINTER(c_int)))
        self.viewport_width, self.viewport_height = vp[2:4]
        self._init_utils()

    def __getattr__(self, a):
        "load an OpenGL function on first use"
        if a.startswith('_'):
            a = a[1:]
        try:
            prototype = GLFUNCTYPE(*map(_glproto_get_type, self._funcmap[a]))
            del self._funcmap[a]
        except KeyError:
            raise AttributeError(a)
        if self.verbose:
            print("EZGL: loading function 'gl%s'" % a)
        funcptr = None
        for suffix in ("", "ARB", "ObjectARB", "EXT", "OES", "KHR"):
            funcptr = self._loader("gl" + a + suffix, prototype)
            if funcptr:
                break
        if not funcptr:
            raise ImportError("call to unimplemented OpenGL function 'gl%s'" % a)
        if a in self._overloaded_funcs:
            setattr(self, '_' + a, funcptr)
        else:
            setattr(self, a, funcptr)
        return funcptr

    def __getitem__(self, value):
        "look up the symbolic name of a constant"
        try:
            return self.reverse_constant_lookup[value]
        except KeyError:
            return "0x%04X" % value

    ##### Overloaded OpenGL Functions #####
    # (these make the OpenGL API a little bit more "pythonic")

    def GenTextures(self, n=None):
        bufs = (c_uint * (n or 1))()
        self._GenTextures(n or 1, bufs)
        if not n: return bufs[0]
        return list(bufs)

    def DeleteTextures(self, *texs):
        buf = (c_uint * len(texs))(*texs)
        self._DeleteTextures(len(texs), buf)

    def ActiveTexture(self, tmu):
        if tmu < self.TEXTURE0:
            tmu += self.TEXTURE0
        self._ActiveTexture(tmu)

    def GenBuffers(self, n=1):
        bufs = (c_uint * n)()
        self._GenBuffers(n, bufs)
        if n == 1: return bufs[0]
        return list(bufs)

    def BufferData(self, target, size=0, data=None, usage=0x88E4, type=None):
        # default: usage=STATIC_DRAW
        if isinstance(data, list):
            if type:
                type = self._typemap[type]
            elif isinstance(data[0], int):
                type = c_int32
            elif isinstance(data[0], float):
                type = c_float
            else:
                raise TypeError("cannot infer buffer data type")
            size = len(data) * sizeof(type)
            data = (type * len(data))(*data)
        self._BufferData(target, size, cast(data, c_void_p), usage)

    def ShaderSource(self, shader, source):
        source = c_char_p(source.encode())
        self._ShaderSource(shader, 1, pointer(source), None)

    def GetShaderi(self, shader, pname):
        res = (c_int * 1)()
        self.GetShaderiv(shader, pname, res)
        return res[0]

    def GetShaderInfoLog(self, shader):
        length = self.GetShaderi(shader, self.INFO_LOG_LENGTH)
        if not length: return ""
        buf = create_string_buffer(length + 1)
        self._GetShaderInfoLog(shader, length + 1, None, buf)
        return buf.raw.split(b'\0', 1)[0].decode('utf-8', 'replace')

    def GetProgrami(self, program, pname):
        res = (c_int * 1)()
        self.GetProgramiv(program, pname, res)
        return res[0]

    def GetProgramInfoLog(self, program):
        length = self.GetProgrami(program, self.INFO_LOG_LENGTH)
        if not length: return ""
        buf = create_string_buffer(length + 1)
        self._GetProgramInfoLog(program, length + 1, None, buf)
        return buf.raw.split(b'\0', 1)[0].decode('utf-8', 'replace')

    def Uniform(self, location, *values):
        if (len(values) == 1) and not(type(values[0]) in (int, float)):
            values = values[0]
        if not values:
            raise TypeError("no values for glUniform")
        l = len(values)
        if l > 4:
            raise TypeError("uniform vector has too-high order (%d)" % len(values))
        if any(isinstance(v, float) for v in values):
            if   l == 1: self.Uniform1f(location, values[0])
            elif l == 2: self.Uniform2f(location, values[0], values[1])
            elif l == 3: self.Uniform3f(location, values[0], values[1], values[2])
            else:        self.Uniform4f(location, values[0], values[1], values[2], values[3])
        else:
            if   l == 1: self.Uniform1i(location, values[0])
            elif l == 2: self.Uniform2i(location, values[0], values[1])
            elif l == 3: self.Uniform3i(location, values[0], values[1], values[2])
            else:        self.Uniform4i(location, values[0], values[1], values[2], values[3])

    def GenFramebuffers(self, n=None):
        bufs = (c_uint * (n or 1))()
        self._GenFramebuffers(n or 1, bufs)
        if not n: return bufs[0]
        return list(bufs)

    def DeleteFramebuffers(self, *fbos):
        buf = (c_uint * len(fbos))(*fbos)
        self._DeleteFramebuffers(len(fbos), buf)

    def GenRenderbuffers(self, n=None):
        bufs = (c_uint * (n or 1))()
        self._GenRenderbuffers(n or 1, bufs)
        if not n: return bufs[0]
        return list(bufs)

    def DeleteRenderbuffers(self, *rbos):
        buf = (c_uint * len(rbos))(*rbos)
        self._DeleteRenderbuffers(len(rbos), buf)

    def Viewport(self, x, y, width, height):
        self._Viewport(x, y, width, height)
        self.viewport_width = width
        self.viewport_height = height

    ##### Convenience Functions #####

    def _init_utils(self):
        self.enabled_attribs = set()

    def set_enabled_attribs(self, *attrs):
        want = set(attrs)
        for a in (want - self.enabled_attribs):
            self.EnableVertexAttribArray(a)
        for a in (self.enabled_attribs - want):
            self.DisableVertexAttribArray(a)
        self.enabled_attribs = want

    def set_texture(self, target=0x0DE1, tex=0, tmu=0):
        self.ActiveTexture(self.TEXTURE0 + tmu)
        self.BindTexture(target, tex)

    def make_texture(self, target=0x0DE1, wrap=0x812F, filter=0x2701, img=None):
        # defaults: TEXTURE_2D / CLAMP_TO_EDGE / LINEAR_MIPMAP_NEAREST
        tex = self.GenTextures()
        min_filter = filter
        if min_filter < self.NEAREST_MIPMAP_NEAREST:
            mag_filter = min_filter
        else:
            mag_filter = self.NEAREST + (min_filter & 1)
        self.BindTexture(target, tex)
        self.TexParameteri(target, self.TEXTURE_WRAP_S, wrap)
        self.TexParameteri(target, self.TEXTURE_WRAP_T, wrap)
        self.TexParameteri(target, self.TEXTURE_MIN_FILTER, min_filter)
        self.TexParameteri(target, self.TEXTURE_MAG_FILTER, mag_filter)
        if img:
            self.load_texture(target, img)
        return tex

    def load_texture(self, target, tex_or_img, img=None, format=None):
        if img:
            self.BindTexture(target, tex_or_img)
        else:
            img = tex_or_img
        if not format:
            if   img.mode == 'RGBA': format = self.RGBA
            elif img.mode == 'RGB':  format = self.RGB
            elif img.mode == 'LA':   format = self.LUMINANCE_ALPHA
            elif img.mode == 'L':    format = self.LUMINANCE
            else:
                img = img.convert('RGBA')
                format = self.RGBA
        self.TexImage2D(target, 0, format, img.size[0], img.size[1], 0, format, self.UNSIGNED_BYTE, img.tobytes())

    def create_static_buffer(self, target=0x8892, data=None, type=None):
        # default: target=ARRAY_BUFFER
        buf = self.GenBuffers()
        self.BindBuffer(target, buf)
        if data and not(isinstance(data, str)) and not(type):
            if isinstance(data[0], float):
                type = 0x1406  # GL_FLOAT
            else:
                vmin = min(data)
                vmax = max(data)
                if (vmin >= 0) and (vmax < 256):
                    type = 0x1401  # GL_UNSIGNED_BYTE
                elif (vmin >= -128) and (vmax < 128):
                    type = 0x1400  # GL_BYTE
                elif (vmin >= 0) and (vmax < 65536):
                    type = 0x1403  # GL_UNSIGNED_SHORT
                elif (vmin >= -32768) and (vmax < 32768):
                    type = 0x1402  # GL_SHORT
                elif vmin >= 0:
                    type = 0x1405  # GL_UNSIGNED_INT
                else:
                    type = 0x1404  # GL_INT
        self.BufferData(target, data=data, type=type)
        return buf

class ShaderCompileError(SyntaxError):
    pass
class InvalidShaderError(ShaderCompileError):
    pass

class Shader(object):
    LOG_NEVER = 0
    LOG_ON_ERROR = 1
    LOG_IF_NOT_EMPTY = 2
    LOG_ALWAYS = 3
    LOG_DEFAULT = LOG_ON_ERROR

    def __init__(self, vs=None, fs=None, attributes=[], uniforms=[], name=None, loglevel=None):
        if not(vs): vs = self.vs
        if not(fs): fs = self.fs
        if not(attributes) and hasattr(self, 'attributes'):
            attributes = self.attributes
        if isinstance(attributes, dict):
            attributes = list(attributes.items())
        if not(uniforms) and hasattr(self, 'uniforms'):
            uniforms = self.uniforms
        if isinstance(uniforms, dict):
            uniforms = list(uniforms.items())
        uniforms = [((u, None) if isinstance(u, str) else u) for u in uniforms]
        if (loglevel is None) and hasattr(self, 'loglevel'):
            loglevel = self.loglevel
        if loglevel is None:
            loglevel = self.LOG_DEFAULT
        self.name = name or self.__class__.__name__

        self.program = gl.CreateProgram()
        def handle_shader_log(status, log_getter, action):
            force_log = (loglevel >= self.LOG_ALWAYS) or ((loglevel >= self.LOG_ON_ERROR) and not(status))
            if force_log or (loglevel >= self.LOG_IF_NOT_EMPTY):
                log = log_getter().rstrip()
            else:
                log = ""
            if force_log or ((loglevel >= self.LOG_IF_NOT_EMPTY) and log):
                if status:
                    print("Info: log for %s %s:" % (self.name, action), file=sys.stderr)
                else:
                    print("Error: %s %s failed - log information follows:" % (self.__class__.__name__, action), file=sys.stderr)
                for line in log.split('\n'):
                    print('>', line.rstrip(), file=sys.stderr)
            if not status:
                raise ShaderCompileError("failure during %s %s" % (self.name, action))
        def handle_shader(type_enum, type_name, src):
            if not gl.es:
                src = src.replace("precision highp float;", "")
                src = src.replace("precision mediump float;", "")
                src = src.replace("precision lowp float;", "")
                src = src.replace("highp ", "")
                src = src.replace("mediump ", "")
                src = src.replace("lowp ", "")
            shader = gl.CreateShader(type_enum)
            gl.ShaderSource(shader, src)
            gl.CompileShader(shader)
            handle_shader_log(gl.GetShaderi(shader, gl.COMPILE_STATUS),
                              lambda: gl.GetShaderInfoLog(shader),
                              type_name + " shader compilation")
            gl.AttachShader(self.program, shader)
            gl.DeleteShader(shader)
        handle_shader(gl.VERTEX_SHADER, "vertex", vs)
        handle_shader(gl.FRAGMENT_SHADER, "fragment", fs)
        for attr in attributes:
            if not isinstance(attr, str):
                loc, name = attr
                if isinstance(loc, str):
                    loc, name = name, loc
                setattr(self, name, loc)
            elif hasattr(self, attr):
                name = attr
                loc = getattr(self, name)
            gl.BindAttribLocation(self.program, loc, name.encode())
        gl.LinkProgram(self.program)
        handle_shader_log(gl.GetProgrami(self.program, gl.LINK_STATUS),
                          lambda: gl.GetProgramInfoLog(self.program),
                          "linking")
        gl.UseProgram(self.program)
        for name in attributes:
            if isinstance(name, str) and not(hasattr(self, attr)):
                setattr(self, name, int(gl.GetAttribLocation(self.program, name.encode())))
        for u in uniforms:
            loc = int(gl.GetUniformLocation(self.program, u[0].encode()))
            setattr(self, u[0], loc)
            if u[1] is not None:
                gl.Uniform(loc, *u[1:])

    def use(self):
        gl.UseProgram(self.program)
        return self

    def delete(self):
        gl.DeleteProgram(self.program)

    @classmethod
    def get_instance(self):
        try:
            instance = self._instance
            if instance:
                return instance
            else:
                raise InvalidShaderError("shader failed to compile in the past")
        except AttributeError:
            try:
                self._instance = self()
            except ShaderCompileError as e:
                self._instance = None
                raise
            return self._instance

################################################################################

gl = OpenGL()
g_win_flags = 0

def Init(size=None, fullscreen=False, resizable=False, title="ezgl"):
    global gl, g_win_flags

    # normal PyGame initialization
    pygame.display.init()
    pygame.display.gl_set_attribute(GL_RED_SIZE,   8)
    pygame.display.gl_set_attribute(GL_GREEN_SIZE, 8)
    pygame.display.gl_set_attribute(GL_BLUE_SIZE,  8)
    pygame.display.gl_set_attribute(GL_ALPHA_SIZE, 8)
    flags = OPENGL | DOUBLEBUF
    if fullscreen:
        flags |= FULLSCREEN
        if not(size) or not(size[0]):
            size = (0, 0)
    else:
        if not(size) or not(size[0]):
            size = DEFAULT_WINDOW_SIZE
        if resizable:
            flags |= RESIZABLE
    g_win_flags = flags
    pygame.display.set_caption(title)
    pygame.display.set_mode(size, flags, vsync=1)
    pygame.key.set_repeat(500, 30)
    pygame.time.set_timer(HEARTBEAT, 1000)

    # load OpenGL functions
    sdl = None
    try:
        pattern = re.compile(r'(lib)?SDL(?!_[a-zA-Z]+).*?\.(dll|so(\..*)?|dylib)$', re.I)
        libs = []
        for suffix in ("/.libs", "/.dylibs", ".libs", ".dylibs"):
            libdir = pygame.__path__[0].rstrip('/\\') + suffix
            if os.path.isdir(libdir):
                libs += [os.path.join(libdir, lib) for lib in sorted(os.listdir(libdir)) if pattern.match(lib)]
        sdl = libs.pop(0)
    except (IndexError, AttributeError, EnvironmentError):
        pass
    if pygame.get_sdl_version() >= (2, 0, 0):
        sdl = sdl or ctypes.util.find_library("SDL2") or ctypes.util.find_library("SDL2-2.0") or ctypes.util.find_library("SDL-2.0") or "SDL2"
    else:
        sdl = sdl or ctypes.util.find_library("SDL") or ctypes.util.find_library("SDL-1.2") or "SDL"
    try:
        sdl = CDLL(sdl, RTLD_GLOBAL)
        get_proc_address = CFUNCTYPE(c_void_p, c_char_p)(('SDL_GL_GetProcAddress', sdl))
    except OSError:
        raise ImportError("failed to load the SDL library")
    except AttributeError:
        raise ImportError("failed to load SDL_GL_GetProcAddress from the SDL library")
    def loadsym(name, prototype):
        addr = get_proc_address(name.encode())
        if not addr:
            return None
        return prototype(addr)
    gl._runtime_init(loadsym)
    return gl

if sys.platform == "win32":
    def NotifyResize(w, h):
        pass
else:
    def NotifyResize(w, h):
        pygame.display.set_mode((w, h), g_win_flags)

def SwapBuffers():
    pygame.display.flip()

################################################################################

def run_update(cache=True):
    import urllib.request, re, time

    # fixes for specific function arguments
    FIXES = {
        "GetString": ((0, "char*"), ),
    }

    # download header files
    headers = {}
    for url in (
        "https://registry.khronos.org/OpenGL/api/GLES3/gl31.h",
        "https://registry.khronos.org/OpenGL/api/GL/glcorearb.h"
    ):
        header = url.rsplit('/', 1)[-1]
        if cache:
            try:
                headers[header] = open(header).read()
                print("using locally cached", header)
                continue
            except IOError:
                pass
        print("downloading", url, "...")
        headers[header] = urllib.request.urlopen(url).read().decode('utf-8', 'replace')
        if cache:
            open(header, 'w').write(headers[header])

    # helper functions
    def split_ext(name, prefix=''):
        for ext in ("ARB", "EXT", "KHR", "OES"):
            if name.endswith(prefix + ext):
                return (name[:-len(prefix)-len(ext)], ext)
        return (name, None)

    # function argument parser (returns a type code)
    def parse_arg(decl):
        # extract pointer-ness
        pointer = decl.count('*')
        decl = decl.replace('*', '')
        # split into words
        decl = list(filter(None, decl.split()))
        # discard variable name, if present
        if len(decl) > 1:
            del decl[-1]
        orig_decl = ' '.join(decl) + '*' * pointer
        # discard "const"
        if decl[0] == 'const':
            del decl[0]
        # replace "struct" by void
        if (decl[0] == 'struct') and (len(decl) > 1):
            decl = ["void"] + decl[2:]
        # at this point, only one word should be left
        decl, _ = split_ext(decl[0])
        # remove "GL" prefix
        if decl.startswith('GL'):
            decl = decl[2:]
        # map some complex pointer types to simple void pointers
        if decl in ("DEBUGPROC", "sync"):
            decl = "void"
            pointer = 1
        # turn double-indirect pointers into mere void pointers
        if pointer > 1:
            decl = "void"
            pointer = 1
        # look up the code for the declaration
        try:
            return typemap[decl] | pointer
        except KeyError:
            print("ERROR: %s:%d: unrecognized type %r in prototype of function gl%s" % (header, lineno, orig_decl, name), file=sys.stderr)
            return -1

    # format an argument list back into a human-readable interpretation
    def unparse_arg(code):
        return _GLPROTO_TYPEMAP[code & (~1)][1] + ('*' if (code & 1) else '')
    def unparse_func(name, args):
        return "%s gl%s(%s)" % (unparse_arg(args[0]), name, ', '.join(map(unparse_arg, args[1:])))

    # invert the type map and add intptr_t types
    typemap = {}
    for code, data in _GLPROTO_TYPEMAP.items():
        for name in data[1:]:
            typemap[name] = code
    intptr = typemap["int64"] if (struct.calcsize("P") > 4) else typemap["int"]
    typemap["intptr"] = intptr
    typemap["sizeiptr"] = intptr

    # parse headers
    constants = {}
    functions = {}
    exts = {}
    for header, content in headers.items():
        lineno = 0
        for line in content.split('\n'):
            lineno += 1

            # constant definition?
            m = re.match(r'#define\s+GL_([A-Z0-9_]+)\s+(0x[0-9a-fA-F]+|\d+)', line)
            if m:
                name, ext = split_ext(m.group(1), '_')
                if name.startswith("VERSION_") or name.startswith("ES_VERSION_"):
                    continue  # ignore version defines
                value = int(m.group(2), 0)
                if value >= 2**32:
                    continue  # ignore 64-bit values (currently, there's only one, GL_TIMEOUT_IGNORED)
                if name in constants:  # potential collision
                    if exts[name] and not(ext):
                        pass  # core overrides extension
                    elif not(exts[name]) and ext:
                        continue  # extension doesn't override code
                    elif constants[name] != value:
                        print("WARNING: %s:%d: constant definition collision: GL_%s = 0x%04X != 0x%04X" % (header, lineno, name, value, constants[name]), file=sys.stderr)
                constants[name] = value
                exts[name] = ext
                continue

            # function declaration?
            m = re.match(r'(GL)?_?API(CALL)?\s+(?P<ret>.*?\s+\*?)(GL)?_?APIENTRY\s+gl(?P<name>\w+)\s*\((?P<args>[^)]*)\)', line)
            if not m:
                # not a function declaration -> rule out lines we generally ignore
                if not line.strip():           continue  # empty line
                if '*' in line[:2]:            continue  # comment ("/*", "*/", "**", " *")
                if line.startswith('#'):       continue  # preprocessor
                if line.startswith('typedef'): continue  # type declaration
                if line.startswith('struct'):  continue  # structure declaration
                if line.startswith('extern'):  continue  # "extern C" guard
                if line.startswith('}'):       continue  # end of block
                print("WARNING: %s:%d: unrecognized line %r" % (header, lineno, line.strip()), file=sys.stderr)
                continue

            # parse and sanitize arguments
            name, ext = split_ext(m.group('name'))
            args = list(map(parse_arg, [m.group('ret') + " X"] + m.group('args').split(',')))
            if -1 in args:
                continue  # error in argument conversion, discard this call
            # remove dummy "void" argument in calls without arguments
            if (len(args) == 2) and not(args[-1]):
                del args[-1]
            if 0 in args[1:]:
                print("ERROR: %s:%d: void arguments found in prototype of function gl%s" % (header, lineno, orig_decl, name), file=sys.stderr)
                continue

            # apply fixes
            for idx, newdecl in FIXES.get(name, []):
                args[idx] = parse_arg(newdecl + " X")

            # add the function to the list
            if name in functions:  # potential collision
                if exts[name] and not(ext):
                    pass  # core overrides extension
                elif not(exts[name]) and ext:
                    continue  # extension doesn't override code
                elif functions[name] != args:
                    print("WARNING: %s:%d: function prototype collision: %s != %s" % (header, lineno, unparse_func(name, args), unparse_func(name, functions[name])), file=sys.stderr)
            functions[name] = args
            exts[name] = ext
    print("imported %d constants and %d functions" % (len(constants), len(functions)))

    # generate packed data streams
    print("generating data streams ...")
    constants = sorted(((v, n) for n, v in constants.items()))
    functions = sorted(functions.items())
    names = [n for v, n in constants] + [n for n, a in functions]
    names = ' '.join(names)

    # constant values stream -> delta coding
    values = list(range(len(constants)))
    l = 0
    for i in values:
        v = constants[i][0]
        values[i] = v - l
        l = v
    values = struct.pack('<' + 'I' * len(values), *values)

    # argument code stream
    args = []
    for name, func_args in functions:
        args.append(len(func_args) - 1)
        args.extend(func_args)
    args = ''.join(chr(x + 65) for x in args)

    # compress and encode data streams
    def encode(stream, name, description):
        if isinstance(stream, str):
            stream = stream.encode('utf-8')
        rawsize = len(stream)
        stream = name + ' = """' + base64.b64encode(zlib.compress(stream, 9)).decode().replace('\n', '')
        p = 252
        while p < len(stream):
            stream = stream[:p] + '\n' + stream[p:]
            p += 253
        stream += '"""\n'
        print("encoding %s stream: %d -> %d (%.1f%%)" % (description, rawsize, len(stream), len(stream) * 100.0 / rawsize))
        return stream
    data = "_GLPROTO_CONST_COUNT = %d\n" % len(constants) \
         + encode(names,  "_GLPROTO_NAMES",  "name") \
         + encode(values, "_GLPROTO_VALUES", "constant value") \
         + encode(args,   "_GLPROTO_ARGS",   "prototype argument")

    # change this script
    print("updating", sys.argv[0], "...")
    f = open(sys.argv[0], "r")
    code = f.read().replace('\r', '')
    f.close()
    code = code[:code.find('"_GLPROTO_STREAMS_BEGIN"') + len("_GLPROTO_STREAMS_BEGIN") + 3] \
         + "# automatically generated on %s\n" % time.strftime("%Y-%m-%d %H:%M", time.localtime()) \
         + "# source files: %s\n" % ", ".join(sorted(headers)) \
         + data \
         + code[code.find('"_GLPROTO_STREAMS_END"'):]
    f = open(sys.argv[0], "w")
    f.write(code)
    f.close()
    print("done.")

################################################################################

def run_demo(*args):
    import math
    Init()
    while True:
        while True:
            ev = pygame.event.poll()
            if not ev:
                break
            if ev.type == QUIT:
                sys.exit(0)
        t = pygame.time.get_ticks() * 0.001
        gl.ClearColor(0.5 + math.sin(t * 0.2 + 1.3), 0.5 + math.sin(t * 0.3 + 2.7), 0.5 + math.sin(t * 0.5 + 5.3), 1.0)
        gl.Clear(gl.COLOR_BUFFER_BIT)
        SwapBuffers()

if __name__ == "__main__":
    try:
        func = globals()["run_" + sys.argv[1].strip().lower()]
    except (IndexError, KeyError):
        print("Usage:")
        print("  - '%s demo'    to start a little demo application" % sys.argv[0])
        print("  - '%s update'  to update the OpenGL prototype information" % sys.argv[0])
        sys.exit(2)
    sys.exit(func(*sys.argv[2:]) or 0)
