#version 410

//#define MAX_LIGHTS 3
#define TEX_SCALE 1.5

#pragma include "p3d/uniform.glsl"
#pragma include "lib/shadow.glsl"
#pragma include "lib/constants.glsl"
#pragma include "lib/color.glsl"
#pragma include "lib/math.glsl"
#pragma include "lib/rot.glsl"
#pragma include "colors.glsl"

// Uniform inputs
uniform float u_MaxShininess;
uniform float u_RimLightIntensity;
uniform float u_ShadowSamples;
uniform float u_ShadowSpread;
uniform float u_SpecularBlendStrength;
uniform int u_NumberOfLights;
uniform float u_SpecularPower;
uniform float u_Roughness;
uniform float u_Brightness;
uniform float u_Saturation;
uniform float u_Reflectivity;

uniform sampler2D u_HexTex;
uniform sampler2D u_XTex;
uniform float u_Lodz;

uniform vec3 u_TexOrder;

// Input from vertex shader
in vec4 vertInShadowSpaces[MAX_LIGHTS];
in vec4 vertColor;
in vec4 vertPosition;
//in vec4 domiPosition;
in vec2 vertMultiTexCoord0;
in vec3 vertNormal;
//in vec3 binormal;
in vec3 tangent;
in float neg;

// Pass-through / varyings:
in vec3 vertObjPosition;
in float instanceID;

in float doTex;


// Output to the screen
//out vec4 fragColor;
//out vec4 reflectivityOut;
layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 reflectivityOut;

#define MAX_FRESNEL_POWER 5.0
#define MAX_SHININESS     127.75

// Clamp value to [0,1] (short alias)
float sat(float x) { return clamp(x, 0.0, 1.0); }

//vec3 dir_to_rgb(vec3 v) { return v * 0.5 + 0.5; } // map [-1,1] -> [0,1]

void main() {

    vec4 diffuseColor = vertColor;

    if (diffuseColor.a < 0.5) discard;

    if (doTex > 0.5) {
        vec3 pos = rotY(vertObjPosition, PI_OVER_6 * 3.0) * TEX_SCALE + 0.5;
        diffuseColor.rgb += texture(u_HexTex, pos.xz).rgb * 100.0;
    }

    if (u_Lodz > 0.0 && instanceID == 0.0) {
        vec3 pos = rotY(vertObjPosition, PI_OVER_6 * 7.0) * TEX_SCALE * 1.1 + vec3(0.47, 0.0, 0.45);
        float x = texture(u_XTex, pos.xz).a * u_Lodz;
        diffuseColor.rgb = mix(diffuseColor.rgb, POL_COL, x);
    }

    diffuseColor = color_ops(diffuseColor, u_Saturation, u_Brightness);

//    vec4 roughnessMap = texture(p3d_TextureSelector[0], vertMultiTexCoord0);
    vec4 roughnessMap = vec4(1.0);

//    vec4 normalTex = texture(p3d_TextureNormal[0], vertMultiTexCoord0);
    vec4 normalTex = vec4(1.0);

//    float roughness = roughnessMap.g;
    float roughness = 0.0;

    float shininess = (1.0 - roughness) * MAX_SHININESS * u_MaxShininess;

    vec4 diffuse  = vec4(0.0, 0.0, 0.0, diffuseColor.a);
    vec4 specular = vec4(0.0, 0.0, 0.0, diffuseColor.a);
    vec4 rim      = vec4(0.0, 0.0, 0.0, diffuseColor.a);

//
//    vec3 materialSpecularColor = p3d_Material.specular;
//

    vec3 Nv = normalize(vertNormal);
    vec3 Tv = normalize(tangent - Nv * dot(tangent, Nv)); // upewnij T ⟂ N
    vec3 Bv = cross(Nv, Tv);                               // brak sign — prosto i szybko

    vec3 nMap = normalize(texture(p3d_TextureNormal[0], vertMultiTexCoord0).rgb * 2.0 - 1.0);
//    vec3 normal = u_UseNormalTex ? normalize(mat3(Tv, Bv, Nv) * nMap) : Nv;
    vec3 normal = normalize(mat3(Tv, Bv, Nv) * nMap);

    vec3 eyeDirection = normalize(-vertPosition.xyz);

    vec3 test;

    for (int i = 0; i < u_NumberOfLights; ++i) {  // i = 0

        vec3 lightDirection = p3d_LightSource[i].position.xyz - vertPosition.xyz * p3d_LightSource[i].position.w;

        vec3 unitLightDirection = normalize(lightDirection);
        vec3 halfwayDirection   = normalize(unitLightDirection + eyeDirection);

        float lightDistance = length(lightDirection);

        float attenuation = 1 / (
            p3d_LightSource[i].constantAttenuation +
            p3d_LightSource[i].linearAttenuation * lightDistance +
            p3d_LightSource[i].quadraticAttenuation * (lightDistance * lightDistance)
        );

        if (attenuation <= 0.0) { continue; }

        // Diffuse
        float diffuseIntensity  = dot(normal, unitLightDirection);
        if (diffuseIntensity < 0.0) { continue; }
//        vec4 diffuseTemp = vec4(
//            clamp(diffuseColor.rgb * p3d_LightSource[i].diffuse.rgb * diffuseIntensity, 0.0 , 1.0), diffuseColor.a
//        );
//        diffuseTemp = clamp(diffuseTemp, vec4(0), diffuseColor);
        vec4 diffuseTemp = vec4(
            clamp(diffuseColor.rgb * p3d_LightSource[i].diffuse.rgb * diffuseIntensity, 0.0 , 1.0), diffuseColor.a
        );


        // Specular
        float specularIntensity = sat(dot(normal, halfwayDirection));
        vec4 lightSpecularColor = p3d_LightSource[i].specular;
        vec4 materialSpecularColor = vec4(vec3(1.0 - roughness), diffuseColor.a);

//
//        vec4 materialSpecularColor = vec4(mix(vec3(0.04), diffuseColor.rgb, metallic), diffuseColor.a);
//

        float fresnelFactor = dot(halfwayDirection, eyeDirection);
        fresnelFactor = max(fresnelFactor, 0.0);
        fresnelFactor = 1.0 - fresnelFactor;
        fresnelFactor = pow(fresnelFactor, MAX_FRESNEL_POWER);
        materialSpecularColor.rgb = mix(
            materialSpecularColor.rgb,
            vec3(u_SpecularBlendStrength),
            sat(fresnelFactor)
        );

        vec4 specularTemp = vec4(vec3(0.0), diffuseColor.a);
        specularTemp.rgb  = lightSpecularColor.rgb * pow(specularIntensity, shininess);
        specularTemp.rgb *= materialSpecularColor.rgb;
        specularTemp.rgb  = clamp(specularTemp.rgb, 0.0, 1.0);  // Comment to have more specular
        specularTemp.rgb *= u_SpecularPower;

        // Spot
        float unitLightDirectionDelta = dot(normalize(p3d_LightSource[i].spotDirection), -unitLightDirection);
        if (unitLightDirectionDelta < p3d_LightSource[i].spotCosCutoff) { continue; }
        float spotExponent = p3d_LightSource[i].spotExponent;
        diffuseTemp.rgb *= (spotExponent <= 0.0 ? 1.0 : pow(unitLightDirectionDelta, spotExponent));

//        float u_ShadowSpread = 0.0;
//        float u_ShadowSamples = 0.0;
        // Shadow
        float shadow = sh(
            p3d_LightSource[i].shadowMap,
            vertInShadowSpaces[i],
            u_ShadowSpread,
            u_ShadowSamples // float selector: 0..4
        );

//        shadow = 1.0;

        // JUST TESTING!!!!
        diffuseTemp.rgb  *= shadow;
        specularTemp.rgb *= shadow;

//        test = vec3(diffuseTemp);

        diffuseTemp.rgb  *= attenuation;
        specularTemp.rgb *= attenuation;

        diffuse  += diffuseTemp;
        specular += specularTemp;

        // Rim
        vec4 rimLight = vec4(0.0);
        rimLight.rgb = vec3(1.0 - max(0.0, dot(normalize(-vertPosition.xyz), normalize(normal))));
        rimLight.rgb = pow(rimLight.rgb, vec3(2.0)) * u_RimLightIntensity;
        rimLight.rgb *= diffuse.rgb;
        rim += rimLight;

    }

    vec4 ambient = p3d_Material.ambient * p3d_LightModel.ambient * diffuseColor;

    vec3 color = diffuse.rgb + rim.rgb + specular.rgb + ambient.rgb + p3d_Material.emission.rgb;

//    color.rgb = test;
//    color.rgb = diffuseTemp.rgb;
//    color.rgb = diffuseColor.rgb;
//    color.rgb = Tv;
//    color.rgb = normal;
//    color.rgb = vertNormal;
//    color.rgb = tangent;
//    color.rgb = dir_to_rgb(normalize(tangent));
//    color.rgb = vec3(u_ShadowSamples);
//    color.rgb = vec3(u_ShadowSpread * 100.0);

    fragColor = vec4(color, diffuseColor.a);
    reflectivityOut = vec4(vec3(u_Reflectivity), 1.0);
}
