
.include "fb32x32.inc"

.include "globals.inc"

BRESENQUAD  := $e400 ; $400 bytes
PARABOLA    := $e800
STARSPEED   := $e900
STARSPEEDF  := $e940
STARPOS     := $e980
STARPOSF    := $e9c0
BRESENBASE  := $ea00 ;  $80 bytes

.segment "DATA"

.segment "CODE"

; 4 quadrants with 16x16 pixels each
; each quadrant gets 16 lines, 8 per octant
; 16 steps per line -> one page per quadrant
; 256 bytes for on quadrant of cosinus/parabel

stars3d:
   lda   frmcnt+0
   ora   frmcnt+1
   bne   @initdone

   ldx   #<(STARSPEEDF-STARSPEED-1)
:
   lda   RANDOM
   and   #$0f
   beq   :-
   sta   STARSPEED,x
   lda   RANDOM
   sta   STARSPEEDF,x
   stz   STARPOS,x
   stz   STARPOSF,x
   dex
   bpl   :-

   lda   #$01
   sta   FB32X32_CCOLMAP_IDX

   ldx   #$00
:
   txa
   lsr
   lsr
   lsr
   lsr
   sta   FB32X32_CCOLMAP_R
   sta   FB32X32_CCOLMAP_G
   beq   :+
   inc
   cmp   #$0f
   bcc   :+
   lda   #$0f
:
   sta   FB32X32_CCOLMAP_B
   inx
   bne   :--

   lda   #$01
   sta   FB32X32_COLMAP

   stz   vector+0
   lda   #>PARABOLA
   sta   vector+1
   jsr   parabola
   jsr   calc_lines

@initdone:
   ldx   #<(STARSPEEDF-STARSPEED-1)
@starloop:
   lda   STARPOSF,x
   clc
   adc   STARSPEEDF,x
   sta   STARPOSF,x
   lda   STARPOS,x
   adc   STARSPEED,x
   sta   STARPOS,x
   bcc   :++
:
   lda   RANDOM
   and   #$0f
   beq   :-
   sta   STARSPEED,x
   lda   RANDOM
   sta   STARSPEEDF,x
:
   dex
   bpl   @starloop

   jsr   clearfb
   jsr   setstars

   jsr   show4fb

.if SHORTEST
.else
   lda   frmcnt+0
   cmp   #$7f
   bne   :+
.endif
   lda   frmcnt+1
   beq   :+
   jmp   schedulenext
:
   rts


setstars:
   ldx   #$0f

@loop:
   txa
   asl
   asl
   asl
   asl
   sta   vector2+0

   lda   STARPOS+$00,x
   sta   tmp8
   tay
   lda   PARABOLA,y
   ora   vector2+0
   tay
   lda   BRESENQUAD+$000,y
   tay
   lda   tmp8
   sta   FRAMEBUFFER+$000,y

   lda   STARPOS+$10,x
   sta   tmp8
   tay
   lda   PARABOLA,y
   ora   vector2+0
   tay
   lda   BRESENQUAD+$100,y
   tay
   lda   tmp8
   sta   FRAMEBUFFER+$100,y

   lda   STARPOS+$20,x
   sta   tmp8
   tay
   lda   PARABOLA,y
   ora   vector2+0
   tay
   lda   BRESENQUAD+$200,y
   tay
   lda   tmp8
   sta   FRAMEBUFFER+$200,y

   lda   STARPOS+$30,x
   sta   tmp8
   tay
   lda   PARABOLA,y
   ora   vector2+0
   tay
   lda   BRESENQUAD+$300,y
   tay
   lda   tmp8
   sta   FRAMEBUFFER+$300,y

   dex
   bpl   @loop

   rts


calc_lines:
   ldx   #$00
@loop:
   stx   tmp8
   stz   bl_x0
   stz   bl_y0
   txa
   asl
   sta   bl_x1
   lda   #$0f
   sta   bl_y1
   jsr   bresenhelp

   ldx   #$00
   lda   tmp8
   asl
   asl
   asl
   asl
   tay
   lda   #$00
   sta   BRESENBASE,y
:
   iny
   lda   bresensteps,x
   sta   BRESENBASE,y
   inx
   cpx   #$0f
   bne   :-

   ldx   tmp8
   inx
   cpx   #$08
   bne   @loop

   ldx   #$00
@loop1:
   txa
   and   #$0f
   bne   :+
   lda   #$00
   sta   vector1+0
   sta   vector1+1
   sta   BRESENQUAD+$300,x
   sta   BRESENQUAD+$380,x
   inx
:
   lda   BRESENBASE,x
   and   #$10
   ora   #$01
   clc
   adc   vector1+0
   sta   vector1+0
   sta   BRESENQUAD+$300,x

   lda   BRESENBASE,x
   and   #$01
   ora   #$10
   clc
   adc   vector1+1
   sta   vector1+1
   sta   BRESENQUAD+$380,x

   inx
   bpl   @loop1

   ldx   #$00
:
   lda   BRESENQUAD+$300,x
   eor   #$0f
   sta   BRESENQUAD+$200,x
   eor   #$ff
   sta   BRESENQUAD+$100,x
   eor   #$0f
   sta   BRESENQUAD+$000,x
   inx
   bne   :-
   rts


   lda   BRESENBASE,y
   and   #$10
   ora   #$01
   sta   BRESENQUAD+$300,y
   eor   #$ff
   sta   BRESENQUAD+$000,y
   lda   BRESENBASE,y
   and   #$01
   ora   #$10
   sta   BRESENQUAD+$380,y
   eor   #$ff
   sta   BRESENQUAD+$080,y

   iny
   bpl   :-

   rts

