
.include "fb32x32.inc"

.include "globals.inc"

; lossoman_mem @  $e400
.define  XPOS     $e500
.define  SINE     $e600
.define  BARS     $e800

.segment "DATA"

colordata:
   ; red
   .byte $40,$80,$c0,$c3
   ; green
   .byte $10,$20,$30,$33
   ; blue
   .byte $04,$08,$0c,$0f
   ; yellow (red+green)
   .byte $50,$a0,$f0,$f3
   ; purple (red+blue)
   .byte $44,$88,$cc,$cf
   ; cyan (green+blue)
   .byte $14,$28,$3c,$3f
   ; white
   ;.byte $54,$a8,$fc,$ff
colordataend:

.define  BARSEND  >BARS + ( (colordataend-colordata) / 4 )

myschedule:
   .word $0000, kefrens_init
   .word $0001, kefrens_inc
.if SHORTEST
   .word $0080, kefrens_losso
   .word $0100, kefrens_losso_fast
   .word $0140, kefrens_show
   .word $017f, schedulenext
.else
   .word $0100, kefrens_losso
   .word $0180, kefrens_losso_fast
   .word $01c0, kefrens_show
   .word $01ff, schedulenext
.endif

sinpos   = localram+0
numbars  = sinpos+1
coloridx = numbars+1
man_xpos = coloridx+1

.segment "CODE"

kefrens:
   lda   #<myschedule
   ldx   #>myschedule
   jmp   subschedule


kefrens_init:
   lda   #FB32X32_CMAP_RGBI2222
   sta   FB32X32_COLMAP

   lda   #$01
   sta   numbars
   stz   sinpos
   stz   man_xpos

   asl                     ;lda   #$02
   ldx   #>SINE
   int   GENSINE

   ldx   #$00
   ldy   #$00
:
   lda   SINE,x
   clc
   adc   SINE,y
   lsr
   sta   XPOS,x
   dey
   dey
   dey
   inx
   bne   :-

; adjust sine table to max of 28
   ;ldx   #$00
:
   ; subtract 1/8th
   lda   XPOS,x
   lsr
   lsr
   lsr
   eor   #$ff
   sec
   adc   XPOS,x
   sta   XPOS,x
   inx
   bne   :-

   lda   #>BARS
   stz   vector+0
   sta   vector+1

   stz   tmp8

@preploop:
   ; generate top
   ldy   #$00
   ldx   tmp8
   lda   colordata,x

@toploop:
   sta   (vector),y
   iny
   cpy   #$04
   bcc   @toploop

@barloop:
   tya
   and   #$03
   ;eor   #$03              ; light from other side
   ora   tmp8
   tax
   lda   colordata,x
   sta   (vector),y

   iny
   bpl   @barloop
   inc   vector+1

   lda   tmp8
   clc
   adc   #$04
   sta   tmp8
   cmp   #<(colordataend-colordata)
   bne   @preploop

   jsr   lossoman_generate

   ;jmp   clearfb
   jsr   clearfb
   bra   kefrens_show

kefrens_inc:
   lda   frmcnt
.if SHORTEST
   and   #$07
.else
   and   #$0f
.endif
   bne   :+
   lda   numbars
   inc
   cmp   #$11
   bcs   :+
   sta   numbars
:
   ; fall through

kefrens_show:
   jsr   kefrens_clear
   ; the last is copied again, so what?
   stz   FB32X32_COPY
   rts

kefrens_losso_fast:
   lda   #$0c
   sta   numbars

   jsr   kefrens_clear

   lda   frmcnt
   eor   #$ff
   and   #$3f
   bra   kefrens_losso_common

kefrens_losso:
   lda   #$0c
   sta   numbars

   jsr   kefrens_clear

   lda   frmcnt
   lsr

   lda   man_xpos
   bcc   kefrens_losso_common
   dec
   bpl   kefrens_losso_common
   lda   #$3f
kefrens_losso_common:
   sta   man_xpos

   sec
   sbc   #$20
   bpl   :+
   ; negative: man walks out to left, need to truncate
   cmp   #$f1
   bcc   @none
   and   #$0f
   dec
   sta   FB32X32_WIDTH
   inc
   eor   #$0f
   inc
   sta   FB32X32_SRC+0
   stz   FB32X32_DEST_X
   bra   @done2
:
   cmp   #$11
   bcc   :+
   ; >$10: man walks in from left, need to truncate
   cmp   #$20
   bcs   @none
   sta   FB32X32_DEST_X
   eor   #$ff
   sec
   sbc   #$20
   sta   FB32X32_WIDTH
   bra   @done1
:
   ; normal range
   sta   FB32X32_DEST_X
   lda   #$0f
   sta   FB32X32_WIDTH
@done1:
   stz   FB32X32_SRC+0
@done2:
   lda   #$0f
   sta   FB32X32_HEIGHT
   sta   FB32X32_STEP
.if 0
   inc
.else
   lda   man_xpos
   and   #$01
   clc
   adc   #$0f
.endif
   sta   FB32X32_DEST_Y

   lda   #>lossoman_mem
   sta   FB32X32_SRC+1

   lda   #$01
   sta   FB32X32_COPYN

@none:
   ldx   numbars
   lda   #$10
   sta   numbars
   dec   sinpos
   dec   sinpos
   dec   sinpos
   jsr   kefrens_cont

   stz   FB32X32_COPY
   rts

kefrens_clear:
   ; clear background
   lda   #>FRAMEBUFFER
   stz   FB32X32_SRC+0
   sta   FB32X32_SRC+1
   stz   FB32X32_DEST+0
   stz   FB32X32_DEST+1
   lda   #$1f
   sta   FB32X32_WIDTH
   sta   FB32X32_HEIGHT
   sta   FB32X32_STEP
   stz   FB32X32_COPYN

kefrens_ontop:
   lda   #>BARS
   sta   coloridx
   ldx   #$00
kefrens_cont:
   lda   coloridx
   stz   FB32X32_SRC+0
   sta   FB32X32_SRC+1
   inc
   cmp   #BARSEND
   bcc   :+
   lda   #>BARS
:
   sta   coloridx

   txa
   asl                     ; *$02
   sta   FB32X32_DEST_Y

   asl                     ; *$04
   ;asl                     ; *$08
   sbc   sinpos
   tay
   lda   XPOS,y
   cmp   #$1c
   bcc   :+
   lda   #$1c
:
   sta   FB32X32_DEST_X

   lda   #$1f
   sta   FB32X32_HEIGHT
   lda   #$03
   sta   FB32X32_WIDTH
   sta   FB32X32_STEP
   stz   FB32X32_COPYN
   inx
   cpx   numbars
   bcc   kefrens_cont

   inc   sinpos
   inc   sinpos
   inc   sinpos

   rts
