
.include "globals.inc"

ZP_START := $10

.segment "ZEROPAGE"
; start at $10
tmp8:
   .res  1
features:
   .res  1                 ; $80 = music playing, $40 = loop demo to amiga, $20 stay in guru
partindex:
   .res  1
subpartindex:
   .res  1
frmcnt:
   .res  2
tm_hr:
   .res  1
tm_min:
   .res  1
tm_sec:
   .res  1
tm_frc:
   .res  1
irqcnt:
   .res  2
nmicnt:
   .res  2
vector:
vector1:
   .res  2
vector2:
   .res  2
lossoman_mode:             ; $80: jump, $40 arms, $20 stompdown, $10 buildup, $08 apply rotate
   .res  1
functionram:
   .res  $40
rotable      = functionram+$00   ; $10 bytes
bresensteps  = functionram+$00   ; $20 bytes
charbuffer   = functionram+$38   ; $08 bytes
localram:
   .res  ZP_BUFFERSIZE
localramend:

.out .sprintf("functionram:  $%02x", functionram-partindex+ZP_START)
.out .sprintf("localram:     $%02x", localram-partindex+ZP_START)
.out .sprintf("zeropage end: $%02x", localramend-partindex+ZP_START)
