"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true,
});
exports.default = rootRelativeCacheKeys;
var fastPath = _interopRequireWildcard(require("./fast_path"));
var _crypto = require("crypto");
function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function (nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}
function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || (typeof obj !== "object" && typeof obj !== "function")) {
    return { default: obj };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor =
    Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor
        ? Object.getOwnPropertyDescriptor(obj, key)
        : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}
/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 * @oncall react_native
 */

function moduleCacheKey(modulePath) {
  if (modulePath == null) {
    return null;
  }
  // $FlowFixMe[unsupported-syntax] - Dynamic require
  const moduleExports = require(modulePath);
  if (
    typeof (moduleExports === null || moduleExports === void 0
      ? void 0
      : moduleExports.getCacheKey) !== "function"
  ) {
    console.warn(
      `metro-file-map: Expected \`${modulePath}\` to export ` +
        "`getCacheKey: () => string`"
    );
    return null;
  }
  return moduleExports.getCacheKey();
}
function rootRelativeCacheKeys(buildParameters) {
  var _buildParameters$mock, _buildParameters$mock2;
  const rootDirHash = (0, _crypto.createHash)("md5")
    .update(buildParameters.rootDir)
    .digest("hex");

  // JSON.stringify is stable here because we only deal in (nested) arrays of
  // primitives. Use a different approach if this is expanded to include
  // objects/Sets/Maps, etc.
  const serializedConfig = JSON.stringify([
    buildParameters.roots.map((root) =>
      fastPath.relative(buildParameters.rootDir, root)
    ),
    buildParameters.extensions,
    buildParameters.platforms,
    buildParameters.computeSha1,
    (_buildParameters$mock =
      (_buildParameters$mock2 = buildParameters.mocksPattern) === null ||
      _buildParameters$mock2 === void 0
        ? void 0
        : _buildParameters$mock2.toString()) !== null &&
    _buildParameters$mock !== void 0
      ? _buildParameters$mock
      : null,
    buildParameters.ignorePattern.toString(),
    moduleCacheKey(buildParameters.hasteImplModulePath),
    moduleCacheKey(buildParameters.dependencyExtractor),
    buildParameters.computeDependencies,
    buildParameters.cacheBreaker,
  ]);
  const relativeConfigHash = (0, _crypto.createHash)("md5")
    .update(serializedConfig)
    .digest("hex");
  return {
    rootDirHash,
    relativeConfigHash,
  };
}
