"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.withWebResolvers = withWebResolvers;
exports.shouldAliasAssetRegistryForWeb = shouldAliasAssetRegistryForWeb;
exports.withMetroMultiPlatformAsync = withMetroMultiPlatformAsync;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _resolveFrom = _interopRequireDefault(require("resolve-from"));
var _env = require("../../../utils/env");
var _webSupportProjectPrerequisite = require("../../doctor/web/WebSupportProjectPrerequisite");
var _resolveFromProject = require("./resolveFromProject");
var _router = require("./router");
var _withMetroResolvers = require("./withMetroResolvers");
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function withWebPolyfills(config) {
    const originalGetPolyfills = config.serializer.getPolyfills ? config.serializer.getPolyfills.bind(config.serializer) : ()=>[]
    ;
    const getPolyfills = (ctx)=>{
        if (ctx.platform === "web") {
            return [];
        }
        // Generally uses `rn-get-polyfills`
        return originalGetPolyfills(ctx);
    };
    return {
        ...config,
        serializer: {
            ...config.serializer,
            getPolyfills
        }
    };
}
function normalizeSlashes(p) {
    return p.replace(/\\/g, "/");
}
function withWebResolvers(config, projectRoot) {
    // Get the `transformer.assetRegistryPath`
    // this needs to be unified since you can't dynamically
    // swap out the transformer based on platform.
    const assetRegistryPath = _fs.default.realpathSync(// This is the native asset registry alias for native.
    _path.default.resolve((0, _resolveFrom).default(projectRoot, "react-native/Libraries/Image/AssetRegistry")));
    // Create a resolver which dynamically disables support for
    // `*.native.*` extensions on web.
    const { resolve  } = (0, _resolveFromProject).importMetroResolverFromProject(projectRoot);
    const extraNodeModules = {
        web: {
            "react-native": _path.default.resolve(require.resolve("react-native-web/package.json"), "..")
        }
    };
    const aliases = {
        web: {
            "react-native": "react-native-web"
        }
    };
    const preferredMainFields = {
        // Defaults from Expo Webpack. Most packages using `react-native` don't support web
        // in the `react-native` field, so we should prefer the `browser` field.
        // https://github.com/expo/router/issues/37
        web: [
            "browser",
            "module",
            "main"
        ]
    };
    return (0, _withMetroResolvers).withMetroResolvers(config, projectRoot, [
        // Add a resolver to alias the web asset resolver.
        (immutableContext, moduleName, platform)=>{
            const context = {
                ...immutableContext
            };
            // Conditionally remap `react-native` to `react-native-web` on web in
            // a way that doesn't require Babel to resolve the alias.
            if (platform && platform in aliases && aliases[platform][moduleName]) {
                moduleName = aliases[platform][moduleName];
            }
            // TODO: We may be able to remove this in the future, it's doing no harm
            // by staying here.
            // Conditionally remap `react-native` to `react-native-web`
            if (platform && platform in extraNodeModules) {
                context.extraNodeModules = {
                    ...extraNodeModules[platform],
                    ...context.extraNodeModules
                };
            }
            const mainFields = _env.env.EXPO_METRO_NO_MAIN_FIELD_OVERRIDE ? context.mainFields : platform && platform in preferredMainFields ? preferredMainFields[platform] : context.mainFields;
            const result = resolve({
                ...context,
                preferNativePlatform: platform !== "web",
                resolveRequest: undefined,
                // Passing `mainFields` directly won't be considered
                // we need to extend the `getPackageMainPath` directly to
                // use platform specific `mainFields`.
                getPackageMainPath (packageJsonPath) {
                    // @ts-expect-error: mainFields is not on type
                    const package_ = context.moduleCache.getPackage(packageJsonPath);
                    return package_.getMain(mainFields);
                }
            }, moduleName, platform);
            // Replace the web resolver with the original one.
            // This is basically an alias for web-only.
            if (shouldAliasAssetRegistryForWeb(platform, result)) {
                // @ts-expect-error: `readonly` for some reason.
                result.filePath = assetRegistryPath;
            }
            return result;
        }, 
    ]);
}
function shouldAliasAssetRegistryForWeb(platform, result) {
    return platform === "web" && (result == null ? void 0 : result.type) === "sourceFile" && typeof (result == null ? void 0 : result.filePath) === "string" && normalizeSlashes(result.filePath).endsWith("react-native-web/dist/modules/AssetRegistry/index.js");
}
async function withMetroMultiPlatformAsync(projectRoot, config, platformBundlers) {
    // Auto pick App entry: this is injected with Babel.
    process.env.EXPO_ROUTER_APP_ROOT = (0, _router).getAppRouterRelativeEntryPath(projectRoot);
    var _EXPO_PROJECT_ROOT;
    process.env.EXPO_PROJECT_ROOT = (_EXPO_PROJECT_ROOT = process.env.EXPO_PROJECT_ROOT) != null ? _EXPO_PROJECT_ROOT : projectRoot;
    if (platformBundlers.web === "metro") {
        await new _webSupportProjectPrerequisite.WebSupportProjectPrerequisite(projectRoot).assertAsync();
    } else {
        // Bail out early for performance enhancements if web is not enabled.
        return config;
    }
    return withMetroMultiPlatform(projectRoot, config, platformBundlers);
}
function withMetroMultiPlatform(projectRoot, config, platformBundlers) {
    let expoConfigPlatforms = Object.entries(platformBundlers).filter(([, bundler])=>bundler === "metro"
    ).map(([platform])=>platform
    );
    if (Array.isArray(config.resolver.platforms)) {
        expoConfigPlatforms = [
            ...new Set(expoConfigPlatforms.concat(config.resolver.platforms))
        ];
    }
    // @ts-expect-error: typed as `readonly`.
    config.resolver.platforms = expoConfigPlatforms;
    config = withWebPolyfills(config);
    return withWebResolvers(config, projectRoot);
}

//# sourceMappingURL=withMetroMultiPlatform.js.map