"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.resolveArgsAsync = resolveArgsAsync;
var _errors = require("../utils/errors");
var _variadic = require("../utils/variadic");
function resolveOptions(options) {
    if (options.fix && options.check) {
        throw new _errors.CommandError("BAD_ARGS", "Specify at most one of: --check, --fix");
    }
    if ([
        options.npm,
        options.pnpm,
        options.yarn
    ].filter(Boolean).length > 1) {
        throw new _errors.CommandError("BAD_ARGS", "Specify at most one of: --npm, --pnpm, --yarn");
    }
    return {
        ...options
    };
}
async function resolveArgsAsync(argv) {
    const { variadic , extras , flags  } = (0, _variadic).parseVariadicArguments(argv);
    (0, _variadic).assertUnexpectedVariadicFlags([
        "--check",
        "--fix",
        "--npm",
        "--pnpm",
        "--yarn"
    ], {
        variadic,
        extras,
        flags
    }, "npx expo install");
    return {
        // Variadic arguments like `npx expo install react react-dom` -> ['react', 'react-dom']
        variadic,
        options: resolveOptions({
            fix: !!flags["--fix"],
            check: !!flags["--check"],
            yarn: !!flags["--yarn"],
            npm: !!flags["--npm"],
            pnpm: !!flags["--pnpm"]
        }),
        extras
    };
}

//# sourceMappingURL=resolveOptions.js.map