const loaded = [];
const textures = [];
const canvas = setupCanvas();
const gl = canvas.getContext("webgl2");
gl.viewport(0, 0, canvas.width, canvas.height);
let program, timeLocation, resolutionLocation, mouseLocation, audiolocation, u_image0Location, u_image1Location, tex;
let click = false;
let lastMousePos = { x: 0, y: 0 };
let useResize = window.innerWidth === window.innerWidth || window.innerHeight === window.innerHeight;
const buffer = gl.createBuffer();
let actx,analyzer,numP,audioArray;

// loadShaders(ready);
// loadTextures();
let clicked = false;
document.body.addEventListener("click", () => {
    if (clicked) {
        return;
    }
    actx = new AudioContext();
    analyzer = actx.createAnalyser();
    numP = analyzer.frequencyBinCount;
    audioArray = new Uint8Array(numP);
    clicked = true;
    loadTextures();
});
function setupCanvas() {
    const c = document.createElement("canvas");
    c.id = "space";
    c.width = 1920;
    c.height = 1080;
    document.body.appendChild(c);
    window.addEventListener("resize", resize);
    document.addEventListener("mousemove", mousemove);
    c.addEventListener("mousedown", (e) => { click = true; });
    c.addEventListener("mouseup", (e) => { click = false; });
    return c;
}

function resize() {
    if (!useResize) {
        return;
    }
    var w = 1920;
    var h = 1080;
    canvas.width = w;
    canvas.height = h;
    console.log(w, h);
    gl.uniform2f(resolutionLocation, w, h);
    gl.viewport(0, 0, w, h);
}

function mousemove(e) {
    var cRect = canvas.getBoundingClientRect();              // Gets the CSS positions along with width/height
    var canvasX = Math.round(e.clientX - cRect.left);        // Subtract the 'left' of the canvas from the X/Y
    var canvasY = Math.round(e.clientY - cRect.top);
    var c = -1;
    var r = -1;
    if (click) {
        lastMousePos.x = canvasX / canvas.width;
        lastMousePos.y = canvasY / canvas.height;
        c = 1;
    } else {
        c = -1;
    }
    gl.uniform4f(mouseLocation, lastMousePos.x, lastMousePos.y, c, r);
}

function render(time) {
    if (time === 0) {
        console.log("running");
    }
    gl.uniform1f(timeLocation, time * 0.001);
    analyzer.getByteFrequencyData(audioArray);
    gl.texImage2D(gl.TEXTURE_2D, 0, gl.LUMINANCE, numP, 1, 0, gl.LUMINANCE, gl.UNSIGNED_BYTE, audioArray);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);

    gl.uniform1i(audiolocation, 0);
    gl.uniform1i(u_image0Location, 1);
    gl.uniform1i(u_image1Location, 2);
    gl.drawArrays(gl.TRIANGLES, 0, 6);


    requestAnimationFrame(render);
}

function ready() {

    gl.useProgram(program);
    let positionLocation = gl.getAttribLocation(program, "a_position");
    gl.bindBuffer(gl.ARRAY_BUFFER, buffer);
    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([
        -1.0, -1.0, 1.0, -1.0, -1.0, 1.0,
        -1.0, 1.0, 1.0, -1.0, 1.0, 1.0]), gl.STATIC_DRAW);
    gl.bindBuffer(gl.ARRAY_BUFFER, buffer);
    gl.enableVertexAttribArray(positionLocation);
    gl.vertexAttribPointer(positionLocation, 2, gl.FLOAT, false, 0, 0);
    gl.uniform2fv(resolutionLocation, [canvas.width, canvas.height]);
    requestAnimationFrame(render);
}
function loadImage(url, cb) {
    let image = new Image();
    image.onload = cb;
    image.src = url;
    return image;
}
function bindImage(image, texture) {
    let texcoordBuffer = gl.createBuffer();
    let texcoordLocation = gl.getAttribLocation(program, "a_texCoord");
    gl.bindBuffer(gl.ARRAY_BUFFER, texcoordBuffer);
    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([
        0.0, 0.0,
        1.0 + image.width, 0.0,
        0.0, 1.0,
        0.0, 1.0,
    ]), gl.STATIC_DRAW);
    gl.enableVertexAttribArray(texcoordLocation);
    gl.bindBuffer(gl.ARRAY_BUFFER, texcoordBuffer);
    gl.vertexAttribPointer(texcoordLocation, 2, gl.FLOAT, false, 0, 0);
    gl.bindTexture(gl.TEXTURE_2D, texture);
    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, image);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
}
function loadImages(images, cb) {

    let total = images.length;
    let done = () => {
        --total;
        if (total === 0) {
            cb(loaded);
        }
    };
    for (let url of images) {
        loaded.push(loadImage(url, done));
    }
}
let processedTextures;
function loadTextures() {
    let urls = ["../textures/credits0.png", "../textures/credits1.png"];
    loadImages(urls, (tex) => {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
        processedTextures = tex;
        loadShaders(ready);

    });
}
function loadShaders(cb) {
    fetch("shaders/vertex.shader")
        .then((res) => res.text())
        .then((text) => {
            program = gl.createProgram();
            buildShader(text, gl.VERTEX_SHADER, program);
            return fetch("shaders/fragment.shader");
        })
        .then((res) => res.text())
        .then((text) => {
            buildShader(text, gl.FRAGMENT_SHADER, program);
            gl.linkProgram(program);
            if (!gl.getProgramParameter(program, gl.LINK_STATUS)) {
                console.error("Cannot link program", gl.getProgramInfoLog(program));
            }
            timeLocation = gl.getUniformLocation(program, "u_time");
            resolutionLocation = gl.getUniformLocation(program, "u_resolution");
            mouseLocation = gl.getUniformLocation(program, "u_mouse");
            audiolocation = gl.getUniformLocation(program, "audioSampler");
            u_image0Location = gl.getUniformLocation(program, "u_credits0");
            u_image1Location = gl.getUniformLocation(program, "u_credits1");
            gl.uniform1i(audiolocation, tex);
            const audio = new Audio();
            audio.loop = false;
            // audio.autoplay = true;
            audio.addEventListener('canplay', () => {
                audio.play();
                const source = actx.createMediaElementSource(audio);
                source.connect(analyzer);
                analyzer.connect(actx.destination);


                for (let i = 0; i < loaded.length; i++) {
                    let texture = gl.createTexture();
                    gl.bindTexture(gl.TEXTURE_2D, texture);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, loaded[i]);
                    textures.push(texture);
                    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, loaded[i]);
                }
                gl.activeTexture(gl.TEXTURE1);
                gl.bindTexture(gl.TEXTURE_2D, textures[0]);
                gl.uniform1i(u_image0Location, 1);
                gl.activeTexture(gl.TEXTURE2);
                gl.bindTexture(gl.TEXTURE_2D, textures[1]);
                gl.uniform1i(u_image1Location, 2);
                tex = gl.createTexture();
                gl.activeTexture(gl.TEXTURE0);
                gl.bindTexture(gl.TEXTURE_2D, tex);
                gl.texImage2D(
                    gl.TEXTURE_2D,
                    0,            // level
                    gl.LUMINANCE, // internal format
                    numP,    // width
                    1,            // height
                    0,            // border
                    gl.LUMINANCE, // format
                    gl.UNSIGNED_BYTE,  // type
                    null);

                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                cb(0);
            });
            audio.src = "eScape.mp3";
            audio.load();
        })
        .catch((err) => {
            console.log(err);
        });
}

function buildShader(source, type, program) {
    let shader = gl.createShader(type);
    gl.shaderSource(shader, source);
    gl.compileShader(shader);
    if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
        console.error("Cannot compile shader\nSyntax error!", gl.getShaderInfoLog(shader));
        return;
    }
    gl.attachShader(program, shader);
}
