#include "rotris.h"
#include "songs.h"

.GLOBAL songTetris
.GLOBAL songTitle

@ SONG FORMAT
@ 
@ Each pattern consist of one channel only. Each channel has its
@ own pattern table. Instrument change can be performed in the pattern table
@ or in the pattern data. Notes are not assigned with an instrument,
@ the last instrument selected is the one used.
@ 
@ PATTERN DATA FORMAT
@ 
@    255 = end of pattern
@ 
@ bit 0-5
@ 
@      1 = cut note  (Feature removed)
@   2-47 = notes D3-B6
@  48-63 = parameter for effect
@ 
@ bit 6-7 (if note C3-B6)
@     0 = use default length 0
@     1 = use default length 1
@     2 = use default length 2
@    	3 = note length is in next byte
@ 
@ bit 6-7 (if parameter)
@    	0 = set temp volume (4,8,12,...,64)  (Feature removed)
@    	1 = set new default volume (4,8,12,...,64)  (Feature removed)
@     2 = volume envelope (decrease volum with parameter each tick) - valid until new note
@     3 = set instrument
@ 
@ PATTERN TABLE FORMAT
@ 
@   0- 63 = use pattern
@  64-127 = change instrument
@ 128-144 = change speed
@     253 = do nothing  (Feature removed)
@     255 = loop
@     
@ HEADER FORMAT
@ 
@   0 : Start speed (ticks/row)
@   1 : Start BPM
@ 2-4 : Default note lengths (0-2)
@   5 : Number of channels
@ 
@   Immediately following this is the pattern tables. The pattern table
@   for each channel is ended with 255 (loop). The pattern data follows
@   immediately after the last pattern table channel.
@ 		

@ SIZE: 332 bytes
songTetris:
	.byte 5,128  @ Start speed & BPM
	.byte 4,2,1  @ Default note lengths
	.byte 5      @ Number of channels
	
	@ Channel 0
	.byte SI(0),0,1
	.byte SI(1),0,1
	.byte SI(6),2
	.byte SI(0),0,1
	.byte SI(7),0,1
	.byte SI(6),2
	.byte LOOP

	@ Channel 1	
	.byte 4,4
	.byte SI(6),3
	.byte SI(1),0,1
	.byte SI(8),0,1
	.byte SI(6),3
	.byte LOOP
	
	@ Channel 2
	.byte SI(2)
	.byte 52,52,52,52,51,51,52,56,55,55,54,54,49,49,52,57
	.byte 52,52,52,52,51,51,52,56,55,55,54,54,49,49,52,57
	.byte 52,52,51,49,52,50,49,48,54,52,53,49,52,50,58
	.byte LOOP
	
	@ Channel 3	
	.byte 32,32,32,32,32,32,32,33
	.byte 32,32,32,32,32,32,32,33
	.byte 32,32,32,32,32,32,32,33
	.byte 32,32,32,32,32,32,32,33
	.byte 32,32,32,32,32,32,32,32
	.byte 32,32,32,32,32,32,32,33
	.byte LOOP
	
	@ Channel 4
	.byte SI(4),34,LOOP

	.byte PAT(0)
	.byte N(A4,0),N(E4,1),N(F4,1),N(G4,2),N(A4,2),N(G4,1),N(F4,1),N(E4,1),NS(D4,6)
	.byte N(F4,1),N(A4,0),N(G4,1),N(F4,1),N(E4,0),N(E4,1),N(F4,1),N(G4,0),N(A4,0),N(F4,0),N(D4,0),NS(D4,8)

	.byte PAT(1)
	.byte CUT(1),N(G4,0),N(Ai4,1),N(D5,2),N(Di5,2),N(D5,1),N(C5,1),N(Ai4,1),N(A4,0)
	.byte N(C4,1),N(F4,1),N(A4,0),N(G4,1),N(F4,1),NS(E4,6),N(F4,1),N(G4,0),N(A4,0),N(F4,0),N(D4,0),NS(D4,8)
	
	.byte PAT(2)
	.byte NS(A4,8),NS(F4,8),NS(G4,8),NS(E4,8),NS(F4,8),NS(D4,8),NS(Ci4,16)
	.byte NS(A4,8),NS(F4,8),NS(G4,8),NS(E4,8),N(F4,0),N(A4,0),N(D5,0),N(D5,0),VE(1),NS(Ci5,16)
	
	.byte PAT(3)
	.byte NS(F4,8),NS(D4,8),NS(E4,8),NS(Ci4,8),NS(D4,8),NS(Ai3,8),NS(A3,16)
	.byte NS(F4,8),NS(D4,8),NS(E4,8),NS(Ci4,8),N(D4,0),N(F4,0),N(F4,0),N(Ai4,0),VE(1),NS(A4,16)
	
	.byte PAT(4)
	.byte NS(1,128)
	
	.byte PAT(48),N(G3,1),N(G4,1),N(G3,1),N(G4,1)
	.byte PAT(49),N(A3,1),N(A4,1),N(A3,1),N(A4,1)
	.byte PAT(50),N(Ai3,1),N(Ai4,1),N(Ai3,1),N(Ai4,1)
	.byte PAT(51),N(C4,1),N(C5,1),N(C4,1),N(C5,1)
	.byte PAT(52),N(D4,1),N(D5,1),N(D4,1),N(D5,1)
	.byte PAT(53),N(E4,1),N(E5,1),N(E4,1),N(E5,1)
	.byte PAT(54),N(F4,1),N(F5,1),N(F4,1),N(F5,1)
	.byte PAT(55),N(G4,1),N(G5,1),N(G4,1),N(G5,1)
	.byte PAT(56),N(D4,1),N(D5,1),N(E4,1),N(F4,1)
	.byte PAT(57),NS(D4,8)
	.byte PAT(58),N(A3,1),N(A4,2),N(A4,2),N(A4,1),N(A4,1),NS(A4,8)

	.byte PAT(32) @ Bass drum &  snare
	.byte SIP(3),N(C5,0),SIP(5),N(C5,0)
	.byte PAT(33) @ Bass drum &  snare fill in
	.byte SIP(3),N(C5,1),SIP(5),N(C5,1),N(C5,1),N(C5,1)
	.byte PAT(34) @ Hihat
	.byte N(F5,1),N(F5,1),N(F5,1),N(F5,2),N(F5,2)
	.byte N(F5,1),N(F5,1),N(F5,1),N(F5,1)
	
	.byte PATEND

#ifndef SMALL

songTitle:
	.byte 3,175
	.byte 5,3,2
	.byte 3

@ Channel 0
	.byte SI(7),0
	.byte LOOP

@ Channel 1
	.byte SI(8),0
	.byte LOOP

@ Channel 2
	.byte SI(9)
	.byte 10,10,10,10, 10,10,10,10
	.byte 10,10,10,10, 10,10,10,10
	.byte 11,11,12,12, 13,13,13,13
	.byte 13,13,13,13, 14,15,14,15
	.byte 14,14,14,14, 16,16,15,15
	.byte 14,14,14,17
	.byte LOOP

	.byte PAT(0)
	.byte NS(1,80)
	.byte N(E4,0),N(B4,0),N(E5,0),N(B4,1),N(B4,2),N(C5,0),N(A4,0),N(B4,0),N(G4,1),N(G4,2),N(A4,0)
	.byte N(Fi4,0),N(G4,0),N(E4,1),N(E4,2),N(Fi4,0),N(Di4,0),N(E4,0),N(Fi4,1),N(Fi4,2),N(E4,0)
	.byte N(B3,0),N(Di4,0),N(Fi4,0),N(E4,0),N(B3,0),N(Fi4,0),N(Di4,0),N(E4,0),N(B4,0),N(E5,0)
	.byte N(B4,1),N(B4,2),N(C5,0),N(A4,0),N(B4,0),N(G4,1),N(G4,2),N(A4,0),N(Fi4,0),N(G4,0)
	.byte N(E4,1),N(E4,2),N(Fi4,0),N(Di4,0),N(E4,0),N(Fi4,1),N(Fi4,2),N(E4,0),N(B3,0),N(Di4,0)
	.byte N(Fi4,0),N(E4,0),N(B3,0),N(Fi4,0),N(Di4,0),NS(E4,30),N(Fi4,0),N(Di4,0),NS(E4,30),NS(Fi4,10)
	.byte N(G4,0),N(G4,1),N(G4,2),N(A4,0),N(Fi4,0),N(G4,0),N(G4,1),N(G4,2),N(A4,0),N(Fi4,0),NS(G4,30)
	.byte NS(A4,10),N(B4,0),N(B4,1),N(B4,2),N(C5,0),N(A4,0),N(B4,0),N(B4,1),N(B4,2),N(C5,0)
	.byte N(A4,0),NS(B4,30),NS(Ci5,10),N(D5,0),N(D5,1),N(D5,2),N(D5,0),N(D5,0),N(E5,0),N(D5,0)
	.byte N(D5,0),N(Ci5,0),N(D5,0),N(D5,1),N(D5,2),N(D5,0),N(D5,0),N(E5,0),N(D5,0),N(D5,0),N(Ci5,0)
	.byte N(D5,0),N(D5,1),N(D5,2),N(D5,0),N(D5,0),N(Ci5,0),N(Ci5,1),N(Ci5,2),N(Ci5,0),N(Ci5,0),N(C5,0)
	.byte N(C5,1),N(C5,2),N(C5,0),N(A4,0),N(Fi4,0),N(G4,0),N(A4,0),N(D4,0),N(A4,0),N(G4,0),N(E4,0)
	.byte NS(G4,10),N(E4,1),N(A4,2),N(G4,0),N(E4,0),N(A4,0),N(G4,0),N(E4,0),NS(G4,10),N(A4,1)
	.byte N(A4,2),N(G4,0),N(Fi4,0),NS(D4,30),NS(1,50)
	
	.byte PAT(10)
	.byte N(E4,0),N(E4,1),N(E4,2),N(B3,0),N(B3,0)   @ E2/E2/E2/B1/B1
	.byte PAT(11)
	.byte N(E4,0),N(E4,1),N(E4,2),N(Ci4,0),N(B3,0)  @ E2/E2/E2/C#1/B1
	.byte PAT(12)
	.byte N(E4,0),N(E4,1),N(E4,2),N(Ci4,0),N(G3,0)  @ E2/E2/E2/C#1/G1
	.byte PAT(13)
	.byte SIP(10),N(G3,0),N(D4,1),N(G3,2),SIP(9),N(D4,0),N(D4,0)   @ G2/D3/G2/D2/D2
	.byte PAT(14)
	.byte SIP(9),N(D4,0),N(D4,1),N(D4,2),N(D4,0),N(D4,0)   @ D2/D2/D2/D2/D2
	.byte PAT(15)
	.byte SIP(10),N(A3,0),N(A3,1),N(A3,2),N(A3,0),N(A3,0)   @ A2/A2/A2/A2/A2
	.byte PAT(16)
	.byte N(E4,0),N(E4,1),N(E4,2),N(E4,0),N(E4,0)   @ E2/E2/E2/E2/E2
	.byte PAT(17)
	.byte N(D4,0),N(D4,1),N(D4,2),NS(Di4,10)        @ D2/D2/D2/D#2
	
	.byte PATEND

#endif