DMA_ENABLE              =   0x80000000  @ DMA Enable
DMA_16BIT_BUS           =   0x00000000  @ Select Bus Size 16Bit
DMA_32BIT_BUS           =   0x04000000  @ Select Bus Size 32Bit
DMA_TIMMING_IMM         =   0x00000000  @ Run Immediately
DMA_TIMMING_SOUND       =   0x30000000  @ Run Sound FIFO Request
DMA_CONTINUOUS_ON       =   0x02000000  @ Continuous Mode ON
DMA_DEST_FIX            =   0x00400000  @ Select Source Fixed
DMA_DEST_INC            =   0x00000000  @ Select Destination Increment
DMA_SRC_FIX             =   0x01000000  @ Select Source Fixed
DMA_SRC_INC             =   0x00000000  @ Select Source Increment
OFFSET_REG_DMA1CNT_H    =   0xc6
OFFSET_REG_DMA1         =   0xbc        @ DMA 1
OFFSET_REG_DMA3         =   0xd4        @ DMA 3
OFFSET_REG_SOUNDCNT_X   =   0x84
OFFSET_REG_FIFO_A       =   0xa0
OFFSET_REG_TM0CNT       =   0x100       @ Timer 0
SOUND_DMG_ON            =   0x80        @ DMG Compatible Sound ON
OFFSET_REG_SOUNDCNT_H   =   0x82
BG_COLOR_256            =   0x0080      @ Select 256 colors
BG_SCREEN_SIZE_0        =   0x0000      @ Screen Size (256x256)
BG_SCREEN_SIZE_1        =   0x4000      @ Screen Size (512x256)
BG_PRIORITY_1           =   0x0001      @ BG 1st Priority
BG_PRIORITY_2           =   0x0002      @ BG 2nd Priority
BG_PRIORITY_3           =   0x0003      @ BG 3rd Priority
BG_SCREEN_BASE_SHIFT    =   8
DISP_MODE_1             =   0x0001      @ BG Mode 1
DISP_BG0_ON             =   0x0100      @ BG0 ON
DISP_BG1_ON             =   0x0200      @ BG1 ON
DISP_BG2_ON             =   0x0400      @ BG2 ON
BLD_BG1_1ST             =   0x0002      @ Select BG 1 1st Pixel
BLD_BG2_1ST             =   0x0004      @ Select BG 2 1st Pixel
BLD_BG0_2ND             =   0x0100      @ Select BG 0 2nd Pixel
BLD_A_BLEND_MODE        =   0x0040      @ Semi-transparent Mode
BLD_1ST_PIXEL_SHIFT     =   0
BLD_2ND_PIXEL_SHIFT     =   8
SWI_NO_DIV              =   6       @ Div()/DivRem()
SWI_NO_VBLANK_INTR_WAIT =   5       @ VBlankIntrWait()
A_BUTTON                =   0x0001      @ A Button
B_BUTTON                =   0x0002      @ B Button
START_BUTTON            =   0x0008      @ START
R_KEY                   =   0x0010      @ Right Button
L_KEY                   =   0x0020      @ Left Button
U_KEY                   =   0x0040      @ Up Button
D_KEY                   =   0x0080      @ Down Button
OFFSET_REG_STAT         =   0x4         @ Status
OFFSET_REG_BG0CNT       =   0x8         @ BG 0 Control
OFFSET_REG_BG1CNT       =   0xa         @ BG 1 Control
OFFSET_REG_BG2CNT       =   0xc         @ BG 2 Control
V_BLANK_INTR_FLAG       =   0x0001      @ V Blank Interrupt
PLTT                    =   0x05000000          @ Palette RAM
REG_BASE                =   0x04000000          @ Registers
VRAM                    =   0x06000000          @ VRAM
STAT_V_BLANK_IF_ENABLE  =   0x0008      @ V Blank Interrupt Request Enable
OFFSET_REG_BLDCNT       =   0x50        @ Blend Mode Control
OFFSET_REG_BLDALPHA     =   0x52        @ Semi-transparent Parameter
OFFSET_REG_DISPCNT      =   0x0         @ Display Control
EX_WRAM                 =   0x02000000          @ CPU External Work RAM
EX_WRAM_END             =   (EX_WRAM + 0x40000)
SWI_NO_BG_AFFINE_SET    =   14      @ BgAffineSet()
OFFSET_REG_BG2AFFINE    =   0x20        @ BG 2 Affine Transformation Parameters
REG_KEYINPUT            =   (REG_BASE + 0x130)  @ Key Input
CPU_WRAM                =   0x03000000          @ CPU Internal Work RAM
CPU_WRAM_END            =   (CPU_WRAM + 0x8000)
INTR_VECTOR_BUF         =   (CPU_WRAM_END - 0x4)@ Interrupt Branch Address
INTR_CHECK_BUF          =   (CPU_WRAM_END - 0x8)@ Interrupt Check
REG_IME                 =   (REG_BASE + 0x208)  @ Interrupt Master Enable
REG_IE                  =   (REG_BASE + 0x200)  @ Interrupt Enable
