// 2ppong.c AGBmain Entry point is contained here (main program loop)

#include <gba.h>
#include <sprite.h>
#include <levels.h>


/* structures */
typedef struct object_t
{
	int x,y;
	int dx,dy;

} object_t;

/* defines */
#define SPRITEPL1  (0)
#define SPRITEBALL (1)


/* globals */
object_t p1;			/* the paddle */
object_t ball;			/* the ball */
u8 clevelmap[32*20];	/* the level map */
u32 currentLevel = 0;	/* the current level */
u32 busted = 0;			/* progress in level */



/* function definitions */
void updateObjects();
void checkBallHitRoof();
void checkBallHitFloor();
void checkBallHitp1();
void checkBallHitLeftSide();
void checkBallHitRightSide();
void checkHitMap();
void launch_ball();





void draw_map(u32 lev)
{
	u32 x,y;
	u16* charmap = (u16*)0x06004000;
	u8* leveldata;

	leveldata = thelevels[lev].leveldata;

	/* clear the map */
	for (y=0;y<23*20;y++) clevelmap[y] = 0;

	/* load the tiles */
	for (y=0;y<10;y++)
	{
		for (x=0;x<30;x++)
		{
			*(charmap + (y*32) + x) = leveldata[(y*30) + x];
			clevelmap[(y*32) + x]	= leveldata[(y*30) + x];
		}
	}
}






void copyOamWaitVSync()
{
	u32 i;
	u16* spt		= (u16*)sprites;
    u16* oam		= (u16*)0x07000000;
	volatile u16* regdstat	= (volatile u16*)0x04000004;

	while (! (   *regdstat & 1   ) );

	for (i=0;i<128*4;i++)
	{
		oam[i] = spt[i];
	}	
}


void build_tiles()
{
	u32 i;
	u16 *tile_ram = (u16*)0x06000000;
	
	/* make the tiles */
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0101;		
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0202;		
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0303;
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0404;
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0505;
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0606;
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0707;
	for (i=0;i<32;i++)	*(tile_ram++) = 0x0808;

	u16 *tilepal_ram = (u16*)0x05000000;

	/* make colours */
	*(tilepal_ram + 1)  = RGB(31,0,0);
	*(tilepal_ram + 2)  = RGB(0,31,0);
	*(tilepal_ram + 3)  = RGB(0,0,31);
	*(tilepal_ram + 4)  = RGB(31,15,15);
	*(tilepal_ram + 5)  = RGB(15,31,15);
	*(tilepal_ram + 6)  = RGB(15,15,31);
	*(tilepal_ram + 7)  = RGB(15,15,15);
	*(tilepal_ram + 8)  = RGB(31,31,31);
}




int AgbMain(void)
{
	u32 i,j;

	/* 1) make the palette */
	u16 *pal_ram = (u16*)0x05000200;
	
	*(pal_ram+1) = 0x7fff;			// white 


	/* 2) make the sprites */
	u16 *sprite_ram = (u16*)0x06010000;
	
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0101;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0101;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0101;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0101;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		
	for (i=0;i<32;i++)	*(sprite_ram++) = 0x0000;		// the paddle + ball

	
	
	/* 3) move all sprites offscreen */
	for (i=0;i<128;i++)
	{
		sprites[i].attribute0 = 160;
		sprites[i].attribute1 = 240;
	}

	/* 4) set up the sprites */
	p1.x = 100;
	p1.y = 150;

	updateObjects();

	build_tiles();

	*((u16*)0x04000008) = BGCOLOR_256 | CHARMAP8; 
	
	draw_map(currentLevel);

	/* 5) copy sprite stuff into real oam */
	copyOamWaitVSync();

	/* 6) turn on the display */
	SetMode(MODE_0 | OBJ_ENABLE | BG0_ENABLE | OBJ_MAP_1D);

	launch_ball();

	for (;;)
	{
		if		(KEY_LEFT_PRESSED)  
		{
			if (p1.x>1) p1.x-=2;
		}
		else if (KEY_RIGHT_PRESSED)
		{
			if (p1.x < (239-32)) p1.x+=2;
		}
		if		(KEY_L_PRESSED && KEY_R_PRESSED)
		{
				currentLevel++; busted = 0;
				if (currentLevel>MAX_LEVELS) currentLevel = 0;
				draw_map(currentLevel);
				launch_ball();
		}

		ball.x += ball.dx;
		ball.y += ball.dy;

		checkBallHitRoof();
		checkBallHitFloor();
		checkBallHitp1();
		checkBallHitLeftSide();
		checkBallHitRightSide();
		checkHitMap();

		updateObjects();
		copyOamWaitVSync();
	
		for (i=0;i<3000;i++)
		{
			j++;
		}
	}

	return (0);
}



void updateObjects()
{
	p1.x &= 511;
	ball.x &= 511;

	sprites[SPRITEPL1].attribute0 = COLOR_256 | (p1.y & 0xff);
	sprites[SPRITEPL1].attribute1 = SIZE_64 | (p1.x);
	sprites[SPRITEPL1].attribute2 = 0;
	sprites[SPRITEBALL].attribute0 = COLOR_256 | (ball.y & 0xff);
	sprites[SPRITEBALL].attribute1 = SIZE_8 | (ball.x);
	sprites[SPRITEBALL].attribute2 = 0;
}


void checkBallHitRoof()
{
	if (ball.y <= 0)
	{ 
		ball.dy = ball.dy * -1;   
	}
}

void checkBallHitFloor()
{
	if (ball.y >= 160)
	{
		launch_ball();
	}
}

void checkBallHitp1()
{
	if ((ball.x >= p1.x) && (ball.x <= (p1.x + 32)) &&
		(ball.y == p1.y))
	{
		ball.dy = ball.dy * -1;
	}
}

void checkBallHitLeftSide()
{
	if (ball.x <= 0)
	{
		ball.dx = ball.dx * -1;
	}
}

void checkBallHitRightSide()
{
	if (ball.x >= 240)
	{
		ball.dx = ball.dx * -1;
	}
}

void checkHitMap()
{
	if (clevelmap[(((ball.y>>3) * 32) + (ball.x>>3))])
	{
		if (clevelmap[(((ball.y>>3) * 32) + (ball.x>>3))]==1)
		{
			busted++;
			if (busted>=thelevels[currentLevel].numblocks)
			{
				currentLevel++; busted = 0;
				if (currentLevel>MAX_LEVELS) currentLevel = 0;
				draw_map(currentLevel);
				launch_ball();
			}
		}

		clevelmap[(((ball.y>>3) * 32) + (ball.x>>3))]--;
		*((u16*)0x06004000 + ((ball.y>>3)*32) + (ball.x>>3))-=1;		

		// *very* crude test for which side was hit /
		if (((ball.y-ball.dy)&7)==0)	ball.dy *= -1;
		else							ball.dx *= -1;	
	}

}




void launch_ball()
{
	u32 i,j;
	
	ball.x = p1.x+12;
	ball.y = p1.y-8;
	
	while(1)
	{
		if		(KEY_LEFT_PRESSED)  
		{
			if (p1.x>0) { p1.x--; ball.x--; }
		}
		else if (KEY_RIGHT_PRESSED)
		{
			if (p1.x < (240-32)) { p1.x++; ball.x++; }
		}
		if     (KEY_A_PRESSED)
		{
				ball.dx =  1;
				ball.dy = -1;
				break;
		}
		if     (KEY_B_PRESSED)
		{
				ball.dx = -1;
				ball.dy = -1;
				break;
		}
		updateObjects();
		copyOamWaitVSync();
	
		for (i=0;i<3000;i++)
		{
			j++;
		}

	}

}



