    processor 6502
    include vcs.h
    include macro.h

    SEG CODE
    ;
    ; Peculiarities that unfortunately must be
    ; dealt with:
    ;
    ; * Harmony can't handle ROMs smaller than 2k
    ; * Stella can't handle ROMs smaller than 64B
    ;
    ; All three variants rely on ROM mirroring.
    ; To run the 16B version, build a diode array!
    ;
    org $1FF0
Start
    tax
Clear
    dex
    sta $0,X
    bne Clear
Loop
    lda #$0C
    sta COLUBK
    ; Can't branch to itself because Stella r dum
    bne Loop

    echo "ROM:", ($1FFC - *)d, "bytes left"

    org $1FFC
    ; This jumps to the LDA below because mirroring
    .word Start-2
    lda #0

