;the real mountainbytes / toblethrone
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: monje - coyote

;the original idea to code something that can draw lines
;from a data set came from the cover of the japanese novel
;"colorful" (karafuru) by eto mori. however trying to
;duplicate the image was not satisfying. so i tried to add
;mountains but that did not help either. the original is not
;suited for such a resolution i guess.

;but then i thought more and more about the mountains and
;decided to make a mountain. i drew one on paper to get a
;shape and then put this in front of the screen and followed
;the lines within the possibilities of the "engine". seeing
;the process alone made me happy simply because of the
;simple yet possible shapes. plus it is something completely
;different from my previous releases.

;the 1st version had 1 of 4 colors randomly chosen for the
;background. but that looked quite flat and empty. so i
;decided to have the sky painted with stripes. demoish'n'stuff.
;[still, one of the best (if not the best) 256b intro with stripes
;as background is "blub! II" by spin/abyss, released 01/2002.]

;i also added a bird as little extra but i dropped that as
;well because i made quite some gfx with birds. not a fan
;of a cross at the peak so a flag it became. but then i had
;to decide on colors. red really pops but looks plain.
;i played around. i also did not want to have
;a country flag up there. it took some time but then i
;realized that there is mountainbytes :D this solved 2
;problems: the flag and the title. given the date i did
;not want to hold on to the prod until then. so i made it
;an invitation because why not. and silly me thought that
;"b codes 4" would be my last release for a long time.
;but that's how it goes ... the traditional christmas coding.

;yes, red/white/red is peru and not switzerland. but since
;the peak is far away and there is only 1 row of pixels
;the cross becomes nothing but a white pixel.
;so this is as accurate as is gets ;)

org 100h
use16

;assuming: cx = 255 bx = ax = 0 vga mem = 0

start:   push 0a000h ;vga
         pop ds      ;set ds
         mov al,13h  ;320*200*256
         int 10h

main:
;mov byte[ds:bx],15 ;fill whole bg
inc byte[ds:bx]     ;-1b
inc bx             ;so the mountain is white
jnz main

;draw the outlines of the mountain
;ch = 0
;xor bx,bx ;# of data set
mov bp,17
xor dx,dx
mov bx,320 ;save bytes below
do_sets:
mov di,bp ;save at data set (lenght and set can be byte instead of word)
mov al,byte[cs:lenght+di-1] ;get line lenght
mov si,word[cs:pos+di+bp-2] ;get pos where to start at
line3:
mov cl,byte[cs:count+di-1]  ;get segment lenght/counter
line1:
mov word[ds:si],dx          ;draw a 2x2 black block
mov word[ds:si+bx],dx      ;at the current position

dec ax  ;count line lenght every step
jz out1 ;done when complete lenght has been drawn

add si,word[cs:step1+di+bp-2] ;move to next position
;dec cx
;jnz line1 ;do whole segment
loop line1
add si,bx;word[cs:step2+di+bx] ;move position of next segment
          ;having this as part of the data set would give way more freedom
          ;but in this case 17*2 bytes is just a waste
jmp line3 ;repeat until all pixels have been drawn

out1:
dec bp
jnz do_sets ;do all sets

mov dx,bx ;save 1b below

;in al,40h       ;create bg color
;imul si,ax,7031
;shr si,14 ;0..3
;mov cl,byte[cs:bgs+di] ;get color

;fill the sky with given color 0..6
mov al,47 ;width of stripe in the sky (+1 = adjust)
;bx = 320
;bp = 0
fill1:
xor si,si

dec ax    ;stripes give more to the eye than a single
jnz k     ;color
mov al,46 ;reset counter for stripe width
inc bp    ;next color
k:
mov cl,byte[cs:bgs+bp] ;get color

fill2:

cmp byte[ds:si+bx],ch;found pixel of mountain?
je no                ;-1 for adjustment not needed due to
mov byte[ds:si+bx],cl;choice of colors --> hidden error
                     ;but -2b

add si,dx;320
jnc fill2
no:
;mov byte[ds:bx+320*200],ch ;prevent display error (?)
dec bx
jnz fill1

dec dx;319
;this is a matter of whatever ...
;simply do the try and error ...
shade:
cmp byte[ds:bx],ch;border of mountain?
jne no3
go:
mov cl,16 ;init color when hitting black pixel
no3:
cmp byte[ds:bx],1;15 ;inside mountain? ( = original bg)
jne no2            ;no
mov byte[ds:bx],cl ;draw
adc al,bl          ;do stuff
;jnp no2
jg no2             ;this adds a fine texture

;inc cx             ;color
;cmp cl,31          ;management
;jna no2            ;maxed out?
;dec cx             ;keep the max color

cmp cl,31
je no2
inc cx

no2:
sub bx,dx;319
jnz shade          ;do whole screen

mov byte[ds:320*37+170],cl
mov word[ds:320*38+170],2900h;1e1dh;2929h
mov word[ds:320*38+172],290fh;1fh
mov byte[ds:320*39+170],cl

waiting: in al,60h            ;read keyboard buffer
         dec al               ;esc needs to be pressed several times
         jnz waiting          ;nothing so go on
breaker: ret
         nop
         nop
         nop

;bg colors
bgs db 68,91,93,102,102,67,14

;line will have this lenght
lenght db 80+25 ;1
       db 23    ;2
       db 36+9  ;3
       db 12    ;4
       db 18    ;5
       db 14+11 ;6
       db 21    ;7
       db 20    ;8
       db 34    ;9
       db 12    ;10
       db 54    ;11
       db 8     ;12
       db 18    ;13
       db 17    ;14
       db 30    ;15
       db 40    ;16
       db 30    ;17

;starting position of drawing
pos    dw 320*139+80+24 ;1
       dw 320*140+80    ;2
       dw 320*95+103    ;3
       dw 320*76+140    ;4
       dw 320*52+152    ;5
       dw 320*41+171-1  ;6
       dw 320*57+187    ;7
       dw 320*63+208    ;8
       dw 320*100+220   ;9
       dw 320*110+254   ;10
       dw 320*132+265   ;11
       dw 320*42+171    ;12
       dw 320*57+163    ;13
       dw 320*95+165    ;14
       dw 320*96+166    ;15
       dw 320*127+195   ;16
       dw 320*166+195   ;17

;lenght of line segment to draw
count  db 7  ;1
       db 15 ;2
       db 2  ;3
       db 12 ;4
       db 3  ;5
       db 10 ;6
       db 5  ;7
       db 1  ;8
       db 4  ;9
       db 1  ;10
       db 2  ;11
       db 1  ;12
       db 2  ;13
       db 7  ;14
       db 1  ;15
       db 1  ;16
       db 7  ;17

;movement of each pixel = drawing direction
step1  dw -1       ;1
       dw -319*2-1 ;2
       dw -319     ;3
       dw -319*2-1 ;4
       dw -319     ;5
       dw 321      ;6
       dw 1        ;7
       dw 321      ;8
       dw 1        ;9
       dw 321      ;10
       dw 1        ;11
       dw 319      ;12
       dw 1        ;13
       dw -319*2-1 ;14
       dw 1        ;15
       dw 0        ;16
       dw 321      ;17