{Functions to work with graphic into VGA 320x200x256 resolution.             }
{PCX and RAW files handling.                                                 }
{Some parts are taken from various sources and (c) by their authors.         }
{v3.1.4 (c) 17.06.2000 by Flying/Digital Reality                             }
Unit Video;

Interface

Uses
  ExitUnit;

Const
  vm_Text         = $03;   {⠭   ⥪⮢ ०}
  vm_Graphic      = $13;   {⠭   ᪮ ०}

{⠭  梥⮢}
  cl_Black        = 0;
  cl_Blue         = 1;
  cl_Green        = 2;
  cl_Cyan         = 3;
  cl_Red          = 4;
  cl_Magenta      = 5;
  cl_Brown        = 6;
  cl_LightGray    = 7;
  cl_DarkGray     = 8;
  cl_LightBlue    = 9;
  cl_LightGreen   = 10;
  cl_LightCyan    = 11;
  cl_LightRed     = 12;
  cl_LightMagenta = 13;
  cl_Yellow       = 14;
  cl_White        = 15;

{⠭  ࠧ襭 (  ᯮ)}
  X_Res = 320;
  Y_Res = 200;

{$IFNDEF DPMI}
  VSeg = $A000;  {祭 ᥣ}
{$ENDIF}

Type
{Palette}
  PPalette = ^TPalette;
  TPalette = array [0..255,1..3] of byte;

{Screen}
  PScreen = ^TScreen;
  TScreen = array [0..X_Res*Y_Res-1] of byte;

{Screen segment}
  TScreenBuf = word;

{Type TPoint used by DrawClipLine function}
  TPoint = record
    X,Y:real;
  end;

  TVertex = record
    X,Y,Z:longint;
  end;

  PRemapTable = ^TRemapTable;
  TRemapTable = array [0..255] of byte;

{  ࠭. 頥 TScreenBuf ᫥ ⨢ ࠭}
Function  CreateScreen(var Scr:PScreen):TScreenBuf;
Procedure DestroyScreen(Scr:PScreen);
Procedure SetScreen(Scr:PScreen);
Procedure ViewScreen;
Function  GetPScreen(ScrBuf:TScreenBuf):PScreen;
Function  GetTScreenBuf(Scr:PScreen):TScreenBuf;
Function  GetVideoMode:Byte;
Procedure SetVideoMode(Mode:Byte);
Procedure SetGFXMode;
Procedure SetTextMode;
Function  GetPixel(X,Y:Word):Byte;
Procedure SetPixel(X,Y:Word;Color:Byte);
Procedure Line(lnx1,lny1,lnx2,lny2:integer);
Procedure VLine(X,Y1,Y2:Integer;Col:byte);
Procedure HLine(Y,X1,X2:Integer;Col:byte);
Procedure Rectangle(X,Y,XS,YS:Integer;Col:byte);
Procedure Bar(X,Y,XS,YS:Integer;Col:byte);
Procedure GetSprite(SBuf:TScreenBuf;DBuf:pointer;X,Y:word;XS,YS:word);
Procedure PutSprite(SBuf:pointer;DBuf:TScreenBuf;X,Y:word;XS,YS:word);
Procedure GetPaletteItem(Index:Byte; var R,G,B:Byte);
Procedure SetPaletteItem(Index,R,G,B:Byte);
Procedure GetPalette(Pal:PPalette);
Procedure SetPalette(Pal:PPalette);
Procedure WaitVideo;
Procedure ClearScr;
Function  CheckPCX(Name:string):boolean;
Function  LoadPCX(Name:string;Buf:TScreenBuf;Pal:PPalette):byte;
Function  GetPCXSize(Name:string;var XS,YS:word):byte;
Function  GetPCXPalette(Name:string;Pal:PPalette):byte;
Procedure Copy32(SBuf,DBuf:pointer;Size:word);
Procedure MoveScreen(SBuf,DBuf:TScreenBuf);
Procedure RemapScreen(Scr:TScreenBuf;CurPal,Pal:PPalette);
Procedure SetClipBounds(l_bound,r_bound,u_bound,d_bound:integer);
Function  DrawClipLine(var xt1,yt1,xt2,yt2:integer):boolean;
{DrawClipLine returned in xt1,,yt1,xt2,yt2 clipped coordinates and True if}
{line was drawed.}
Function  LoadRAW(Name:string;Buf:TScreenBuf;Pal:PPalette):byte;
{뢠    ࠩ  ࠭  8bit HSI RAW image}
Function  WriteRAW(Name:string;Buf:PScreen;X,Y,XS,YS:integer;Pal:PPalette):byte;
{뢠    ࠩ  ࠭  PCX image}
Function  WritePCX(Name:string;Buf:PScreen;X,Y,XS,YS:integer;Pal:PPalette):byte;
Procedure DrawPolygone(v1,v2,v3:TVertex;PolyColor:byte);
Procedure ViewScaledSprite(Sprite:pointer;Buf:TScreenBuf;XSpr,YSpr:word;X,Y:integer;XS,YS:word);

Var
  isXOR:boolean;
  isColorKey:boolean;   {Set to TRUE if you want to use color 0 as color key}
  Color:byte;
  Palette:TPalette;
{$IFNDEF DPMI}
  Screen:TScreen absolute VSeg:0;
{$ENDIF}
  ScreenBuf:TScreenBuf;
  Bounds:array [1..4] of TPoint; {Bounds array. Used by DrawClipLine}
{$IFDEF DPMI}
  VSeg:word; {祭 ᥣ}
{$ENDIF}

Implementation

Uses
  Memory;

Type
  PCXHeader = record
    Manufacturer   : byte;
    Version        : byte;
    Encoding       : byte;
    bits_per_pixel : byte;
    xmin           : word;
    ymin           : word;
    xmax           : word;
    ymax           : word;
    hres           : word;
    vres           : word;
    palette        : array[0..47] of byte;
    reserved       : byte;
    color_planes   : byte;
    bytes_per_line : word;
    palette_type   : word;
    filler         : array[0..57] of byte;
  end;

Const
  RAWHeader:array [0..7] of byte =
    ($6D,$68,$77,$61,$6E,$68,$00,$04);

  Shift16 = 16;

Var
  PCXFile    : file;
  Header     : PCXHeader;

Function CreateScreen(var Scr:PScreen):TScreenBuf;
begin
  Scr:=MemAllocSeg(SizeOf(TScreen));
  if Scr=nil then
    halt(exit_NoMemory);
  CreateScreen:=ScreenBuf;
  SetScreen(Scr);
  ClearScr;
end;

Procedure DestroyScreen(Scr:PScreen);
begin
  if Seg(Scr^)=ScreenBuf then
    ScreenBuf:=VSeg;
  FreeMem(Scr,SizeOf(TScreen));
end;

Procedure SetScreen(Scr:PScreen);
begin
  ScreenBuf:=Seg(Scr^);
end;

Procedure ViewScreen;
begin
  MoveScreen(ScreenBuf,VSeg);
end;

Function GetPScreen(ScrBuf:TScreenBuf):PScreen;
var
  l:longint;
begin
  l:=ScrBuf;
  l:=l shl 16;
  GetPScreen:=PScreen(l);
end;

Function GetTScreenBuf(Scr:PScreen):TScreenBuf;
var
  l:longint;
begin
  l:=longint(Scr);
  l:=l shr 16;
  GetTScreenBuf:=l;
end;

Function GetVideoMode:Byte;
var
  tempVMode:Byte;
begin
  asm
    mov ah,$0f
    int $10
    mov tempvmode,al
  end;
  GetVideoMode:=tempVMode;
end;

Procedure SetVideoMode(Mode:Byte);
begin
  asm
    mov ah,0
    mov al,Mode;
    int $10
  end;
end;

Procedure SetGFXMode;
begin
  SetVideoMode(vm_Graphic);
end;

Procedure SetTextMode;
begin
  SetVideoMode(vm_Text);
end;

Function GetPixel(X,Y:Word):Byte;
begin
  GetPixel:=Mem[ScreenBuf:Y*X_Res+X];
end;

Procedure SetPixel(X,Y:Word;Color:Byte);
begin
  if (X<0) or (X>=X_Res) or (Y<0) or (Y>=Y_Res) then
    exit;
  if isColorKey and (Color=0) then
    exit;
  if isXOR then
    Mem[ScreenBuf:Y*X_Res+X]:=Mem[ScreenBuf:Y*X_Res+X] xor Color
  else
    Mem[ScreenBuf:Y*X_Res+X]:=Color;
end;

{Original line drawing routine by Sean Palmer}
Procedure Line(lnx1,lny1,lnx2,lny2:integer);
var
  lndd,lndx,lndy,lnai,lnbi,lnxi,lnyi:Integer;
begin
  if (lnx1=lnx2) and (lny1=lny2) then exit;
  if (lnx1<lnx2) then
    begin
      lnxi:=1;
      lndx:=lnx2-lnx1;
    end
  else
    begin
      lnxi:=(-1);
      lndx:=lnx1-lnx2;
    end;
  if (lny1<lny2) then
    begin
      lnyi:=1;
      lndy:=lny2-lny1;
    end
  else
    begin
      lnyi:=(-1);
      lndy:=lny1-lny2;
    end;
  SetPixel(lnx1,lny1,Color);
  if (lndx>lndy) then
    begin
      lnai:=(lndy-lndx)*2;
      lnbi:=lndy*2;
      lndd:=lnbi-lndx;
      repeat
        if (lndd>=0) then
          begin
            Inc(lny1,lnyi);
            Inc(lndd,lnai);
          end
        else
          Inc(lndd,lnbi);
        Inc(lnx1,lnxi);
        SetPixel(lnx1,lny1,Color);
      until (lnx1=lnx2);
    end
  else
    begin
      lnai:=(lndx-lndy)*2;
      lnbi:=lndx*2;
      lndd:=lnbi-lndy;
      repeat
        if (lndd>=0) then
          begin
            Inc(lnx1,lnxi);
            Inc(lndd,lnai);
          end
        else
          Inc(lndd,lnbi);
        Inc(lny1,lnyi);
        SetPixel(lnx1,lny1,Color);
      until (lny1=lny2);
    end;
end;

Procedure VLine(X,Y1,Y2:Integer;Col:byte);
var
  i:word;
  t:integer;
begin
  if Y1>Y2 then
  begin
    t:=Y1;
    Y1:=Y2;
    Y2:=t;
  end;
  for i:=Y1 to Y2 do
    SetPixel(X,i,Col);
end;

Procedure HLine(Y,X1,X2:Integer;Col:byte);
var
  i:word;
  t:integer;
begin
  if X1>X2 then
  begin
    t:=X1;
    X1:=X2;
    X2:=t;
  end;
  for i:=X1 to X2 do
    SetPixel(i,Y,Col);
end;

Procedure Rectangle(X,Y,XS,YS:Integer;Col:byte);
var
  i:word;
  t:integer;
  x1,y1,x2,y2:integer;
begin
  x1:=x;
  y1:=y;
  x2:=x1+XS-1;
  y2:=y1+YS-1;
  HLine(Y1,X1,X2,Col);
  if Y1>Y2 then
  begin
    t:=Y1;
    Y1:=Y2;
    Y2:=t;
  end;
  for i:=Y1+1 to Y2-1 do
  begin
    SetPixel(X1,i,Col);
    SetPixel(X2,i,Col);
  end;
  HLine(Y2,X1,X2,Col);
end;

Procedure Bar(X,Y,XS,YS:Integer;Col:byte);
var
  Adr:word;
begin
  if isColorKey and (Col=0) then
    exit;
  Adr:=X_Res*Y+X;
  if isXOR then
    asm
      push  ds
      mov   ax,ScreenBuf
      mov   ds,ax
      mov   si,Adr
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
      mov   al,Col
@@1:
      mov   cx,XS
@@2:
      xor   [si],al
      inc   si
      loop  @@2
      add   si,dx
      dec   bx
      jnz   @@1
      pop   ds
    end
  else
    asm
      push  ds
      mov   ax,ScreenBuf
      mov   ds,ax
      mov   si,Adr
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
      mov   al,Col
@@1:
      mov   cx,XS
@@2:
      mov   [si],al
      inc   si
      loop  @@2
      add   si,dx
      dec   bx
      jnz   @@1
      pop   ds
    end;
end;

Procedure GetSprite(SBuf:word;DBuf:pointer;X,Y:word;XS,YS:word);
var
  Adr:word;
begin
  Adr:=X_Res*Y+X;
  if isXOR then
    asm
      push  ds
      mov   ax,SBuf
      mov   ds,ax
      mov   si,Adr
      les   di,DBuf
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
@@1:
      mov   cx,XS
@@2:
      mov   al,[si]
      xor   es:[di],al
      inc   si
      inc   di
      loop  @@2
      add   si,dx
      dec   bx
      jnz   @@1
      pop ds
    end
  else
    asm
      push  ds
      mov   ax,SBuf
      mov   ds,ax
      mov   si,Adr
      les   di,DBuf
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
@@1:
      mov   cx,XS
      rep   movsb
      add   si,dx
      dec   bx
      jnz   @@1
      pop ds
    end;
end;

Procedure PutSprite(SBuf:pointer;DBuf:word;X,Y:word;XS,YS:word);
var
  Adr:word;
begin
  Adr:=X_Res*Y+X;
  if not isXOR and not isColorKey then
  begin
    asm
      push  ds
      mov   ax,DBuf
      mov   es,ax
      mov   di,Adr
      lds   si,SBuf
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
@@1:
      mov   cx,XS
      rep   movsb
      add   di,dx
      dec   bx
      jnz   @@1
      pop   ds
    end;
    exit;
  end;
  if isXOR and not isColorKey then
  begin
    asm
      push  ds
      mov   ax,DBuf
      mov   es,ax
      mov   di,Adr
      lds   si,SBuf
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
@@1:
      mov   cx,XS
@@2:  mov   al,[si]
      xor   es:[di],al
      inc   si
      inc   di
      dec   cx
      jnz   @@2
      add   di,dx
      dec   bx
      jnz   @@1
      pop   ds
    end;
    exit;
  end;
  if not isXOR and isColorKey then
  begin
    asm
      push  ds
      mov   ax,DBuf
      mov   es,ax
      mov   di,Adr
      lds   si,SBuf
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
@@1:
      mov   cx,XS
@@2:  mov   al,[si]
      or    al,al
      jz    @@3
      mov   es:[di],al
@@3:  inc   si
      inc   di
      dec   cx
      jnz   @@2
      add   di,dx
      dec   bx
      jnz   @@1
      pop   ds
    end;
    exit;
  end;
  if isXOR and isColorKey then
  begin
    asm
      push  ds
      mov   ax,DBuf
      mov   es,ax
      mov   di,Adr
      lds   si,SBuf
      mov   dx,X_Res
      sub   dx,XS
      mov   bx,YS
@@1:
      mov   cx,XS
@@2:  mov   al,[si]
      or    al,al
      jz    @@3
      xor   es:[di],al
@@3:  inc   si
      inc   di
      dec   cx
      jnz   @@2
      add   di,dx
      dec   bx
      jnz   @@1
      pop   ds
    end;
    exit;
  end;
end;

{頥 祭 R,G,B   梥}
Procedure GetPaletteItem(Index:Byte;var R,G,B:Byte);
begin
  Port[$3C7]:=Index;
  R:=Port[$3C9];
  G:=Port[$3C9];
  B:=Port[$3C9];
end;

{⠭ 祭 R,G,B   梥}
Procedure SetPaletteItem(Index,R,G,B:Byte);
begin
  Port[$3C8]:=Index;
  Port[$3C9]:=R;
  Port[$3C9]:=G;
  Port[$3C9]:=B;
end;

Procedure GetPalette(Pal:PPalette);
var
  i:byte;
begin
  for i:=0 to 255 do
  begin
    Port[$3C7]:=i;
    Pal^[i,1]:=Port[$3C9];
    Pal^[i,2]:=Port[$3C9];
    Pal^[i,3]:=Port[$3C9];
  end;
end;

Procedure SetPalette(Pal:PPalette);
var
  i:byte;
begin
  for i:=0 to 255 do
  begin
    Port[$3C8]:=i;
    Port[$3C9]:=Pal^[i,1];
    Port[$3C9]:=Pal^[i,2];
    Port[$3C9]:=Pal^[i,3];
  end;
end;

Procedure WaitVideo;
begin
  asm
    mov dx,$03da
@c1:
    in al,dx
    test al,$08
    jnz @c1
@c2:
    in al,dx
    test al,$08
    jz @c2;
  end;
end;

Procedure ClearScr;
begin
  FillChar(Mem[ScreenBuf:0000],X_Res*Y_Res,0);
end;

{======= Internal functons needed by PCX functions =======}
Function ValidPCX : boolean;
var
  l:longint;
begin
  l:=FileSize(PCXFile);
  if l<SizeOf(Header) then
  begin
    ValidPCX:=false;
    exit;
  end;
  Seek(PCXFile,0);
  BlockRead(PCXFile,Header,SizeOf(Header));
  with Header do ValidPCX := (manufacturer   = 10) and
                             (version        = 5)  and
                             (bits_per_pixel = 8)  and
                             (color_planes   = 1);
end;

Function ValidPal : boolean;
var
  v : byte;
  l:longint;
begin
  l:=FileSize(PCXFile);
  if l<(SizeOf(Header)+769) then
  begin
    ValidPal:=false;
    exit;
  end;
  Seek(PCXFile,FileSize(PCXFile)-769);
  BlockRead(PCXFile,v,1);
  ValidPal := v=$0c;
end;

Function StartPCXWork(Name:string):byte;
begin
  Assign(PCXFile,Name);
{$I-}
  Reset(PCXFile,1);
{$I+}
  if IOResult<>0 then
  begin
    ErrorMessage:=Name;
    StartPCXWork:=exit_ErrorOpenFile;
    exit;
  end;
  if not ValidPCX then
  begin
    StartPCXWork:=exit_InvalidPCX;
    exit;
  end;
  if not ValidPal then
  begin
    StartPCXWork:=exit_InvalidPalette;
    exit;
  end;
  StartPCXWork:=exit_Ok;
end;

{======= Internal functons needed by PCX functions =======}

Function CheckPCX(Name:string):boolean;
var
  r:byte;
begin
  r:=StartPCXWork(Name);
  if r=exit_ErrorOpenFile then
  begin
    ErrorMessage:=Name;
    halt(r);
  end;
  close(PCXFile);
  if r=exit_Ok then
    CheckPCX:=true
  else
    CheckPCX:=false;
end;

Function LoadPCX(Name:string;Buf:word;Pal:PPalette):byte;
var
  gofs,gofs_sv,j : word;
  r,i,v,loop : byte;

label
  LoadPCX_1,
  LoadPCX_2;

begin
  r:=StartPCXWork(Name);
  if r<>exit_Ok then
  begin
    close(PCXFile);
    LoadPCX:=r;
    exit;
  end;
{Unpack image into buffer}
  Seek(PCXFile,128);
  gofs:=0;
  for i:=0 to Header.ymax-Header.ymin do
  begin
    gofs_sv:=gofs;
    j:=0;
    while j<Header.bytes_per_line do
    begin
      BlockRead(PCXFile,v,1);
      if (v and $c0)=$c0 then
        begin
          loop:=v and $3f;
LoadPCX_1:
          if j+loop>Header.bytes_per_line then
            begin
              FillChar(Mem[Buf:gofs],Header.bytes_per_line-j,v);
              inc(i);
              if i>Header.ymax-Header.ymin then goto LoadPCX_2;
              dec(loop,Header.bytes_per_line-j);
              j:=0;
              gofs:=gofs_sv+X_Res;
              gofs_sv:=gofs;
              goto LoadPCX_1;
            end
          else
            begin
              BlockRead(PCXFile,v,1);
              FillChar(Mem[Buf:gofs],loop,v);
              inc(gofs,loop);
              inc(j,loop);
            end;
        end
      else
        begin
          Mem[Buf:gofs]:=v;
          inc(gofs);
          inc(j);
        end;
    end;
    gofs:=gofs_sv+X_Res;
  end;
LoadPCX_2:
{Load palette}
  Seek(PCXFile,FileSize(PCXFile)-768);
  BlockRead(PCXFile,Pal^,768);
  for i:=0 to 255 do
    for j:=1 to 3 do
      Pal^[i,j]:=Pal^[i,j] shr 2;
  Close(PCXFile);
  LoadPCX:=exit_Ok;
end;

Function GetPCXSize(Name:string;var XS,YS:word):byte;
var
  r:byte;
begin
  r:=StartPCXWork(Name);
  if r<>exit_Ok then
  begin
    GetPCXSize:=r;
    exit;
  end;
  XS:=Header.xmax-Header.xmin+1;
  YS:=Header.ymax-Header.ymin+1;
  Close(PCXFile);
  GetPCXSize:=exit_Ok;
end;

Function GetPCXPalette(Name:string;Pal:PPalette):byte;
var
  r,i,j:byte;
begin
  r:=StartPCXWork(Name);
  if r<>exit_Ok then
  begin
    GetPCXPalette:=r;
    exit;
  end;
  Seek(PCXFile,FileSize(PCXFile)-768);
  BlockRead(PCXFile,Pal^,768);
  for i:=0 to 255 do
    for j:=1 to 3 do
      Pal^[i,j]:=Pal^[i,j] shr 2;
  Close(PCXFile);
  GetPCXPalette:=exit_Ok;
end;

Procedure Copy32(SBuf,DBuf:pointer;Size:word);
begin
  asm
    push ds
    les di,DBuf
    mov cx,Size
    shr cx,2
    lds si,SBuf
    db $f3,$66,$a5  {rep movsd}
    mov cx,Size
    and cx,3
    jz @end
    rep movsb
@end:
    pop ds
  end;
end;

Procedure MoveScreen(SBuf,DBuf:word);
begin
  asm
    push ds
    mov ax,SBuf
    mov ds,ax
    mov ax,DBuf
    mov es,ax
    xor si,si
    mov di,si
    mov cx,X_Res*Y_Res/4
    db $f3,$66,$a5  {rep movsd}
    pop ds
  end;
end;

Procedure RemapScreen(Scr:TScreenBuf;CurPal,Pal:PPalette);
var
  RemapTable : PRemapTable;
  i,j:integer;
  dist,min_dist:real;
  n:byte;
  R,G,B:byte;
  cR,cG,cB:byte;
begin
  New(RemapTable);
{Find the nearest color into new palette for each color from current palette}
  for i:=0 to 255 do
  begin
    min_dist:=10000000;
    n:=0;
    R:=CurPal^[i,1];
    G:=CurPal^[i,2];
    B:=CurPal^[i,3];
    for j:=0 to 255 do
    begin
      cR:=Pal^[j,1];
      cG:=Pal^[j,2];
      cB:=Pal^[j,3];
      dist:=sqrt((cR-R)*(cR-R)+(cG-G)*(cG-G)+(cB-B)*(cB-B));
      if dist<min_dist then
      begin
        min_dist:=dist;
        n:=j;
      end;
    end;
    RemapTable^[i]:=n;
  end;
  asm
    push ds
    mov ax,Scr
    mov es,ax
    xor di,di
    lds si,RemapTable
    xor bh,bh
    mov cx,X_Res*Y_Res-1
@1: mov bl,es:[di]
    or bl,bl
    jz @2
    mov al,[si+bx]
    mov es:[di],al
@2:
    inc di
    dec cx
    jnz @1
    pop ds
  end;
  Dispose(RemapTable);
end;

Procedure SetClipBounds(l_bound,r_bound,u_bound,d_bound:integer);
begin
  Bounds[1].X:=r_bound;
  Bounds[1].Y:=d_bound;
  Bounds[2].X:=r_bound;
  Bounds[2].Y:=u_bound;
  Bounds[3].X:=l_bound;
  Bounds[3].Y:=u_bound;
  Bounds[4].X:=l_bound;
  Bounds[4].Y:=d_bound;
end;

Function DrawClipLine(var xt1,yt1,xt2,yt2:integer):boolean;
var
  s,t:real;
  p1,p2,r1,r2:TPoint;
  i:integer;
  c1,c2:real;
  x1,y1,x2,y2:integer;
  px,py:real;
  rx,ry:real;
  v:real;
  p1v,p2v,prs:boolean;
begin
  DrawClipLine:=false;
  p1v:=true;
  p2v:=true;
  prs:=false;
  p1.x:=xt1;
  p1.y:=yt1;
  p2.x:=xt2;
  p2.y:=yt2;
  for i:=1 to 4 do
  begin
    r1:=Bounds[i];
    if i<>4-1 then
      r2:=Bounds[(i+1) mod 4]
    else
      r2:=Bounds[4];
    c1:=(r1.y-r2.y)*(p1.x-p2.x);
    c2:=(p1.y-p2.y)*(r1.x-r2.x);
    if c1=c2 then continue;
    t:=((r1.x-p1.x)*(r2.y-r1.y)-(r1.y-p1.y)*(r2.x-r1.x))/
       ((p2.x-p1.x)*(r2.y-r1.y)-(p2.y-p1.y)*(r2.x-r1.x));
    s:=((r1.y-p1.y)*(p2.x-p1.x)-(r1.x-p1.x)*(p2.y-p1.y))/
       ((r2.x-r1.x)*(p2.y-p1.y)-(p2.x-p1.x)*(r2.y-r1.y));
    rx:=r2.y-r1.y;
    ry:=-(r2.x-r1.x);
    px:=p1.x-r1.x;
    py:=p1.y-r1.y;
    v:=px*rx+py*ry;
    if v<0 then
    begin
      p1.x:=r1.x+(r2.x-r1.x)*s;
      p1.y:=r1.y+(r2.y-r1.y)*s;
      p1v:=false;
      if (s>0) and (s<1) then prs:=true;
    end;
    px:=p2.x-r1.x;
    py:=p2.y-r1.y;
    v:=px*rx+py*ry;
    if v<0 then
    begin
      p2.x:=r1.x+(r2.x-r1.x)*s;
      p2.y:=r1.y+(r2.y-r1.y)*s;
      p2v:=false;
      if (s>0) and (s<1) then prs:=true;
    end;
  end;
  if (not((p1v=false) and (p2v=false)) or (prs=true)) then
  begin
    x1:=round(p1.x);
    y1:=round(p1.y);
    x2:=round(p2.x);
    y2:=round(p2.y);
    if ((x1<Bounds[3].X) or (x1>Bounds[2].X)) or
       ((y1<Bounds[2].Y) or (y1>Bounds[1].Y)) or
       ((x2<Bounds[3].X) or (x2>Bounds[2].X)) or
       ((y2<Bounds[2].Y) or (y2>Bounds[1].Y)) then exit;
    if not ((x1=x2) and (y1=y2)) then
    begin
      Line(x1,y1,x2,y2);
      DrawClipLine:=true;
      xt1:=x1;
      xt2:=x2;
      yt1:=y1;
      yt2:=y2;
    end;
  end;
end;

Function LoadRAW(Name:string;Buf:word;Pal:PPalette):byte;
var
  i,j:word;
  xs,ys:word;
  f:file;
  Header:array[0..SizeOf(RAWHeader)-1] of byte;
  QPalItems:word;

Procedure ReadWord(var w:word);
var
  b:byte;
begin
  BlockRead(f,b,1);
  w:=b;
  w:=w shl 8;
  BlockRead(f,b,1);
  w:=w or b;
end;

begin
  Assign(f,Name);
{$I-}
  reset(f,1);
{$I+}
  if IOResult<>0 then
  begin
    LoadRAW:=exit_ErrorOpenFile;
    exit;
  end;
  BlockRead(f,Header,SizeOf(RAWHeader));
  for i:=0 to SizeOf(RAWHeader)-1 do
    if Header[i]<>RAWHeader[i] then
    begin
      LoadRAW:=exit_InvalidRAW;
      close(f);
      exit;
    end;
  ReadWord(XS);
  ReadWord(YS);
  ReadWord(QPalItems);
  if QPalItems=0 then
  begin
    LoadRAW:=exit_InvalidRAW;
    close(f);
    exit;
  end;
  for i:=1 to 9 do
    ReadWord(j);
  BlockRead(f,Pal^,3*QPalItems);
  for i:=0 to QPalItems-1 do
    for j:=1 to 3 do
      Pal^[i,j]:=Pal^[i,j] shr 2;
  for i:=0 to YS-1 do
    BlockRead(f,Mem[Buf:X_Res*i],XS);
  close(f);
  LoadRAW:=exit_Ok;
end;

Function WriteRAW(Name:string;Buf:PScreen;X,Y,XS,YS:integer;Pal:PPalette):byte;
var
  i:word;
  NewPal:TPalette;
  f:file;

Procedure WriteWord(w:word);
var
  b:byte;
begin
  b:=Hi(w);
  BlockWrite(f,b,1);
  b:=Lo(w);
  BlockWrite(f,b,1);
end;

begin
  Assign(f,Name);
{$I-}
  rewrite(f,1);
{$I+}
  if IOResult<>0 then
  begin
    WriteRAW:=exit_ErrorOpenFile;
    exit;
  end;
  for i:=0 to 255 do
  begin
    NewPal[i,1]:=Pal^[i,1]*4;
    NewPal[i,2]:=Pal^[i,2]*4;
    NewPal[i,3]:=Pal^[i,3]*4;
  end;
  BlockWrite(f,RAWHeader,Sizeof(RAWHeader));  {Header and version}
  WriteWord(XS);                              {X size}
  WriteWord(YS);                              {Y size}
  WriteWord(256);                             {Palette entries}
  for i:=1 to 9 do
    WriteWord(0);
  Blockwrite(f,NewPal,SizeOf(NewPal));
  for i:=0 to YS-1 do
    Blockwrite(f,PScreen(Buf)^[X_Res*(Y+i)+X],XS);
  close(f);
  WriteRAW:=exit_Ok;
end;

Function WritePCX(Name:string;Buf:PScreen;X,Y,XS,YS:integer;Pal:PPalette):byte;
Var
  f:file;
  LineNum:byte;

Procedure Write_Header;
const
  OldPal : array [1..48] of Byte =
       (0,0,0,216,152,56,120,116,4,112,108,4,236,
        172,76,248,196,128,64,36,36,36,40,20,248,
        188,104,212,144,156,60,36,36,116,112,8,
        120,116,8,124,120,8,52,48,4,240,196,136);
var
  b,l:byte;
  i:integer;
begin
  B := 10;                              (*  Manufacturer                *)
  BlockWrite (F,B,1);
  B := 5;                               (*  Version                     *)
  BlockWrite (F,B,1);
  B := 1;                               (*  Encoding                    *)
  BlockWrite (F,B,1);
  B := 8;                               (*  Bytes Per Pixel             *)
  BlockWrite (F,B,1);
  I := 0;                               (*  Min X                       *)
  BlockWrite (F,I,2);
  I := 0;                               (*  Min Y                       *)
  BlockWrite (F,I,2);
  I := XS-1;                            (*  Max X                       *)
  BlockWrite (F,I,2);
  I := YS-1;                            (*  Max Y                       *)
  BlockWrite (F,I,2);
  I := XS;                              (*  Horizontal Resolution       *)
  BlockWrite (F,I,2);
  I := YS;                              (*  Vertical Resolution         *)
  BlockWrite (F,I,2);                   (*  Default Palette             *)
  BlockWrite (F,Mem [Seg (OldPal):Ofs (OldPal)],48);
  B := 0;                               (*  Reserved                    *)
  BlockWrite (F,B,1);
  B := 1;                               (*  Color Planes                *)
  BlockWrite (F,B,1);
  I := XS;                              (*  Bytes Per Line              *)
  BlockWrite (F,I,2);
  I := 0;                               (*  Palette Type                *)
  BlockWrite (F,I,2);
  B := 0;
  for l:=1 to 58 do
    BlockWrite(f,b,1);
end;

Procedure Encode_Line(LineNum:byte);
var
  b:array [1..64] of byte;
  i,j,t:word;
  a:byte;
  p:array [0..X_Res-1] of byte;
begin
  I:=0;
  J:=0;
  T:=0;
  Move(Mem[ScreenBuf:LineNum*X_Res+X],P,XS);
  while T<XS do
  begin
    i:=0;
    while ((p[t+i]=p[t+i+1]) and ((t+i)<XS) and (i<63)) do
      inc(i);
    if i>0 then
      begin
        a:=i or $C0;
        BlockWrite(f,a,1);
        BlockWrite(f,p[t],1);
        inc(t,i);
        inc(j,2);
      end
    else
      begin
        if (((p[t]) and $C0)=$C0) then
        begin
           a:=$C1;
           BlockWrite(f,a,1);
           inc(j);
        end;
        BlockWrite(f,p[t],1);
        inc(t);
        inc(j);
      end;
  end;
end;

Procedure Write_Palette(Pal:PPalette);
var
  l,R,G,B:byte;
begin
  l:=12;
  BlockWrite(f,l,1);
  for l:=0 to 255 do
  begin
    R:=Pal^[l,1]*4;
    G:=Pal^[l,2]*4;
    B:=Pal^[l,3]*4;
    BlockWrite(f,R,1);
    BlockWrite(f,G,1);
    BlockWrite(f,B,1);
  end;
end;

begin
  Assign(f,Name);
{$I-}
  ReWrite(f,1);
{$I+}
  if IOResult<>0 then
  begin
    WritePCX:=exit_ErrorOpenFile;
    exit;
  end;
  Write_Header;
  for LineNum:=Y to Y+YS-1 do Encode_Line(LineNum);
  Write_Palette(Pal);
  Close(f);
  WritePCX:=exit_Ok;
end;

Procedure DrawPolygone(v1,v2,v3:TVertex;PolyColor:byte);
var
  Left_Array,Right_Array: array [0..2] of TVertex;
  Left_Section,
  Right_Section,
  left_section_height,
  right_section_height,
  left_x,
  delta_left_x,
  right_x,
  delta_right_x: longint;
  i,destptr,dest,x1:word;
  width:word;
  height,longest,t:longint;

Procedure Swap(var A,B:TVertex);
var
  t:TVertex;
begin
  t:=A;
  A:=B;
  B:=t;
end;

Function LeftSection:longint;
var
  v1,v2:TVertex;
begin
  v1:=left_array[left_section];
  v2:=left_array[left_section-1];
  height:=v2.Y-v1.Y;
  if height=0 then
  begin
    LeftSection:=0;
    exit;
  end;
{Calculate the deltas along this section}
  delta_left_x:=((v2.X-v1.X) shl Shift16) div height;
  left_x:=v1.X shl Shift16;
  left_section_height:=height;
  LeftSection:=height;               {return the height of this section}
end;

Function RightSection:longint;
var
  v1,v2:TVertex;
begin
  v1:=right_array[right_section];
  v2:=right_array[right_section-1];
  height:=v2.Y-v1.Y;
  if height=0 then
  begin
    RightSection:=0;
    exit;
  end;
{Calculate the deltas along this section}
  delta_right_x:=((v2.X-v1.X) shl Shift16) div height;
  right_x:=v1.X shl Shift16;
  right_section_height:=height;
  RightSection:=height;               {return the height of this section}
end;

begin
{Sorting coordinates by Y}
  if v1.Y>v2.Y then Swap(v1,v2);
  if v1.Y>v3.Y then Swap(v1,v3);
  if v2.Y>v3.Y then Swap(v2,v3);
{If height of the triangle=0 then exit}
  Height:=v3.Y-v1.Y;
  if Height=0 then exit;
{If length of longest scanline=0 then exit}
  t:=((v2.Y-v1.Y) shl Shift16) div Height;
  Longest:=t*(v3.X-v1.X)+((v1.X-v2.X) shl Shift16);
  if Longest=0 then exit;
{Now we must know, which side of the triangle is left and which is right...}
  if Longest<0 then
{We have the middle vertex on the right side.}
    begin
      right_array[0]:=v3;
      right_array[1]:=v2;
      right_array[2]:=v1;
      right_section :=2;
      left_array[0] :=v3;
      left_array[1] :=v1;
      left_section  :=1;
{Calculate initial left and right parameters}
      if LeftSection<=0 then exit;
      if RightSection<=0 then
      begin
{The first right section had zero height. Use the next section.}
        Dec(right_section);
        if RightSection<=0 then exit;
      end;
    end
  else
{We have the middle vertex on the left side.}
    begin
      left_array[0] :=v3;
      left_array[1] :=v2;
      left_array[2] :=v1;
      left_section  :=2;
      right_array[0]:=v3;
      right_array[1]:=v1;
      right_section :=1;
{Calculate initial right and left parameters}
      if RightSection<=0 then exit;
      if LeftSection<=0 then
      begin
{The first left section had zero height. Use the next section.}
        Dec(left_section);
        if LeftSection<=0 then exit;
      end;
    end;
  destptr:=X_Res*v1.Y;
  repeat
    x1:=left_x shr Shift16;
    width:=(right_x shr Shift16)-x1;
    if width>0 then
    begin
      dest:=destptr+x1;
      if (not isColorKey) or
         (isColorKey and (PolyColor<>0)) then
        asm
          mov ax,ScreenBuf
          mov es,ax
          mov di,dest
          mov cx,width
          mov bh,PolyColor
@1:
          mov es:[di],bh
          inc di
          dec cx
          jnz @1
        end;
    end;
    inc(destptr,X_Res);
{Interpolate along the left edge of the triangle}
    dec(left_section_height);
    if (left_section_height<=0) then  {At the bottom of this section?}
      begin
        dec(left_section);
        if left_section<=0 then exit;      {All sections done}
        if LeftSection<=0 then exit;       {Nope, do the last section}
      end
    else
      begin
        inc(left_x,delta_left_x);
      end;
{Interpolate along the right edge of the triangle}
    dec(right_section_height);
    if (right_section_height<=0) then     {At the bottom of this section?}
      begin
        dec(right_section);
        if right_section<=0 then exit;    {All sections done}
        if RightSection<=0 then exit;     {Nope, do the last section}
      end
        else
          inc(right_x,delta_right_x);
  until false;
end;

Procedure ViewScaledSprite(Sprite:pointer;Buf:word;XSpr,YSpr:word;X,Y:integer;XS,YS:word);
type
  TByteArray = array [0..$FFF0-1] of byte;
var
  dx,dy:word;
  px,py:word;
  b:byte;
  i,j:word;
begin
  dx:=(XSpr shl 8) div XS;
  dy:=(YSpr shl 8) div YS;
  py:=0;
  for i:=0 to YS-1 do
  begin
    px:=0;
    for j:=0 to XS-1 do
    begin
      b:=TByteArray(Sprite^)[Hi(py)*XSpr+Hi(px)];
      if (not isColorKey) or
         (isColorKey and (b<>0)) then
        Mem[Buf:(Y+i)*X_Res+(X+j)]:=b;
      inc(px,dx);
    end;
    inc(py,dy);
  end;
end;

BEGIN
{$IFDEF DPMI}
  VSeg:=SegA000;
{$ENDIF}
  Color:=cl_White;
  isXOR:=false;
  isColorKey:=false;
{$IFDEF USE_GRAPHICAL_TEXT}
  Font:=ft6x8;
{$ENDIF}
  ScreenBuf:=VSeg;
  SetClipBounds(0,0,X_Res-1,Y_Res-1);
END.
