; +======================================================================+
; | 256B Zero Bitplane Picture, for SOMMARHACK 2024, by Dyno / Hemoroids |
; +======================================================================+
; | Copyright (c) 2024 Frederic Poeydomenge <dyno@aldabase.com>          |
; +----------------------------------------------------------------------+
; | This program is free software: you can redistribute it and/or modify |
; | it under the terms of the GNU General Public License as published by |
; | the Free Software Foundation, either version 3 of the License, or    |
; | (at your option) any later version.                                  |
; |                                                                      |
; | This program is distributed in the hope that it will be useful,      |
; | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
; | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
; | GNU General Public License for more details.                         |
; |                                                                      |
; | You should have received a copy of the GNU General Public License    |
; | along with this program. If not, see <http://www.gnu.org/licenses/>. |
; +======================================================================+

VBL		= $70		; VBL interrupt vector
VIDEO_ADR_HIGH	= $FFFF8201		; Video screen memory position (High byte)
VIDEO_COUNTER	= $FFFF8209		; Video Counter LSB
SCREEN_FREQ		= $FFFF820A		; Video synchronization mode (0=60hz, 2=50hz)
PALETTE		= $FFFF8240		; Video palette register 0
MFP_ENABLE_A	= $FFFFFA07		; Interrupt Enable A

SPRITE		= 1		; 1 = Space invaders / 2 = HMD Banner

	OUTPUT	.TOS
	OPT	O+,D-,X-,P+

	; Supervisor-mode
	move.w	#32,-(sp)
	trap	#1

	; Initialize MFP 68901
	clr.l	MFP_ENABLE_A-1.w	; No timer A-B (FFFA07) C-D (FFFA09)

	; Set screen at $60000
	lea	$63000,a5
	move.l	a5,VIDEO_ADR_HIGH-1.w

	; Clear screen
	; d7 = $3000 (= 12288) ; x4(.L) = 49152 bytes
	move.w	a5,d7
clear_scr:	clr.l	(a5)+
	dbra	d7,clear_scr

;#============================#
;# Fill buffer and apply mask #
;#============================#

apply_mask:	move.w	#%1100100011000100,d6

	moveq	#34-1,d1
.row:	moveq	#64-1,d0
.col:
	move.w	d1,d3
	subq.w	#1,d3
	lsr.w	#2,d3

	move.w	d0,d2
	lsr.w	#2,d2

	addx.l	d1,d7
	roxr.l	d0,d7
	move.b	d7,-(a5)

	or.b	d6,(a5)
	and.b	#%1111,(a5)

	move.b	mask(pc,d2.w),d2
	btst	d3,d2
	bne.s	.pattern
	and.b	#%0011,(a5)
.pattern:
	ror.w	#4,d6
	dbra	d0,.col
	ror.w	#4,d6
	dbra	d1,.row

;#===============#
;# Generate code #
;#===============#

generate:	lea	generated_code(pc),a6
	move.l	#$E958C140,d2	; $E958 = rol.w #4,d0
				; $C140 = exg d0,d0
	moveq	#34-1,d6
.row:
	moveq	#8-1,d5
.line8:
	move.l	a5,a4

	moveq	#64-5-1,d4
.cols:	move.w	#$3E80,d0		; move.w d0,(a7)
	add.b	(a4)+,d0		; move.w d0..a7,(a7)
	move.w	d0,(a6)+		; [ 2] move.w d0..a7,(a7)
	dbra	d4,.cols

	; Change colors on the fly
	move.l	d2,d1		; exg d0,d0
	add.b	d5,d1		; exg d0,r0
	move.w	d1,(a6)+		; [  2] exg d0,rn
	move.l	d1,(a6)+		; [4+2] rol.w #4,d0 / exg d0,rn
	move.l	#$3E7C8240,(a6)+	; [  2] move.w #$8240,a7

	dbra	d5,.line8

	; Switch EXG opcode : $C140 (exg dn/dn) <=> $C188 (exg dn/an)
	eor.b	#%11001000,d2

	lea	64(a5),a5
	dbra	d6,.row

	move.w	#$4EF9,(a6)+	; jmp
	lea	end_vbl(pc),a2
	move.l	a2,(a6)+		;  .. end_vbl

;#==========#
;# Run demo #
;#==========#

	; Install Fullscreen VBL routine
	addq.w	#vbl-end_vbl,a2
	move.l	a2,VBL.w

	; Infinite loop
	bra.s	*

;#======#
;# Data #
;#======#

mask:	; Space invaders
	IFEQ SPRITE-1
	dc.b %00000000
	dc.b %01110000 ; arm
	dc.b %00011000
	dc.b %11111101 ; antenna
	dc.b %10110110 ; eye
	dc.b %10111100
	dc.b %00111100 ; center
	dc.b %10111100
	dc.b %10110110 ; eye
	dc.b %11111101 ; antenna
	dc.b %00011000
	dc.b %01110000 ; arm
	ENDC

	; HMD Banner
	IFEQ SPRITE-2
	dc.b %00000000
	dc.b %11111111 ; H
	dc.b %00001100
	dc.b %11111111
	dc.b %00000000
	dc.b %11111111 ; M
	dc.b %00000011
	dc.b %11111111
	dc.b %00000000
	dc.b %11111111 ; D
	dc.b %11000011
	dc.b %00111100
	ENDC

	dc.b %00000000
	even

palette:	dc.w $1101,$1201,$2101,$2110   ; background
	dc.w $3753,$2642,$1531,$0420
	dc.w $3735,$2624,$1513,$0402
	dc.w $3573,$2462,$1351,PALETTE

;#====================#
;# End of VBL Routine #
;#====================#

end_vbl:
	;lea	palette(pc),a7
	;movem.w	d0-d7/a0-a6,(a7)
	move.l usp,a7
	rte

;#========================#
;# Fullscreen VBL routine #
;#========================#

vbl:	; Disable interruptions
	move.w	#$2700,sr

	; Wait until reach HBL line 33
	move.w	#1073,d0
.wait_top:	subq.w	#1,d0
	bne.s	.wait_top

	; Backup a7
	move.l	a7,usp

	; Synchronisation with top of the screen
	move.b	d0,SCREEN_FREQ.w		; [ 3]
	moveq	#32,d0			; [ 1]
	lsr.l	d0,d0			; [18] 8+2n
	addq.b	#2,SCREEN_FREQ.w		; [ 4]
	; From here the top border is opened
.wait_sync:	move.b	VIDEO_COUNTER.w,d0
	beq.s	.wait_sync
	not.l	d0
	lsr.w	d0,d0
	; From here the code is synchronous with the scanning beam

	movem.w	palette(pc),d0-d7/a0-a7		; [19]

	; Jump to VBL Routine
	bra.s	*+72

SECTION BSS
generated_code:
	ds.b 35000
